/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight;

import com.crypticmushroom.minecraft.midnight.MidnightInfo;
import com.crypticmushroom.minecraft.midnight.MidnightMod;
import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.block.plant.FingeredGrassPlantBlock;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.MnEntity;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.MnLivingEntity;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.MnPlayer;
import com.crypticmushroom.minecraft.midnight.common.enchantment.BogStriderEnchantment;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Rifter;
import com.crypticmushroom.minecraft.midnight.common.entity.misc.UmbraLightningBolt;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.effects.MnBiomeEffectsPacket;
import com.crypticmushroom.minecraft.midnight.common.registry.MnAttributes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDamageTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMobEffects;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.common.world.manager.MidnightBiomeModifierManager;
import com.crypticmushroom.minecraft.midnight.common.world.manager.NightshadeTracker;
import com.crypticmushroom.minecraft.midnight.common.world.manager.RiftBridgeManager;
import com.crypticmushroom.minecraft.midnight.data.MidnightDataGen;
import com.crypticmushroom.minecraft.midnight.server.MidnightServer;
import com.google.common.reflect.Reflection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class Midnight {
    private static final Midnight INSTANCE;
    public static final Logger LOGGER;

    public void addEventListeners(IEventBus modBus) {
        LOGGER.debug(MidnightMod.INIT_MARKER, "Adding common event listeners");
        MinecraftForge.EVENT_BUS.addListener(this::onMissingMappings);
        modBus.addListener(MnEntityTypes::onAttributeCreation);
        modBus.addListener(EventPriority.LOWEST, MnEntityTypes::onSpawnPlacementRegistration);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::onAttachEntityCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerClone);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityFall);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityHurt);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityDamage);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityDeath);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onEntityStruckByLightning);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingEntityAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onLevelTick);
        MinecraftForge.EVENT_BUS.addListener(this::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
    }

    protected void preInit() {
        Reflection.initialize((Class[])new Class[]{MnNetwork.class});
    }

    protected void init() {
        Reflection.initialize((Class[])new Class[]{MnCriteriaTriggers.class});
    }

    protected void postInit() {
    }

    private void onMissingMappings(MissingMappingsEvent event) {
        event.getMappings(ForgeRegistries.Keys.BLOCKS, "midnight").forEach(mapping -> {
            if (mapping.getKey().equals((Object)Midnight.id("bristly_grass"))) {
                mapping.remap((Object)((Block)MnBlocks.FINGERED_GRASS.get()));
            }
        });
        event.getMappings(ForgeRegistries.Keys.ITEMS, "midnight").forEach(mapping -> {
            if (mapping.getKey().equals((Object)Midnight.id("bristly_grass"))) {
                mapping.remap((Object)((FingeredGrassPlantBlock)MnBlocks.FINGERED_GRASS.get()).m_5456_());
            }
        });
    }

    private void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_6095_() == MnEntityTypes.RIFT.get()) {
            return;
        }
        MnEntity.attach(event);
        MnLivingEntity.attach(event);
        MnPlayer.attach(event);
    }

    private void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerNew = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerOld = (ServerPlayer)player;
                if (!event.isWasDeath()) {
                    serverPlayerOld.reviveCaps();
                    MnEntity.ifPresent(serverPlayerNew, capabilityNew -> MnEntity.ifPresent(serverPlayerOld, capabilityOld -> capabilityNew.load(capabilityNew.save(new CompoundTag()))));
                    MnLivingEntity.ifPresent(serverPlayerNew, capabilityNew -> MnLivingEntity.ifPresent(serverPlayerOld, capabilityOld -> capabilityNew.load(capabilityNew.save(new CompoundTag()))));
                    MnPlayer.ifPresent((Player)serverPlayerNew, capabilityNew -> MnPlayer.ifPresent((Player)serverPlayerOld, capabilityOld -> capabilityNew.load(capabilityNew.save(new CompoundTag()))));
                    serverPlayerOld.invalidateCaps();
                }
            }
        }
    }

    private void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        MnLivingEntity.ifPresent(entity, entity.m_9236_().f_46443_ ? e -> e.clientTick(event) : e -> e.serverTick(event));
        if (!entity.m_9236_().f_46443_ && !Objects.equals(entity.f_20956_, entity.m_20183_())) {
            BogStriderEnchantment.onChangedBlock(entity);
        }
    }

    private void onLivingEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && entity.m_20096_() && event.getDistance() > 0.0f) {
            BogStriderEnchantment.onFall(entity);
        }
    }

    private void onLivingEntityHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7640_();
        if (event.getSource().m_276093_(MnDamageTypes.NIGHTSHADE_ROAR) && target.m_21023_((MobEffect)MnMobEffects.SHADE_SCREECH.get())) {
            int amplifier = target.m_21124_((MobEffect)MnMobEffects.SHADE_SCREECH.get()).m_19564_();
            event.setAmount((float)((int)event.getAmount() << amplifier + 1));
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (target.m_21204_().m_22171_((Attribute)MnAttributes.MALIGNANT_ARMOR.get())) {
                float malignantArmour = (float)target.m_21133_((Attribute)MnAttributes.MALIGNANT_ARMOR.get());
                ItemStack heldItem = ((LivingEntity)attacker).m_21205_();
                float amount = event.getAmount();
                if (heldItem.m_41782_() && heldItem.m_41783_().m_128441_("Gilded")) {
                    amount += malignantArmour / 2.0f;
                    if (!attacker.m_9236_().m_5776_()) {
                        ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175828_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 6, 0.1, 0.0, 0.1, 0.2);
                    }
                }
                event.setAmount(Math.max(1.0f, amount));
            }
        }
    }

    private void onLivingEntityDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7640_();
        if (attacker != null) {
            boolean shouldSetFire;
            boolean bl = shouldSetFire = source.m_269014_() ? attacker.m_6060_() : source.m_276093_(DamageTypes.f_268468_);
            if (shouldSetFire || attacker instanceof Zombie) {
                MnEntity.ifPresent(attacker, z -> {
                    if (z.isTakingUmbraflameDamage()) {
                        MnEntity.ifPresent(target, e -> e.setTakingUmbraflameDamage(true));
                    }
                });
            }
        }
    }

    private void onLivingEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().m_9236_().f_46443_ || event.getEntity().m_6095_() != MnEntityTypes.NIGHTSHADE.get()) {
            return;
        }
        NightshadeTracker.get().setNightshadeKilled();
    }

    private void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (!(event.getLightning() instanceof UmbraLightningBolt)) {
            return;
        }
        MnEntity.ifPresent(event.getEntity(), e -> e.setTakingUmbraflameDamage(true));
    }

    private void onLivingEntityAttack(LivingAttackEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268612_) && event.getEntity().m_20201_() instanceof Rifter) {
            event.setCanceled(true);
        }
    }

    private static float getRiftSpawnMultiplierForTime(long time) {
        if (time < 13500L || time > 22500L) {
            return 0.0f;
        }
        return 0.5f + 0.5f * Mth.m_14031_((float)((float)Math.PI * (float)(time - 6750L) / 4500.0f));
    }

    private void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RiftBridgeManager.get(event.side).update();
        } else if (!event.level.m_5776_() && !event.level.m_6907_().isEmpty()) {
            int chance;
            ServerLevel serverLevel = (ServerLevel)event.level;
            if (event.level.m_46472_() == Level.f_46428_) {
                float maxRiftChance = 1.0f / (500.0f / (float)event.level.m_6907_().size());
                float riftMultiplier = Midnight.getRiftSpawnMultiplierForTime(event.level.m_46468_());
                if (event.level.f_46441_.m_188501_() < maxRiftChance * riftMultiplier) {
                    Player player = (Player)event.level.m_6907_().get(event.level.m_213780_().m_188503_(event.level.m_6907_().size()));
                    ChunkPos chunkPos = new ChunkPos(player.m_146902_().f_45578_ + serverLevel.m_213780_().m_188503_(9) - 4, player.m_146902_().f_45579_ + serverLevel.m_213780_().m_188503_(9) - 4);
                    BlockPos targetPos = this.findLightningTargetAround(serverLevel, serverLevel.m_46496_(chunkPos.m_45604_(), 0, chunkPos.m_45605_(), 15));
                    if (!serverLevel.m_46749_(targetPos)) {
                        return;
                    }
                    Rift rift = (Rift)((EntityType)MnEntityTypes.RIFT.get()).m_20615_((Level)serverLevel);
                    if (rift != null) {
                        rift.m_20219_(Vec3.m_82539_((Vec3i)targetPos).m_82520_(0.0, 0.5, 0.0));
                        serverLevel.m_7967_((Entity)rift);
                        event.level.m_245803_((Entity)rift, rift.m_20183_(), (SoundEvent)MnSoundEvents.ENTITY_RIFT_EMERGENCE_IMPACT.get(), SoundSource.AMBIENT, 3.0f, 1.0f);
                        event.level.m_245803_((Entity)rift, rift.m_20183_(), (SoundEvent)MnSoundEvents.ENTITY_RIFT_EMERGENCE_LINGER.get(), SoundSource.AMBIENT, 4.0f, 0.8f + event.level.f_46441_.m_188501_() * 0.2f);
                    }
                }
            } else if (MnDimensions.THE_MIDNIGHT.is(event.level) && event.level.f_46441_.m_188503_(chance = 500 / event.level.m_6907_().size()) == 0) {
                Rift rift;
                boolean visualOnly;
                Player player = (Player)event.level.m_6907_().get(event.level.m_213780_().m_188503_(event.level.m_6907_().size()));
                int chunkRad = 5;
                ChunkPos chunkPos = new ChunkPos(player.m_146902_().f_45578_ + serverLevel.m_213780_().m_188503_(2 * chunkRad + 1) - chunkRad, player.m_146902_().f_45579_ + serverLevel.m_213780_().m_188503_(2 * chunkRad + 1) - chunkRad);
                BlockPos targetPos = this.findLightningTargetAround(serverLevel, serverLevel.m_46496_(chunkPos.m_45604_(), 0, chunkPos.m_45605_(), 15));
                if (!serverLevel.m_46749_(targetPos)) {
                    return;
                }
                UmbraLightningBolt lightningbolt = (UmbraLightningBolt)((EntityType)MnEntityTypes.UMBRA_LIGHTNING_BOLT.get()).m_20615_((Level)serverLevel);
                DifficultyInstance difficultyinstance = serverLevel.m_6436_(targetPos);
                boolean bl = visualOnly = serverLevel.m_46469_().m_46207_(GameRules.f_46134_) && serverLevel.f_46441_.m_188500_() < (double)difficultyinstance.m_19056_() * 0.01;
                if (lightningbolt != null) {
                    lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)targetPos));
                    lightningbolt.m_20874_(visualOnly);
                    serverLevel.m_7967_((Entity)lightningbolt);
                }
                if (event.level.f_46441_.m_188501_() < 0.3f && (rift = (Rift)((EntityType)MnEntityTypes.RIFT.get()).m_20615_((Level)serverLevel)) != null) {
                    rift.m_20219_(Vec3.m_82539_((Vec3i)targetPos).m_82520_(0.0, 0.5, 0.0));
                    serverLevel.m_7967_((Entity)rift);
                    event.level.m_245803_((Entity)rift, rift.m_20183_(), (SoundEvent)MnSoundEvents.ENTITY_RIFT_EMERGENCE_IMPACT.get(), SoundSource.AMBIENT, 3.0f, 1.0f);
                    event.level.m_245803_((Entity)rift, rift.m_20183_(), (SoundEvent)MnSoundEvents.ENTITY_RIFT_EMERGENCE_LINGER.get(), SoundSource.AMBIENT, 6.0f, 0.8f + event.level.f_46441_.m_188501_() * 0.2f);
                }
            }
        }
    }

    protected BlockPos findLightningTargetAround(ServerLevel level, BlockPos pos) {
        BlockPos blockpos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos);
        AABB aabb = new AABB(blockpos, new BlockPos(blockpos.m_123341_(), level.m_151558_(), blockpos.m_123343_())).m_82400_(3.0);
        List list = level.m_6443_(LivingEntity.class, aabb, p_275908_ -> p_275908_ != null && p_275908_.m_6084_() && level.m_45527_(p_275908_.m_20183_()));
        if (!list.isEmpty()) {
            return ((LivingEntity)list.get(level.f_46441_.m_188503_(list.size()))).m_20183_();
        }
        if (blockpos.m_123342_() == level.m_141937_() - 1) {
            blockpos = blockpos.m_6630_(2);
        }
        return blockpos;
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(pl -> MnNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new MnBiomeEffectsPacket(MidnightBiomeModifierManager.Server.get().getAll())));
        } else {
            MnNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new MnBiomeEffectsPacket(MidnightBiomeModifierManager.Server.get().getAll()));
        }
    }

    private void onServerStopped(ServerStoppedEvent event) {
        MidnightBiomeModifierManager.Server.get().reset();
    }

    public static Midnight get() {
        return INSTANCE;
    }

    @Nullable
    public static MinecraftServer getMinecraftServer() {
        try {
            return Objects.requireNonNull((MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static RegistryAccess getDynamicRegistries() {
        return Objects.requireNonNull(Midnight.getMinecraftServer(), "Cannot get dynamic registries when not in a Minecraft server!").m_206579_();
    }

    public static ResourceLocation id(String path) {
        return path.indexOf(58) >= 0 ? new ResourceLocation(path) : new ResourceLocation("midnight", path);
    }

    public static String idStr(String path) {
        return path.indexOf(58) >= 0 ? path : "midnight:" + path;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Midnight");
        LOGGER.debug(MidnightMod.INIT_MARKER, "Creating the Midnight instance");
        INSTANCE = (Midnight)DistExecutor.unsafeRunForDist(() -> MidnightInfo.DATAGEN ? MidnightDataGen::new : MidnightClient::new, () -> MidnightServer::new);
    }
}

