/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.SculkSnapper;
import com.kyanite.deeperdarker.content.entities.animations.SculkSnapperAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SculkSnapperModel
extends HierarchicalModel<SculkSnapper> {
    private final ModelPart root;
    private final ModelPart head;

    public SculkSnapperModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("root").m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition root = parts.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.75f, (float)-1.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-3.0f, -1.5f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)1.5f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-4.5f, -3.0f, -6.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(28, 3).m_171488_(-4.0f, -5.0f, -5.75f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(28, -5).m_171488_(4.25f, -5.0f, -5.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(28, -5).m_171488_(-4.25f, -5.0f, -5.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-0.5f));
        head.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(-8, 13).m_171488_(-1.5f, 0.0f, -8.0f, 3.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.36f, (float)3.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -3.0f, -9.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 26).m_171488_(-4.5f, -3.0f, -9.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.3f)).m_171514_(28, -8).m_171488_(4.0f, 0.0f, -8.5f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(28, 0).m_171488_(-4.0f, 0.0f, -8.5f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(28, -8).m_171488_(-4.0f, 0.0f, -8.5f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)3.0f));
        jaw.m_171599_("tendril", CubeListBuilder.m_171558_().m_171514_(33, 37).m_171488_(0.0f, -6.0f, -3.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition legs = root.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        legs.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.8f, -0.35f, -0.74f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.75f, (float)-3.4f, (float)-2.75f));
        legs.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.2f, -0.35f, -0.74f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.75f, (float)-3.4f, (float)-2.75f));
        legs.m_171599_("left_back_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(3.7f, -0.35f, -1.26f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.75f, (float)-3.4f, (float)1.75f));
        legs.m_171599_("right_back_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.7f, -0.35f, -1.26f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.75f, (float)-3.4f, (float)1.75f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)48, (int)48);
    }

    public void setupAnim(SculkSnapper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(SculkSnapperAnimation.WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        this.m_233381_(entity.idleState, SculkSnapperAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.attackState, SculkSnapperAnimation.BITE, ageInTicks);
        this.m_233381_(entity.sitState, SculkSnapperAnimation.SIT, ageInTicks);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_171324_("root").m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

