/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.types.builtin;

import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.types.IBountyObjective;
import io.ejekta.bountiful.bounty.types.Progress;
import io.ejekta.bountiful.data.PoolEntry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeCriteria;", "Lio/ejekta/bountiful/bounty/types/IBountyObjective;", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "entry", "Lnet/minecraft/world/entity/player/Player;", "player", "Lio/ejekta/bountiful/bounty/types/Progress;", "getProgress", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;Lnet/minecraft/world/entity/player/Player;)Lio/ejekta/bountiful/bounty/types/Progress;", "Lio/ejekta/bountiful/data/PoolEntry;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "isValid", "(Lio/ejekta/bountiful/data/PoolEntry;Lnet/minecraft/server/MinecraftServer;)Z", "", "Lnet/minecraft/network/chat/Component;", "textBoard", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;Lnet/minecraft/world/entity/player/Player;)Ljava/util/List;", "isObj", "Lnet/minecraft/network/chat/MutableComponent;", "textSummary", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;ZLnet/minecraft/world/entity/player/Player;)Lnet/minecraft/network/chat/MutableComponent;", "tryFinishObjective", "(Lio/ejekta/bountiful/bounty/BountyDataEntry;Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "<init>", "()V", "Bountiful"})
public final class BountyTypeCriteria
implements IBountyObjective {
    @NotNull
    private final ResourceLocation id = new ResourceLocation("criteria");

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean isValid(@NotNull PoolEntry entry, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return true;
    }

    @Override
    @NotNull
    public MutableComponent textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        MutableComponent textSum = entry.getName() != null ? Component.m_237113_((String)entry.getName()) : entry.getTranslation();
        Intrinsics.checkNotNullExpressionValue((Object)textSum, (String)"textSum");
        MutableComponent mutableComponent = this.colored((Component)textSum, progress.getColor()).m_7220_((Component)this.colored((Component)progress.getNeededText(), ChatFormatting.WHITE));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"textSum.colored(progress\u2026olored(Formatting.WHITE))");
        return mutableComponent;
    }

    @Override
    @NotNull
    public List<Component> textBoard(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.listOf((Object)(entry.getName() != null ? Component.m_237113_((String)entry.getName()) : entry.getTranslation()));
    }

    @Override
    @NotNull
    public Progress getProgress(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new Progress(entry.getCurrent(), entry.getAmount(), 0, 4, null);
    }

    @Override
    public boolean tryFinishObjective(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return entry.getCurrent() >= entry.getAmount();
    }
}

