/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.passive;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class JellyDrifterModel<T extends Entity>
extends ListModel<T> {
    protected final ModelPart cap;
    protected final ModelPart capTop;
    protected final ModelPart tentacleLeft;
    protected final ModelPart tentacleRight;
    protected final ModelPart tentacleBack;
    protected final ModelPart tentacleFront;

    public JellyDrifterModel(ModelPart model) {
        super(RenderType::m_110473_);
        this.cap = model.m_171324_("cap");
        this.capTop = model.m_171324_("cap_top");
        this.tentacleLeft = model.m_171324_("tentacle_left");
        this.tentacleRight = model.m_171324_("tentacle_right");
        this.tentacleBack = model.m_171324_("tentacle_back");
        this.tentacleFront = model.m_171324_("tentacle_front");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("cap", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 6.0f, 8.0f, size), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        root.m_171599_("cap_top", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 1.0f, 6.0f, size), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        root.m_171599_("tentacle_left", CubeListBuilder.m_171558_().m_171514_(20, 8).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, size), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        root.m_171599_("tentacle_right", CubeListBuilder.m_171558_().m_171514_(20, 8).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 11.0f, 6.0f, size), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        root.m_171599_("tentacle_back", CubeListBuilder.m_171558_().m_171514_(20, 14).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 11.0f, 0.0f, size), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)3.0f));
        root.m_171599_("tentacle_front", CubeListBuilder.m_171558_().m_171514_(20, 14).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 11.0f, 0.0f, size), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.tentacleFront, (Object)this.tentacleRight, (Object)this.capTop, (Object)this.tentacleLeft, (Object)this.cap, (Object)this.tentacleBack);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float capRotPoint;
        float tentacleRotPoint = !entityIn.m_20069_() ? 23.0f : 13.0f;
        float f = capRotPoint = !entityIn.m_20069_() ? 17.0f : 7.0f;
        if (entityIn.m_20069_()) {
            float moveAmount = limbSwingAmount * 0.8f;
            float animAmount = Mth.m_14089_((float)(ageInTicks * 0.07f)) * 0.1f;
            this.tentacleLeft.f_104205_ = animAmount + -moveAmount;
            this.tentacleRight.f_104205_ = -animAmount + moveAmount;
            this.tentacleFront.f_104203_ = animAmount + -moveAmount;
            this.tentacleBack.f_104203_ = -animAmount + moveAmount;
        } else {
            float squishAmount;
            this.tentacleLeft.f_104205_ = squishAmount = -1.5f;
            this.tentacleRight.f_104205_ = -squishAmount;
            this.tentacleFront.f_104203_ = squishAmount;
            this.tentacleBack.f_104203_ = -squishAmount;
        }
        this.tentacleLeft.f_104201_ = tentacleRotPoint;
        this.tentacleRight.f_104201_ = tentacleRotPoint;
        this.tentacleFront.f_104201_ = tentacleRotPoint;
        this.tentacleBack.f_104201_ = tentacleRotPoint;
        this.cap.f_104201_ = capRotPoint;
        this.capTop.f_104201_ = capRotPoint;
    }
}

