/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.structure_gel.api.config.ConfigBuilder;
import com.legacy.structure_gel.api.config.ConfigValueWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class BlueSkiesConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final CommonConfig COMMON;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class ClientConfig {
        private final ForgeConfigSpec.ConfigValue<Boolean> customPanorama;
        private final ForgeConfigSpec.ConfigValue<Boolean> limitBrightness;
        private final ForgeConfigSpec.ConfigValue<Boolean> useSimpleInventoryTabs;
        private final ForgeConfigSpec.ConfigValue<Boolean> invTabLeftAlign;
        private final ForgeConfigSpec.ConfigValue<Integer> invTabSimpleX;
        private final ForgeConfigSpec.ConfigValue<Integer> invTabSimpleY;
        private final ForgeConfigSpec.ConfigValue<Boolean> invTabIsVertical;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Visuals");
            this.customPanorama = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"custom_panorama", (String)"Should blue skies override the title screen panorama.", (boolean)true);
            this.limitBrightness = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"limit_brightness", (String)"Whether or not brightness should be capped when inside the dimensions for aesthetic purposes.", (boolean)true);
            builder.pop();
            builder.push("Inventory Tabs");
            this.useSimpleInventoryTabs = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"use_simple_inventory_tabs", (String)"If set to true, inventory tabs will use simple buttons that can be placed anywhere on the screen.", (boolean)false);
            builder.push("Sliding Tabs");
            this.invTabLeftAlign = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"left_align", (String)"If set to true, inventory tabs appear on the bottom left corner instead of the bottom right.", (boolean)false);
            builder.pop();
            builder.push("Buttons");
            this.invTabSimpleX = ConfigBuilder.makeConfig((ForgeConfigSpec.Builder)builder, (String)"x", (String)"The x position of the inventory tabs.", (Object)-88);
            this.invTabSimpleY = ConfigBuilder.makeConfig((ForgeConfigSpec.Builder)builder, (String)"y", (String)"The y position of the inventory tabs.", (Object)-83);
            this.invTabIsVertical = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"is_vertical", (String)"If set to true, inventory tabs are sorted vertically. If set to false, they are sorted horizontally.", (boolean)false);
            builder.pop();
            builder.pop();
        }

        public boolean isPanoramaCustom() {
            return (Boolean)this.customPanorama.get();
        }

        public boolean shouldLimitBrightness() {
            return (Boolean)this.limitBrightness.get();
        }

        public boolean useSimpleInventoryTabs() {
            return (Boolean)this.useSimpleInventoryTabs.get();
        }

        public boolean leftAlignInventoryTabs() {
            return (Boolean)this.invTabLeftAlign.get();
        }

        public int getInventoryTabX() {
            return (Integer)this.invTabSimpleX.get();
        }

        public int getInventoryTabY() {
            return (Integer)this.invTabSimpleY.get();
        }

        public boolean areInventoryTabsVertical() {
            return (Boolean)this.invTabIsVertical.get();
        }
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<Boolean> logMissingRegistryObjectForDatapack;
        private final ForgeConfigSpec.ConfigValue<Boolean> writeWorldRegionsToDisk;
        private final ForgeConfigSpec.ConfigValue<Boolean> crashOnMissingCapabilityForDungeon;
        private final ForgeConfigSpec.ConfigValue<Boolean> allowHalloweenContent;
        private final ForgeConfigSpec.ConfigValue<Boolean> allowChristmasContent;
        private final ForgeConfigSpec.ConfigValue<Integer> zealLighterCost;
        private final ConfigValueWrapper<List<? extends String>, Set<String>> allowedModsForFeatureGen;
        private final ConfigValueWrapper<List<? extends String>, Set<EntityType<?>>> allowedMobsForSpawning;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            builder.push("Debug");
            this.logMissingRegistryObjectForDatapack = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"log_missing_registry_data_for_datapacks", (String)"When loading files from datapacks, set this to true to log missing registry data for things like items.", (boolean)false);
            this.writeWorldRegionsToDisk = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"write_world_regions_to_disk", (String)"When true, generated world regions, 1024 blocks wide, will be saved as a file to make generating chunks faster in already visited areas. If file size is a concern or issues arise, this may be disabled.", (boolean)true);
            this.crashOnMissingCapabilityForDungeon = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"crash_on_missing_capability_for_dungeon", (String)"When printing \"Blue Skies' player capability wasn't present for...\", crash the game.", (boolean)false);
            builder.pop();
            builder.push("Holiday Content");
            this.allowHalloweenContent = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"allow_halloween_content", (String)"Determines if Halloween cosmetic effects should happen.", (boolean)true);
            this.allowChristmasContent = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"allow_christmas_content", (String)"Determines if Christmas cosmetic effects should happen.", (boolean)true);
            builder.pop();
            builder.push("Gatekeeper");
            this.zealLighterCost = ConfigBuilder.makeConfig((ForgeConfigSpec.Builder)builder, (String)"zeal_lighter_cost", (String)"The emerald cost for the Zeal Lighter sold by the Gatekeeper.", (Object)8);
            builder.pop();
            builder.push("Mod Compatibility");
            ForgeConfigSpec.ConfigValue features = ConfigBuilder.makeEmptyList((ForgeConfigSpec.Builder)builder, (String)"allowed_mods_for_feature_gen", (String)"A list of mods that are allowed to generate features in the Everbright and Everdawn.\n This does not make them generate, it just allows them to pass the filter.", List.of("minecraft", "farlanders", "botania"), new ArrayList(), o -> true);
            this.allowedModsForFeatureGen = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)features, l -> l.stream().collect(Collectors.toSet()), (IEventBus)bus, (String)"blue_skies");
            ForgeConfigSpec.ConfigValue mobs = ConfigBuilder.makeEmptyList((ForgeConfigSpec.Builder)builder, (String)"allowed_mobs_for_spawning", (String)"A list of mobs that are allowed to spawn in the Everbright and Everdawn.\n This does not make them spawn, it just allows them to pass the filter.", List.of("minecraft:bee", "moolands:awful_cow", "alexs_mobs:grizzly_bear"), new ArrayList(), o -> true);
            this.allowedMobsForSpawning = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)mobs, CommonConfig::parseAllowedSpawns, (IEventBus)bus, (String)"blue_skies");
            builder.pop();
        }

        public boolean shouldLogMissingRegistryObjectForDatapack() {
            return (Boolean)this.logMissingRegistryObjectForDatapack.get();
        }

        public boolean writeWorldRegionsToDisk() {
            return (Boolean)this.writeWorldRegionsToDisk.get();
        }

        public boolean crashOnMissingCapabilityForDungeon() {
            return (Boolean)this.crashOnMissingCapabilityForDungeon.get();
        }

        public boolean isHalloween() {
            return (Boolean)this.allowHalloweenContent.get() != false && BlueSkies.isHalloween;
        }

        public boolean isChristmas() {
            return (Boolean)this.allowChristmasContent.get() != false && BlueSkies.isChristmas;
        }

        public int getZealLighterCost() {
            return (Integer)this.zealLighterCost.get();
        }

        public boolean isModAllowedForFeatureGen(String mod) {
            return "blue_skies".equals(mod) || "minecraft".equals(mod) || ((Set)this.allowedModsForFeatureGen.get()).contains(mod);
        }

        public boolean isEntityAllowedToSpawn(EntityType<?> entityType) {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            return id != null && ("blue_skies".equals(id.m_135827_()) || ((Set)this.allowedMobsForSpawning.get()).contains(entityType));
        }

        private static Set<EntityType<?>> parseAllowedSpawns(List<? extends String> input) {
            Set entities = input.stream().filter(ResourceLocation::m_135830_).map(ResourceLocation::new).filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(arg_0)).collect(Collectors.toCollection(HashSet::new));
            entities.addAll(ImmutableSet.of((Object)EntityType.f_20492_, (Object)EntityType.f_20460_, (Object)EntityType.f_20553_, (Object)EntityType.f_20554_, (Object)EntityType.f_20556_, (Object)EntityType.f_20519_, (Object[])new EntityType[0]));
            return entities;
        }
    }
}

