/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.init;

import java.util.Arrays;
import java.util.EnumMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public class Registry {
    public static final EnumMap<DyeColor, RegistryObject<ElevatorBlock>> ELEVATOR_BLOCKS = new EnumMap(DyeColor.class);
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"elevatorid");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final RegistryObject<BlockEntityType<ElevatorTileEntity>> ELEVATOR_TILE_ENTITY;
    public static final EnumMap<DyeColor, RegistryObject<BlockItem>> ELEVATOR_ITEMS;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    public static final RegistryObject<MenuType<ElevatorContainer>> ELEVATOR_CONTAINER;
    private static final DeferredRegister<SoundEvent> SOUNDS;
    public static final RegistryObject<SoundEvent> TELEPORT_SOUND;
    public static final RegistryObject<SoundEvent> CAMOUFLAGE_SOUND;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS;
    private static final RegistryObject<CreativeModeTab> ELEVATORS_TAB;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        SOUNDS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
    }

    static {
        Arrays.stream(DyeColor.values()).forEach(color -> ELEVATOR_BLOCKS.put((DyeColor)color, (RegistryObject<ElevatorBlock>)BLOCKS.register("elevator_" + color.m_41065_(), () -> new ElevatorBlock((DyeColor)color))));
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"elevatorid");
        ELEVATOR_TILE_ENTITY = BLOCK_ENTITIES.register("elevator_tile", () -> BlockEntityType.Builder.m_155273_(ElevatorTileEntity::new, (Block[])((Block[])ELEVATOR_BLOCKS.values().stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        ELEVATOR_ITEMS = new EnumMap(DyeColor.class);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"elevatorid");
        ELEVATOR_BLOCKS.forEach((color, o) -> ELEVATOR_ITEMS.put((DyeColor)color, (RegistryObject<BlockItem>)ITEMS.register("elevator_" + color.m_41065_(), () -> new BlockItem((Block)o.get(), new Item.Properties()))));
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"elevatorid");
        ELEVATOR_CONTAINER = CONTAINERS.register("elevator_container", () -> IForgeMenuType.create((windowId, inv, data) -> new ElevatorContainer(windowId, data.m_130135_(), inv.f_35978_)));
        SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"elevatorid");
        TELEPORT_SOUND = SOUNDS.register("teleport", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("elevatorid", "teleport")));
        CAMOUFLAGE_SOUND = SOUNDS.register("camouflage", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("elevatorid", "camouflage")));
        CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"elevatorid");
        ELEVATORS_TAB = CREATIVE_TABS.register("elevators_tab", () -> CreativeModeTab.builder().m_257737_(() -> ((BlockItem)ELEVATOR_ITEMS.get(DyeColor.WHITE).get()).m_7968_()).m_257501_((params, output) -> ELEVATOR_ITEMS.values().forEach(item -> output.m_246326_((ItemLike)item.get()))).m_257941_((Component)Component.m_237115_((String)"itemGroup.elevators_tab")).m_257652_());
    }
}

