/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import reliquary.items.util.FilteredItemStack;
import reliquary.items.util.FilteredItemStackHandler;
import reliquary.reference.Settings;

public class VoidTearItemStackHandler
extends FilteredItemStackHandler {
    private static final int FIRST_SLOT = 0;

    public VoidTearItemStackHandler() {
        super(new ArrayList<FilteredItemStack>());
    }

    public void setContainedStack(ItemStack stack) {
        this.setFilteredStack(0, new FilteredItemStack(stack, (int)((Integer)Settings.COMMON.items.voidTear.itemLimit.get()), true));
    }

    public void setContainedStackAmount(int amount) {
        this.setTotalCount(0, amount);
    }

    public ItemStack getTotalAmountStack() {
        return this.getStackInSlot(0);
    }

    @Override
    protected boolean isValidForStackSlot(ItemStack stack, int stackSlot) {
        return stackSlot == 0 && super.isValidForStackSlot(stack, stackSlot);
    }

    public int getContainedAmount() {
        return this.getTotalAmount(0);
    }
}

