/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.infernaltear;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import reliquary.compat.jei.infernaltear.InfernalTearRecipe;
import reliquary.init.ModItems;
import reliquary.items.InfernalTearItem;
import reliquary.reference.Reference;
import reliquary.util.XpHelper;

public class InfernalTearRecipeCategory
implements IRecipeCategory<InfernalTearRecipe> {
    public static final RecipeType<InfernalTearRecipe> TYPE = RecipeType.create((String)"reliquary", (String)"infernal_tear", InfernalTearRecipe.class);
    private static final ResourceLocation BACKGROUNDS_TEXTURE = new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public InfernalTearRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BACKGROUNDS_TEXTURE, 0, 76, 110, 25);
        this.localizedName = Component.m_237115_((String)"jei.reliquary.recipe.infernal_tear");
        ItemStack iconTear = new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get());
        InfernalTearItem.setTearTarget(iconTear, new ItemStack((ItemLike)Items.f_42416_));
        this.icon = guiHelper.createDrawableItemStack(iconTear);
    }

    public RecipeType<InfernalTearRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfernalTearRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 0).addItemStack(recipe.getInput());
    }

    public void draw(InfernalTearRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int experiencePoints = recipe.getExperiencePoints();
        String points = experiencePoints + " " + Language.m_128107_().m_6834_("jei.reliquary.recipe.infernal_tear.xp");
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92895_(points);
        guiGraphics.m_280488_(fontRenderer, points, (int)((double)this.background.getWidth() / 2.0 + ((double)this.background.getWidth() / 2.0 + 16.0 - (double)stringWidth) / 2.0), 5, -8355712);
        this.drawLevels(guiGraphics, experiencePoints, fontRenderer);
    }

    private void drawLevels(GuiGraphics guiGraphics, int experiencePoints, Font fontRenderer) {
        int numberOfLevels = XpHelper.getLevelForExperience(experiencePoints);
        this.drawXpBar(guiGraphics, experiencePoints, numberOfLevels);
        this.drawXpLevel(guiGraphics, fontRenderer, numberOfLevels);
    }

    private void drawXpLevel(GuiGraphics guiGraphics, Font fontRenderer, int numberOfLevels) {
        String xpLevel = Integer.toString(numberOfLevels);
        int x = (this.background.getWidth() - fontRenderer.m_92895_(xpLevel)) / 2;
        int y = this.background.getHeight() - 10;
        guiGraphics.m_280488_(fontRenderer, xpLevel, x + 1, y, 0);
        guiGraphics.m_280488_(fontRenderer, xpLevel, x - 1, y, 0);
        guiGraphics.m_280488_(fontRenderer, xpLevel, x, y + 1, 0);
        guiGraphics.m_280488_(fontRenderer, xpLevel, x, y - 1, 0);
        guiGraphics.m_280488_(fontRenderer, xpLevel, x, y, 8453920);
    }

    private void drawXpBar(GuiGraphics guiGraphics, int experiencePoints, int level) {
        int partialXp = experiencePoints - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        if (partialXp == 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUNDS_TEXTURE);
        float textureWidth = 256.0f;
        float textureHeight = 256.0f;
        float minU = 0.0f;
        float minV = 101.0f;
        float maxU = 110.0f * ((float)partialXp / (float)maxBarExperience);
        float maxV = 106.0f;
        float width = maxU - minU;
        float height = maxV - minV;
        float x = 0.0f;
        float y = (float)this.background.getHeight() - 5.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        bufferBuilder.m_252986_(matrix, x, y + height, 0.0f).m_7421_(minU / textureWidth, maxV / textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(maxU / textureWidth, maxV / textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, x + width, y, 0.0f).m_7421_(maxU / textureWidth, minV / textureHeight).m_5752_();
        bufferBuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(minU / textureWidth, minV / textureHeight).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }
}

