/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.cauldron;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.cauldron.CauldronRecipeJEI;
import reliquary.init.ModBlocks;
import reliquary.reference.Reference;

public class CauldronRecipeCategory
implements IRecipeCategory<CauldronRecipeJEI> {
    public static final RecipeType<CauldronRecipeJEI> TYPE = RecipeType.create((String)"reliquary", (String)"cauldron", CauldronRecipeJEI.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public CauldronRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png"), 96, 0, 107, 51);
        this.localizedName = Component.m_237115_((String)"jei.reliquary.recipe.cauldron");
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get()));
    }

    public RecipeType<CauldronRecipeJEI> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CauldronRecipeJEI recipe, IFocusGroup focuses) {
        List<ItemStack> ingredientsInputs = recipe.getInputs();
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 33).addItemStack(ingredientsInputs.get(0));
        this.setAdditionalSlotContents(builder, ingredientsInputs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 33).addItemStack(recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 44, 33).addItemStack(new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get()));
    }

    private void setAdditionalSlotContents(IRecipeLayoutBuilder builder, List<ItemStack> inputs) {
        int left = 44 - (inputs.size() - 2) * 9;
        for (int i = 1; i < inputs.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, left + i * 18, 0).addItemStack(inputs.get(i));
        }
    }
}

