/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import reliquary.blocks.tile.BlockEntityBase;
import reliquary.init.ModBlocks;
import reliquary.util.InventoryHelper;

public class PassivePedestalBlockEntity
extends BlockEntityBase
implements Container {
    protected ItemStack item;
    private final IItemHandler inventoryWrapper = new InvWrapper((Container)this);

    public ItemStack getItem() {
        return this.item;
    }

    public PassivePedestalBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlocks.PASSIVE_PEDESTAL_TILE_TYPE.get(), pos, state);
    }

    PassivePedestalBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.item = ItemStack.f_41583_;
    }

    public void dropPedestalInventory(Level level) {
        if (!this.item.m_41619_()) {
            InventoryHelper.spawnItemStack(level, this.f_58858_, this.item);
        }
    }

    public void removeAndSpawnItem(Level level) {
        if (!this.item.m_41619_()) {
            if (!level.f_46443_) {
                this.m_6596_();
                ItemEntity itemEntity = new ItemEntity(level, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, this.item);
                level.m_7967_((Entity)itemEntity);
            }
            this.item = ItemStack.f_41583_;
        }
    }

    public int m_6643_() {
        return 1;
    }

    public ItemStack m_8020_(int index) {
        return index == 0 ? this.item : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        if (index == 0) {
            return this.decrStackInInventory(count);
        }
        return ItemStack.f_41583_;
    }

    private ItemStack decrStackInInventory(int count) {
        if (!this.item.m_41619_()) {
            ItemStack stack = this.item.m_41620_(count);
            if (this.item.m_41619_()) {
                this.notifyBlock();
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        if (index == 0) {
            ItemStack stack = this.item;
            this.item = ItemStack.f_41583_;
            this.notifyBlock();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void notifyBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), blockState, blockState, 3);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.item = nbt.m_128441_("item") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item")) : ItemStack.f_41583_;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.item.m_41619_()) {
            compound.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        }
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index == 0) {
            this.item = stack;
            this.notifyBlock();
        }
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index == 0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public boolean m_7983_() {
        return this.item.m_41619_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.inventoryWrapper));
        }
        return super.getCapability(cap, side);
    }
}

