/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2477;
import net.minecraft.class_5819;
import quilt.net.mca.MCAClient;
import quilt.net.mca.entity.ai.relationship.AgeState;
import quilt.net.mca.entity.ai.relationship.Personality;

public enum DialogueType {
    ADULT(null),
    ADULTP(ADULT),
    UNASSIGNED(ADULT),
    BABY(UNASSIGNED),
    CHILD(ADULT),
    CHILDP(CHILD),
    TODDLER(CHILD),
    TODDLERP(CHILDP),
    SPOUSE(ADULT),
    TEEN(ADULT),
    TEENP(TEEN),
    ENGAGED(ADULT);

    public final DialogueType fallback;
    private static final class_5819 random;
    private static final DialogueType[] VALUES;
    public static final Map<String, DialogueType> MAP;

    private DialogueType(DialogueType fallback) {
        this.fallback = fallback;
    }

    public DialogueType toChild() {
        return switch (this) {
            case TODDLER -> TODDLERP;
            case CHILD -> CHILDP;
            case TEEN -> TEENP;
            case ADULT -> ADULTP;
            default -> UNASSIGNED;
        };
    }

    public static DialogueType fromAge(AgeState state) {
        for (DialogueType t : DialogueType.values()) {
            if (!t.name().equals(state.name())) continue;
            return t;
        }
        return UNASSIGNED;
    }

    public static DialogueType byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    private static Optional<String> getPrefixedPhrase(DialogueType type, String prefix, String key) {
        String s;
        DialogueType t = type;
        while (t != null) {
            s = prefix + "." + t.name().toLowerCase(Locale.ENGLISH) + "." + key;
            if (class_2477.method_10517().method_4678(s)) {
                return Optional.of(s);
            }
            t = t.fallback;
        }
        s = prefix + "." + key;
        if (class_2477.method_10517().method_4678(s)) {
            return Optional.of(s);
        }
        return Optional.empty();
    }

    public static String applyFallback(String key) {
        Optional<String> p;
        String personality;
        Optional<String> p2;
        Optional<String> p3;
        if (!key.contains("#")) {
            return key;
        }
        HashMap<String, String> flags = new HashMap<String, String>();
        for (String s : key.split("\\.")) {
            if (!s.startsWith("#")) continue;
            flags.put(s.substring(1, 2), s.substring(2));
            key = key.replace(s + ".", "");
        }
        DialogueType type = null;
        if (flags.containsKey("T")) {
            type = MAP.get(flags.get("T"));
        }
        if (type == null) {
            return key;
        }
        if (flags.containsKey("P") && random.method_43056() && (p3 = DialogueType.getPrefixedPhrase(type, (String)flags.get("P"), key)).isPresent()) {
            return p3.get();
        }
        if (flags.containsKey("E") && MCAClient.useExpandedPersonalityTranslations() && (p2 = DialogueType.getPrefixedPhrase(type, personality = Personality.valueOf((String)flags.get("E")).name().toLowerCase(Locale.ROOT), key)).isPresent()) {
            return p2.get();
        }
        if (flags.containsKey("G") && (p = DialogueType.getPrefixedPhrase(type, (String)flags.get("G"), key)).isPresent()) {
            return p.get();
        }
        DialogueType t = type;
        while (t != null) {
            String s = t.name().toLowerCase(Locale.ENGLISH) + "." + key;
            if (class_2477.method_10517().method_4678(s)) {
                return s;
            }
            t = t.fallback;
        }
        return key;
    }

    static {
        random = class_5819.method_43047();
        VALUES = DialogueType.values();
        MAP = Arrays.stream(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

