/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import quilt.net.mca.client.gui.Button;
import quilt.net.mca.client.gui.MCAScreens;
import quilt.net.mca.client.resources.Icon;
import quilt.net.mca.entity.interaction.Constraint;

public abstract class AbstractDynamicScreen
extends class_437 {
    protected static final float iconScale = 1.5f;
    private String activeScreen = "main";
    private int mouseX;
    private int mouseY;
    private Set<Constraint> constraints = new HashSet<Constraint>();

    protected AbstractDynamicScreen(class_2561 title) {
        super(title);
    }

    public String getActiveScreen() {
        return this.activeScreen;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        this.setLayout(this.activeScreen);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected abstract void buttonPressed(Button var1);

    protected void disableButton(String id) {
        this.method_25396().forEach(b -> {
            if (b instanceof ButtonEx && ((ButtonEx)((Object)b)).getApiButton().identifier().equals(id)) {
                ((ButtonEx)b).field_22763 = false;
            }
        });
    }

    protected void enableAllButtons() {
        this.method_25396().forEach(b -> {
            if (b instanceof class_339) {
                ((class_339)b).field_22763 = true;
            }
        });
    }

    protected void disableAllButtons() {
        this.method_25396().forEach(b -> {
            if (b instanceof class_339) {
                if (b instanceof ButtonEx) {
                    if (!((ButtonEx)((Object)b)).getApiButton().identifier().equals("gui.button.backarrow")) {
                        ((class_339)b).field_22763 = false;
                    }
                } else {
                    ((class_339)b).field_22763 = false;
                }
            }
        });
    }

    public void setLayout(String guiKey) {
        this.activeScreen = guiKey;
        this.method_37067();
        MCAScreens.getInstance().getScreen(guiKey).ifPresent(buttons -> {
            for (Button b : buttons) {
                this.method_37063((class_364)new ButtonEx(b, this));
            }
        });
    }

    protected void drawIcon(class_332 context, class_2960 texture, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.method_25302(texture, (int)((float)icon.x() / 1.5f), (int)((float)icon.y() / 1.5f), icon.u(), icon.v(), 16, 16);
    }

    protected void drawHoveringIconText(class_332 context, class_2561 text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.method_51438(this.field_22793, text, icon.x() + 16, icon.y() + 20);
    }

    protected void drawHoveringIconText(class_332 context, List<class_2561> text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        context.method_51434(this.field_22793, text, icon.x() + 16, icon.y() + 20);
    }

    protected boolean hoveringOverIcon(String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        return this.hoveringOver(icon.x(), icon.y(), 24, 24);
    }

    protected boolean hoveringOver(int x, int y, int w, int h) {
        return this.mouseX > x && this.mouseX < x + w && this.mouseY > y && this.mouseY < y + h;
    }

    private static class ButtonEx
    extends class_4185 {
        private final Button apiButton;

        public ButtonEx(Button apiButton, AbstractDynamicScreen screen) {
            super((int)((float)screen.field_22789 * Alignment.alignments.get((Object)apiButton.align()).h + (float)apiButton.x()), (int)((float)screen.field_22790 * Alignment.alignments.get((Object)apiButton.align()).v + (float)apiButton.y()), apiButton.width(), apiButton.height(), (class_2561)class_2561.method_43471((String)apiButton.identifier()), a -> screen.buttonPressed(apiButton), field_40754);
            this.apiButton = apiButton;
            if (!apiButton.isValidForConstraint(screen.getConstraints())) {
                if (apiButton.hideOnFail()) {
                    this.field_22764 = false;
                }
                this.field_22763 = false;
            }
        }

        public Button getApiButton() {
            return this.apiButton;
        }
    }

    private static enum Alignment {
        TOP_LEFT(0.0f, 0.0f),
        TOP(0.5f, 0.0f),
        TOP_RIGHT(1.0f, 0.0f),
        RIGHT(1.0f, 0.5f),
        BOTTOM_RIGHT(1.0f, 1.0f),
        BOTTOM(0.5f, 1.0f),
        BOTTOM_LEFT(0.0f, 1.0f),
        LEFT(0.0f, 0.5f),
        CENTER(0.5f, 0.5f);

        final float h;
        final float v;
        static final Map<String, Alignment> alignments;

        private Alignment(float h, float v) {
            this.h = h;
            this.v = v;
        }

        static {
            alignments = new HashMap<String, Alignment>();
            for (Alignment a : Alignment.values()) {
                alignments.put(a.name().toLowerCase(Locale.ENGLISH), a);
            }
        }
    }
}

