/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.client.LanguageMap;
import fabric.net.mca.client.OnlineSpeechManager;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.chatAI.ChatAI;
import fabric.net.mca.entity.ai.chatAI.GPT3;
import fabric.net.mca.entity.ai.relationship.Personality;
import fabric.net.mca.network.s2c.OpenGuiRequest;
import fabric.net.mca.server.ServerInteractionManager;
import fabric.net.mca.server.world.data.PlayerSaveData;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class Command {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::propose)))).then(Command.register("accept").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("destiny", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::destiny)))).then(Command.register("mail", (com.mojang.brigadier.Command<class_2168>)((com.mojang.brigadier.Command)Command::mail)))).then(Command.register("verify").then(class_2170.method_9244((String)"email", (ArgumentType)StringArgumentType.greedyString()).executes(Command::verify)))).then(Command.register("chatAI").requires(p -> p.method_9259(2) || p.method_9211().method_3724()).executes(Command::chatAIHelp).then(class_2170.method_9247((String)"disable").executes(Command::disableChatAI)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"model", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), new Config().villagerChatAIEndpoint, ""))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"endpoint", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), (String)c.getArgument("endpoint", String.class), ""))).then(class_2170.method_9244((String)"token", (ArgumentType)StringArgumentType.string()).executes(c -> Command.chatAI((String)c.getArgument("model", String.class), (String)c.getArgument("endpoint", String.class), (String)c.getArgument("token", String.class)))))))).then(Command.register("tts").requires(p -> p.method_9211().method_3724()).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(Command::ttsEnable))).then(class_2170.method_9247((String)"scan").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"language", (ArgumentType)StringArgumentType.string()).requires(p -> p.method_44023() != null && p.method_44023().method_5820().contains("Player"))).executes(Command::ttsScan))))).then(Command.register("inworldAI").requires(p -> p.method_9259(2) || p.method_9211().method_3724()).then(Command.register("keys").then(class_2170.method_9244((String)"api_key", (ArgumentType)StringArgumentType.string()).executes(c -> Command.inworldAIKey((String)c.getArgument("api_key", String.class))))).then(Command.register("addCharacter").then(class_2170.method_9244((String)"villager_name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"character_endpoint", (ArgumentType)StringArgumentType.string()).executes(c -> Command.inworldAICharacter((CommandContext<class_2168>)c, (String)c.getArgument("villager_name", String.class), (String)c.getArgument("character_endpoint", String.class))))))));
    }

    private static int chatAIHelp(CommandContext<class_2168> context) {
        class_5250 styled = class_2561.method_43471((String)"mca.ai_help").method_27694(s -> s.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations")));
        Command.sendMessage(context, (class_2561)styled);
        return Command.chatAI(new Config().villagerChatAIModel, new Config().villagerChatAIEndpoint, new Config().villagerChatAIToken);
    }

    private static int inworldAIKey(String apiKey) {
        Config.getInstance().inworldAIToken = apiKey;
        Config.getInstance().save();
        return 0;
    }

    private static int inworldAICharacter(CommandContext<class_2168> context, String name, String endpoint) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Optional<VillagerEntityMCA> optionalVillager = ChatAI.findVillagerInArea(player, name);
        optionalVillager.ifPresent(v -> {
            Config.getInstance().inworldAIResourceNames.put(v.method_5667(), endpoint);
            ChatAI.clearStrategy(v.method_5667());
            Config.getInstance().save();
        });
        return 0;
    }

    private static int chatAI(String model, String endpoint, String token) {
        Config.getInstance().enableVillagerChatAI = true;
        Config.getInstance().villagerChatAIModel = model;
        Config.getInstance().villagerChatAIEndpoint = endpoint;
        Config.getInstance().villagerChatAIToken = token;
        Config.getInstance().save();
        return 0;
    }

    private static int disableChatAI(CommandContext<class_2168> c) {
        Config.getInstance().enableVillagerChatAI = false;
        Config.getInstance().save();
        return 0;
    }

    private static int ttsEnable(CommandContext<class_2168> ctx) {
        Config.getInstance().enableOnlineTTS = BoolArgumentType.getBool(ctx, (String)"enabled");
        Config.getInstance().save();
        return 0;
    }

    private static boolean couldBePersonalityRelated(String phrase) {
        for (Personality value : Personality.values()) {
            if (!phrase.contains(value.name().toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    private static int ttsScan(CommandContext<class_2168> ctx) {
        String language = (String)ctx.getArgument("language", String.class);
        for (Map.Entry definition : class_310.method_1551().method_1526().method_4665().entrySet()) {
            String ttsLang = LanguageMap.LANGUAGE_MAP.getOrDefault(definition.getKey(), "");
            if (ttsLang.isEmpty() || !language.equals("all") && !ttsLang.equals(language)) continue;
            class_310.method_1551().method_1526().method_4667((String)definition.getKey());
            try {
                class_310.method_1551().method_1521().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, String> text : MCA.translations.entrySet()) {
                String key = text.getKey();
                if (!key.contains("dialogue.") && !key.contains("interaction.") && !key.contains("villager.") || Command.couldBePersonalityRelated(key)) continue;
                String hash = OnlineSpeechManager.INSTANCE.getHash(text.getValue());
                OnlineSpeechManager.INSTANCE.downloadAudio(ttsLang, "male_9", text.getValue(), hash, true);
            }
        }
        return 0;
    }

    private static int editor(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        if (((class_2168)ctx.getSource()).method_9259(2) || Config.getInstance().allowFullPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (class_1297)player), player);
            return 0;
        }
        if (Config.getInstance().allowLimitedPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.LIMITED_VILLAGER_EDITOR, (class_1297)player), player);
            return 0;
        }
        Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.no_permission").method_27692(class_124.field_1061));
        return 1;
    }

    private static int destiny(CommandContext<class_2168> ctx) {
        if (((class_2168)ctx.getSource()).method_9259(2) || Config.getInstance().allowDestinyCommandOnce) {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player != null && !PlayerSaveData.get(player).isEntityDataSet() || Config.getInstance().allowDestinyCommandMoreThanOnce) {
                ServerInteractionManager.launchDestiny(player);
                return 0;
            }
            Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.only_one_destiny").method_27692(class_124.field_1061));
            return 1;
        }
        Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.no_permission").method_27692(class_124.field_1061));
        return 1;
    }

    private static int mail(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 1;
        }
        PlayerSaveData data = PlayerSaveData.get(player);
        if (data.hasMail()) {
            while (data.hasMail()) {
                player.method_31548().method_7398(data.getMail());
            }
        } else {
            Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.no_mail"));
        }
        return 0;
    }

    private static int verify(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        CompletableFuture.runAsync(() -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("email", StringArgumentType.getString((CommandContext)ctx, (String)"email"));
            assert (player != null);
            params.put("player", player.method_5477().getString());
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerChatAIEndpoint.replace("v1/mca/chat", "v1/mca/verify") + "?", ""));
            GPT3.Answer request = GPT3.request(encodedURL);
            if (request.answer().equals("success")) {
                Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.verify.success").method_27692(class_124.field_1060));
            } else if (request.answer().equals("failed")) {
                Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.verify.failed").method_27692(class_124.field_1061));
            } else {
                Command.sendMessage(ctx, (class_2561)class_2561.method_43471((String)"command.verify.crashed").method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    private static int displayHelp(CommandContext<class_2168> ctx) {
        Command.sendMessage(ctx, String.valueOf(class_124.field_1079) + "--- " + String.valueOf(class_124.field_1065) + "PLAYER COMMANDS" + String.valueOf(class_124.field_1079) + " ---");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca editor" + String.valueOf(class_124.field_1065) + " - Choose your genetics and stuff.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca propose <PlayerName>" + String.valueOf(class_124.field_1065) + " - Proposes marriage to the given player.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca proposals " + String.valueOf(class_124.field_1065) + " - Shows all active proposals.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca accept <PlayerName>" + String.valueOf(class_124.field_1065) + " - Accepts the player's marriage request.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca reject <PlayerName>" + String.valueOf(class_124.field_1065) + " - Rejects the player's marriage request.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca procreate " + String.valueOf(class_124.field_1065) + " - Starts procreation.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca separate " + String.valueOf(class_124.field_1065) + " - Ends your marriage.");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1079) + "--- " + String.valueOf(class_124.field_1065) + "GLOBAL COMMANDS" + String.valueOf(class_124.field_1079) + " ---");
        Command.sendMessage(ctx, String.valueOf(class_124.field_1068) + " /mca help " + String.valueOf(class_124.field_1065) + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static int accept(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<class_2168> ctx) {
        ServerInteractionManager.getInstance().listProposals(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int procreate(CommandContext<class_2168> ctx) {
        ServerInteractionManager.getInstance().procreate(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int separate(CommandContext<class_2168> ctx) {
        ServerInteractionManager.getInstance().endMarriage(((class_2168)ctx.getSource()).method_44023());
        return 0;
    }

    private static int reject(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((class_2168)ctx.getSource()).method_44023(), target);
        return 0;
    }

    private static ArgumentBuilder<class_2168, ?> register(String name, com.mojang.brigadier.Command<class_2168> cmd) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(cs -> cs.method_9259(0))).executes(cmd);
    }

    private static ArgumentBuilder<class_2168, ?> register(String name) {
        return class_2170.method_9247((String)name).requires(cs -> cs.method_9259(0));
    }

    private static void sendMessage(CommandContext<class_2168> ctx, String message) {
        Command.sendMessage(ctx, (class_2561)class_2561.method_43470((String)message));
    }

    private static void sendMessage(CommandContext<class_2168> ctx, class_2561 message) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player != null) {
            player.method_43496(message);
        }
    }
}

