/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.dungeon;

import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.ai.AetherBlockPathTypes;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoorwayBlock
extends Block {
    public static final BooleanProperty INVISIBLE = BooleanProperty.m_61465_((String)"invisible");
    public static final VoxelShape INVISIBLE_SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private final Supplier<EntityType<?>> blockedEntityTypeSupplier;

    public DoorwayBlock(Supplier<EntityType<?>> blockedEntityTypeSupplier, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
        this.blockedEntityTypeSupplier = blockedEntityTypeSupplier;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{INVISIBLE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_7500_()) {
            BlockState newState = (BlockState)state.m_61122_((Property)INVISIBLE);
            level.m_7731_(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        boolean flag = super.m_6864_(state, context);
        if (!flag) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            for (int i = 0; i < 2; ++i) {
                EntityUtil.spawnRemovalParticles(level, pos);
            }
        }
        return flag;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockItem blockItem;
        ItemStack itemStack;
        Item item;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91072_ != null && minecraft.f_91072_.m_105295_() == GameType.CREATIVE && minecraft.f_91074_ != null && minecraft.f_91073_ != null && (item = (itemStack = minecraft.f_91074_.m_21205_()).m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == this && ((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            minecraft.f_91073_.m_7106_((ParticleOptions)AetherParticleTypes.BOSS_DOORWAY_BLOCK.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)INVISIBLE)).booleanValue()) {
            Player player;
            EntityCollisionContext entity;
            Entity entity2;
            if (context instanceof EntityCollisionContext && (entity2 = (entity = (EntityCollisionContext)context).m_193113_()) instanceof Player && (player = (Player)entity2).m_7500_()) {
                return INVISIBLE_SHAPE;
            }
            return Shapes.m_83040_();
        }
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entity;
        if (context instanceof EntityCollisionContext && (entity = (EntityCollisionContext)context).m_193113_() != null && this.blockedEntityTypeSupplier.get() != null && entity.m_193113_().m_6095_() == this.blockedEntityTypeSupplier.get()) {
            return Shapes.m_83144_();
        }
        return (Boolean)state.m_61143_((Property)INVISIBLE) != false ? Shapes.m_83040_() : super.m_5939_(state, level, pos, context);
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : super.m_7514_(state);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return AetherBlockPathTypes.BOSS_DOORWAY;
    }
}

