/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.api;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.item.AetherItems;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class AetherMoaTypes {
    public static final ResourceKey<Registry<MoaType>> MOA_TYPE_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("aether", "moa_type"));
    public static final DeferredRegister<MoaType> MOA_TYPES = DeferredRegister.create(MOA_TYPE_REGISTRY_KEY, (String)"aether");
    public static final Supplier<IForgeRegistry<MoaType>> MOA_TYPE_REGISTRY = MOA_TYPES.makeRegistry(() -> new RegistryBuilder().hasTags());
    public static final RegistryObject<MoaType> BLUE = MOA_TYPES.register("blue", () -> new MoaType(new MoaType.Properties().egg((Supplier<? extends Item>)AetherItems.BLUE_MOA_EGG).maxJumps(3).speed(0.155f).spawnChance(100).texture("textures/entity/mobs/moa/blue_moa.png")));
    public static final RegistryObject<MoaType> WHITE = MOA_TYPES.register("white", () -> new MoaType(new MoaType.Properties().egg((Supplier<? extends Item>)AetherItems.WHITE_MOA_EGG).maxJumps(4).speed(0.155f).spawnChance(50).texture("textures/entity/mobs/moa/white_moa.png")));
    public static final RegistryObject<MoaType> BLACK = MOA_TYPES.register("black", () -> new MoaType(new MoaType.Properties().egg((Supplier<? extends Item>)AetherItems.BLACK_MOA_EGG).maxJumps(8).speed(0.155f).spawnChance(25).texture("textures/entity/mobs/moa/black_moa.png").saddleTexture("textures/entity/mobs/moa/black_moa_saddle.png")));

    @Nullable
    public static MoaType get(String id) {
        return (MoaType)MOA_TYPE_REGISTRY.get().getValue(new ResourceLocation(id));
    }

    public static MoaType getWeightedChance(RandomSource random) {
        SimpleWeightedRandomList.Builder weightedListBuilder = SimpleWeightedRandomList.m_146263_();
        MOA_TYPE_REGISTRY.get().getValues().forEach(moaType -> weightedListBuilder.m_146271_(moaType, moaType.getSpawnChance()));
        SimpleWeightedRandomList weightedList = weightedListBuilder.m_146270_();
        Optional moaType2 = weightedList.m_216820_(random);
        return moaType2.orElseGet(BLUE);
    }
}

