/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.config;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;

public class ConfigValueWrapper<O, P>
implements Supplier<P> {
    private final ForgeConfigSpec.ConfigValue<O> configValue;
    private final Function<O, P> parseFunction;

    public static <O, P> ConfigValueWrapper<O, P> create(ForgeConfigSpec.ConfigValue<O> configValue, Function<O, P> parseFunction, IEventBus modEventBus, String modID) {
        return new ConfigValueWrapper<O, P>(configValue, parseFunction, modEventBus, modID);
    }

    public static <O> ConfigValueWrapper<O, O> create(ForgeConfigSpec.ConfigValue<O> configValue, IEventBus modEventBus, String modID) {
        return ConfigValueWrapper.create(configValue, o -> o, modEventBus, modID);
    }

    private ConfigValueWrapper(ForgeConfigSpec.ConfigValue<O> configValue, Function<O, P> parseFunction, IEventBus modEventBus, String modID) {
        this.configValue = configValue;
        this.parseFunction = parseFunction;
    }

    @Override
    public P get() {
        return this.parseFunction.apply(this.configValue.get());
    }

    public P getDefault() {
        return this.parseFunction.apply(this.configValue.getDefault());
    }

    public ForgeConfigSpec.ConfigValue<O> getConfigValue() {
        return this.configValue;
    }
}

