/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api;

import com.legacy.lucent.api.registry.BlockTextureLightingRegistry;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.block_emission.BlockEmissionEngine;
import com.legacy.lucent.core.dynamic_lighting.DynamicLightingEngine;
import com.legacy.lucent.core.dynamic_lighting.LightData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class LucentHooks {
    public static float getBlockLight(BlockAndTintGetter level, BlockState state, BlockPos pos, float vanillaBlockLight) {
        float blockLight;
        LightData lightData = DynamicLightingEngine.getLightSource(pos);
        if (lightData != null && (blockLight = DynamicLightingEngine.calcBlockLight(level, pos, lightData)) > vanillaBlockLight) {
            return blockLight;
        }
        return vanillaBlockLight;
    }

    public static int getPackedLight(BlockAndTintGetter level, BlockState state, BlockPos pos, int vanillaPackedLight) {
        int light;
        LightData lightData = DynamicLightingEngine.getLightSource(pos);
        if (lightData != null && (light = DynamicLightingEngine.calcLight(level, state, pos, lightData)) > vanillaPackedLight) {
            return light;
        }
        return vanillaPackedLight;
    }

    public static float getTextureBlockLight(ResourceLocation textureName, int vanillaBlockLight) {
        return (Boolean)LucentConfig.CLIENT.blockTexturesGlow.get() != false ? (float)Math.max(vanillaBlockLight, BlockTextureLightingRegistry.get(textureName)) : (float)vanillaBlockLight;
    }

    public static int getTexturePackedLight(ResourceLocation textureName, int vanillaPackedLight) {
        return BlockEmissionEngine.calcLight(vanillaPackedLight, textureName);
    }
}

