/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.array.DoubleArrayLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record DoubleLoadable(double min, double max) implements Loadable<Double>
{
    public static final DoubleLoadable ANY = DoubleLoadable.range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final DoubleLoadable FROM_ZERO = DoubleLoadable.min(0.0);
    public static final DoubleLoadable PERCENT = DoubleLoadable.range(0.0, 1.0);

    public static DoubleLoadable range(double min, double max) {
        return new DoubleLoadable(min, max);
    }

    public static DoubleLoadable min(double min) {
        return new DoubleLoadable(min, Double.POSITIVE_INFINITY);
    }

    private double validate(double value, String key) {
        if (this.min <= value && value <= this.max) {
            return value;
        }
        if (this.min == Double.NEGATIVE_INFINITY) {
            throw new JsonSyntaxException(key + " must not be greater than " + this.max);
        }
        if (this.max == Double.POSITIVE_INFINITY) {
            throw new JsonSyntaxException(key + " must not be less than " + this.min);
        }
        throw new JsonSyntaxException(key + " must be between " + this.min + " and " + this.max);
    }

    @Override
    public Double convert(JsonElement element, String key, TypedMap context) {
        return this.validate(GsonHelper.m_144769_((JsonElement)element, (String)key), key);
    }

    @Override
    public Double decode(FriendlyByteBuf buffer, TypedMap context) {
        return buffer.readDouble();
    }

    @Override
    public JsonElement serialize(Double object) {
        return new JsonPrimitive((Number)this.validate(object, "Value"));
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Double object) {
        buffer.writeDouble(object.doubleValue());
    }

    public ArrayLoadable<double[]> array(int minSize, int maxSize) {
        return new DoubleArrayLoadable(this, minSize, maxSize);
    }

    public ArrayLoadable<double[]> array(int minSize) {
        return this.array(minSize, Integer.MAX_VALUE);
    }
}

