/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.listener;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;

public abstract class MergingJsonDataLoader<B>
implements ResourceManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MergingJsonDataLoader.class);
    @VisibleForTesting
    protected final Gson gson;
    @VisibleForTesting
    protected final String folder;
    @VisibleForTesting
    protected final Function<ResourceLocation, B> builderConstructor;

    protected abstract void parse(B var1, ResourceLocation var2, JsonElement var3) throws JsonSyntaxException;

    protected abstract void finishLoad(Map<ResourceLocation, B> var1, ResourceManager var2);

    public void m_6213_(ResourceManager manager) {
        HashMap<ResourceLocation, B> map = new HashMap<ResourceLocation, B>();
        for (Map.Entry entry : manager.m_214160_(this.folder, fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation filePath = (ResourceLocation)entry.getKey();
            ResourceLocation id = JsonHelper.localize(filePath, this.folder, ".json");
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement json = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (json == null) {
                            log.error("Couldn't load data file {} from {} in data pack {} as its null or empty", (Object)id, (Object)filePath, (Object)resource.m_215506_());
                            continue;
                        }
                        B builder = map.computeIfAbsent(id, this.builderConstructor);
                        this.parse(builder, id, json);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RuntimeException ex) {
                    log.error("Couldn't parse data file {} from {} in data pack {}", (Object)id, (Object)filePath, (Object)resource.m_215506_(), (Object)ex);
                }
            }
        }
        this.finishLoad(map, manager);
    }

    public MergingJsonDataLoader(Gson gson, String folder, Function<ResourceLocation, B> builderConstructor) {
        this.gson = gson;
        this.folder = folder;
        this.builderConstructor = builderConstructor;
    }
}

