/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.Tags;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.client.render.entity.ToretoiseRenderer;
import org.violetmoon.quark.content.mobs.entity.Toretoise;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.config.type.EntitySpawnConfig;
import org.violetmoon.zeta.config.type.IBiomeConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="mobs")
public class ToretoiseModule
extends ZetaModule {
    public static EntityType<Toretoise> toretoiseType;
    @Config
    public static int maxYLevel;
    @Config(description="The number of ticks from mining a tortoise until feeding it could cause it to regrow.")
    public static int cooldownTicks;
    @Config(description="The items that can be fed to toretoises to make them regrow ores.")
    public static List<String> foods;
    @Config(flag="toretoise_regrow")
    public static boolean allowToretoiseToRegrow;
    @Config(description="Feeding a toretoise after cooldown will regrow them with a one-in-this-number chance. Set to 1 to always regrow, higher = lower chance.")
    public static int regrowChance;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static ManualTrigger mineToretoiseTrigger;
    public static ManualTrigger mineFedToretoiseTrigger;

    @LoadEvent
    public final void register(ZRegister event) {
        toretoiseType = EntityType.Builder.m_20704_(Toretoise::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 1.0f).m_20702_(8).m_20719_().setCustomClientFactory((spawnEntity, world) -> new Toretoise((EntityType<? extends Toretoise>)toretoiseType, (Level)world)).m_20712_("toretoise");
        Quark.ZETA.registry.register(toretoiseType, "toretoise", Registries.f_256939_);
        Quark.ZETA.entitySpawn.registerSpawn(toretoiseType, MobCategory.MONSTER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Toretoise::spawnPredicate, spawnConfig);
        Quark.ZETA.entitySpawn.addEgg((ZetaModule)this, toretoiseType, 5587259, 3682871, spawnConfig);
        mineToretoiseTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("mine_toretoise");
        mineFedToretoiseTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("mine_fed_toretoise");
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(toretoiseType, Toretoise.prepareAttributes().m_22265_());
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        EntityRenderers.m_174036_(toretoiseType, ToretoiseRenderer::new);
    }

    static {
        maxYLevel = 0;
        cooldownTicks = 1200;
        foods = Lists.newArrayList((Object[])new String[]{"minecraft:glow_berries"});
        allowToretoiseToRegrow = true;
        regrowChance = 3;
        dimensions = DimensionConfig.overworld((boolean)false);
        spawnConfig = new EntitySpawnConfig(120, 2, 4, (IBiomeConfig)CompoundBiomeConfig.fromBiomeTags((boolean)true, (TagKey[])new TagKey[]{Tags.Biomes.IS_VOID, BiomeTags.f_207612_, BiomeTags.f_215818_}));
    }
}

