/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.config.definition;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.config.type.ConvulsionMatrixConfig;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.definition.ClientDefinitionExt;
import org.violetmoon.zeta.client.config.screen.AbstractSectionInputScreen;
import org.violetmoon.zeta.client.config.widget.PencilButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class ConvulsionMatrixClientDefinition
implements ClientDefinitionExt<SectionDefinition> {
    private final ConvulsionMatrixConfig.Params params;
    private final ValueDefinition<List<Double>> r;
    private final ValueDefinition<List<Double>> g;
    private final ValueDefinition<List<Double>> b;

    public ConvulsionMatrixClientDefinition(ConvulsionMatrixConfig cfg, SectionDefinition def) {
        this.params = cfg.params;
        this.r = def.getValueErased("R", List.class);
        this.g = def.getValueErased("G", List.class);
        this.b = def.getValueErased("B", List.class);
        Preconditions.checkNotNull(this.r, (Object)"need an 'R' value in this section");
        Preconditions.checkNotNull(this.g, (Object)"need an 'G' value in this section");
        Preconditions.checkNotNull(this.b, (Object)"need an 'B' value in this section");
    }

    public String getSubtitle(ChangeSet changes, SectionDefinition def) {
        List r_ = changes.getExactSizeCopy(this.r, 3, (Object)0.0);
        List g_ = changes.getExactSizeCopy(this.g, 3, (Object)0.0);
        List b_ = changes.getExactSizeCopy(this.b, 3, (Object)0.0);
        return Stream.of(r_, g_, b_).flatMap(Collection::stream).map(d -> String.format("%.1f", d)).collect(Collectors.joining(", ", "[", "]"));
    }

    public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def, Consumer<AbstractWidget> widgets) {
        ConvulsionMatrixInputScreen newScreen = new ConvulsionMatrixInputScreen(zc, parent, changes, def);
        widgets.accept((AbstractWidget)new PencilButton(zc, 230, 3, arg_0 -> ConvulsionMatrixClientDefinition.lambda$addWidgets$1((Screen)newScreen, arg_0)));
    }

    private static /* synthetic */ void lambda$addWidgets$1(Screen newScreen, Button b1) {
        Minecraft.m_91087_().m_91152_(newScreen);
    }

    class ConvulsionMatrixInputScreen
    extends AbstractSectionInputScreen {
        ForgeSlider[] sliders;
        private static final Component EMPTY = Component.m_237119_();

        public ConvulsionMatrixInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def) {
            super(zc, parent, changes, def);
            this.sliders = new ForgeSlider[9];
        }

        protected List<Double> with(ValueDefinition<List<Double>> def, int index, double value) {
            List copy = this.changes.getExactSizeCopy(def, 3, (Object)0.0);
            copy.set(index, value);
            return copy;
        }

        protected void m_7856_() {
            super.m_7856_();
            int w = 70;
            int p = 12;
            int x = this.f_96543_ / 2 - 33;
            int y = 55;
            this.sliders[0] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 0));
            this.sliders[1] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 1));
            this.sliders[2] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 2));
            this.sliders[3] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 0));
            this.sliders[4] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 1));
            this.sliders[5] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 2));
            this.sliders[6] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 0));
            this.sliders[7] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 1));
            this.sliders[8] = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 2));
            int i = 0;
            for (Map.Entry<String, double[]> entry : ConvulsionMatrixClientDefinition.this.params.presetMap.entrySet()) {
                String name = entry.getKey();
                double[] preset = entry.getValue();
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)name), __ -> this.setFromArray(preset)).m_253046_(w - p, 20).m_252794_(x + w * i, y + 115).m_253136_());
                ++i;
            }
            this.forceUpdateWidgets();
        }

        protected void forceUpdateWidgets() {
            this.setFromList(Stream.of(this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.r, 3, (Object)0.0), this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.g, 3, (Object)0.0), this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.b, 3, (Object)0.0)).flatMap(Collection::stream).toList());
        }

        private ForgeSlider makeSliderPlease(final int x, final int y, int width, int height, final ValueDefinition<List<Double>> binding, final int bindingIndex) {
            return new ForgeSlider(x, y, width, height, EMPTY, EMPTY, 0.0, 2.0, 0.0, 0.0, 1, false){

                public void m_93611_(double value) {
                    super.m_93611_(value);
                    ConvulsionMatrixInputScreen.this.changes.set(binding, ConvulsionMatrixInputScreen.this.with((ValueDefinition<List<Double>>)binding, bindingIndex, value));
                }

                protected void m_5697_() {
                    this.m_93611_(ConvulsionMatrixInputScreen.this.snap(this));
                }

                public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    Minecraft mc = Minecraft.m_91087_();
                    super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                    String displayVal = String.format("%.2f", this.getValue());
                    int valueColor = ConvulsionMatrixInputScreen.this.changes.isDirty(binding) ? ChatFormatting.GOLD.m_126665_() : 0xFFFFFF;
                    guiGraphics.m_280488_(mc.f_91062_, displayVal, x + (this.m_5711_() / 2 - ConvulsionMatrixInputScreen.this.f_96547_.m_92895_(displayVal) / 2), y + 6, valueColor);
                }
            };
        }

        public void m_86600_() {
            this.updateButtonStatus(true);
        }

        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack mstack = guiGraphics.m_280168_();
            this.m_280273_(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            int x = this.f_96543_ / 2 - 203;
            int y = 10;
            int size = 60;
            int titleLeft = this.f_96543_ / 2 + 66;
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)ConvulsionMatrixClientDefinition.this.params.name).m_130940_(ChatFormatting.BOLD), titleLeft, 20, 0xFFFFFF);
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Presets"), titleLeft, 155, 0xFFFFFF);
            int sliders = 0;
            for (Renderable renderable : this.f_169369_) {
                if (!(renderable instanceof ForgeSlider)) continue;
                ForgeSlider s = (ForgeSlider)renderable;
                switch (sliders) {
                    case 0: {
                        guiGraphics.m_280488_(this.f_96547_, "R =", s.m_252754_() - 20, s.m_252907_() + 5, 0xFF0000);
                        guiGraphics.m_280488_(this.f_96547_, "R", s.m_252754_() + (s.m_5711_() / 2 - 2), s.m_252907_() - 12, 0xFF0000);
                        break;
                    }
                    case 1: {
                        guiGraphics.m_280488_(this.f_96547_, "G", s.m_252754_() + (s.m_5711_() / 2 - 2), s.m_252907_() - 12, 65280);
                        break;
                    }
                    case 2: {
                        guiGraphics.m_280488_(this.f_96547_, "B", s.m_252754_() + (s.m_5711_() / 2 - 2), s.m_252907_() - 12, 30719);
                        break;
                    }
                    case 3: {
                        guiGraphics.m_280488_(this.f_96547_, "G =", s.m_252754_() - 20, s.m_252907_() + 5, 65280);
                        break;
                    }
                    case 6: {
                        guiGraphics.m_280488_(this.f_96547_, "B =", s.m_252754_() - 20, s.m_252907_() + 5, 30719);
                    }
                }
                if (sliders % 3 != 0) {
                    guiGraphics.m_280488_(this.f_96547_, "+", s.m_252754_() - 9, s.m_252907_() + 5, 0xFFFFFF);
                }
                ++sliders;
            }
            String[] biomes = ConvulsionMatrixClientDefinition.this.params.biomeNames;
            int[] colors = ConvulsionMatrixClientDefinition.this.params.testColors;
            int[] folliageColors = ConvulsionMatrixClientDefinition.this.params.folliageTestColors;
            boolean renderFolliage = ConvulsionMatrixClientDefinition.this.params.shouldDisplayFolliage();
            double[] matrix = this.getToDoubleArray();
            for (int i = 0; i < biomes.length; ++i) {
                String name = biomes[i];
                int color = colors[i];
                int convolved = ConvulsionMatrixConfig.convolve(matrix, color);
                int convolvedFolliage = 0;
                if (renderFolliage) {
                    int folliage = folliageColors[i];
                    convolvedFolliage = ConvulsionMatrixConfig.convolve(matrix, folliage);
                }
                int cx = x + i % 2 * (size + 5);
                int cy = y + i / 2 * (size + 5);
                guiGraphics.m_280509_(cx - 1, cy - 1, cx + size + 1, cy + size + 1, -16777216);
                guiGraphics.m_280509_(cx, cy, cx + size, cy + size, convolved);
                guiGraphics.m_280509_(cx + size / 2 - 1, cy + size / 2 - 1, cx + size, cy + size, 0x22000000);
                if (renderFolliage) {
                    guiGraphics.m_280509_(cx + size / 2, cy + size / 2, cx + size, cy + size, convolvedFolliage);
                }
                guiGraphics.m_280488_(this.f_96547_, name, cx + 2, cy + 2, 0x55000000);
                if (!renderFolliage) continue;
                guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42799_), cx + size - 18, cy + size - 16);
                mstack.m_85836_();
                mstack.m_252880_(0.0f, 0.0f, 999.0f);
                guiGraphics.m_280509_(cx + size / 2, cy + size / 2, cx + size, cy + size, convolvedFolliage & 0x55FFFFFF);
                mstack.m_85849_();
            }
        }

        protected void setFromArray(double[] values) {
            for (int i = 0; i < 9; ++i) {
                this.sliders[i].m_93611_(values[i]);
            }
        }

        protected void setFromList(List<Double> values) {
            for (int i = 0; i < 9; ++i) {
                this.sliders[i].m_93611_(values.get(i).doubleValue());
            }
        }

        protected double[] getToDoubleArray() {
            double[] values = new double[9];
            for (int i = 0; i < 9; ++i) {
                values[i] = this.sliders[i].getValue();
            }
            return values;
        }

        private double snap(ForgeSlider s) {
            double val = s.getValue();
            val = this.snap(val, 0.5, s);
            val = this.snap(val, 1.0, s);
            val = this.snap(val, 1.5, s);
            return val;
        }

        private double snap(double val, double correct, ForgeSlider s) {
            if (Math.abs(val - correct) < 0.02) {
                s.m_93611_(correct);
                return correct;
            }
            return val;
        }
    }
}

