/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.data;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherStructures;
import com.legacy.lost_aether.data.LCTags;
import com.legacy.lost_aether.registry.LCBlocks;
import com.legacy.lost_aether.registry.LCEntityTypes;
import com.legacy.lost_aether.registry.LCItems;
import com.legacy.lost_aether.registry.LCStructures;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LCTagProv {

    public static class StructureProv
    extends StructureTagsProvider {
        public StructureProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "lost_aether_content", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.lostContent();
            this.aether();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        private void lostContent() {
            this.m_206424_(LCTags.Structures.PLATINUM_DUNGEON_BAD_NEIGHBORS).m_211101_(new ResourceKey[]{AetherStructures.SILVER_DUNGEON, AetherStructures.GOLD_DUNGEON});
        }

        private void aether() {
            this.m_206424_(AetherTags.Structures.DUNGEONS).m_255204_(LCStructures.PLATINUM_DUNGEON.getStructure().getKey());
        }

        private void vanilla() {
        }

        private void forge() {
        }

        public String m_6055_() {
            return "Lost Content Structure Tags";
        }
    }

    public static class BiomeProv
    extends BiomeTagsProvider {
        public BiomeProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "lost_aether_content", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.lostContent();
            this.aether();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        private void lostContent() {
            this.m_206424_(LCTags.Biomes.HAS_PLATINUM_DUNGEON).m_206428_(AetherTags.Biomes.IS_AETHER);
            this.m_206424_(LCTags.Biomes.HAS_PINK_AERCLOUDS).m_206428_(AetherTags.Biomes.IS_AETHER);
        }

        private void aether() {
        }

        private void vanilla() {
        }

        private void forge() {
        }

        public String m_6055_() {
            return "Lost Content Biome Tags";
        }
    }

    public static class EntityProv
    extends EntityTypeTagsProvider {
        public EntityProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "lost_aether_content", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.lostContent();
            this.aether();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        private void lostContent() {
        }

        private void aether() {
            this.m_206424_(AetherTags.Entities.UNLAUNCHABLE).m_255245_(LCEntityTypes.AERWHALE_KING);
            this.m_206424_(AetherTags.Entities.NO_SKYROOT_DOUBLE_DROPS).m_255245_(LCEntityTypes.AERWHALE_KING);
            this.m_206424_(AetherTags.Entities.WHIRLWIND_UNAFFECTED).m_255179_((Object[])new EntityType[]{LCEntityTypes.AERWHALE_KING, LCEntityTypes.FALLING_ROCK, LCEntityTypes.CLOUD_SHOT});
        }

        private void vanilla() {
        }

        private void forge() {
            this.m_206424_(Tags.EntityTypes.BOSSES).m_255245_(LCEntityTypes.AERWHALE_KING);
        }

        public String m_6055_() {
            return "Lost Content EntityType Tags";
        }
    }

    public static class ItemProv
    extends ItemTagsProvider {
        public ItemProv(DataGenerator gen, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProv, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(gen.getPackOutput(), lookup, blockTagProv, "lost_aether_content", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.lostContent();
            this.aether();
            this.vanilla();
            this.forge();
        }

        void lostContent() {
            this.m_206421_(LCTags.Blocks.GALE_BLOCKS, LCTags.Items.GALE_STONES);
            this.m_206424_(LCTags.Items.PHOENIX_TOOLS).m_255179_((Object[])new Item[]{LCItems.phoenix_sword, LCItems.phoenix_pickaxe, LCItems.phoenix_axe, LCItems.phoenix_shovel, LCItems.phoenix_hoe});
            this.m_206424_(LCTags.Items.AETHER_SHIELDS).m_255179_((Object[])new Item[]{LCItems.zanite_shield, LCItems.gravitite_shield, LCItems.shield_of_emile});
            this.m_206424_(LCTags.Items.PLATINUM_DUNGEON_LOOT).m_255179_((Object[])new Item[]{LCItems.phoenix_cape, LCItems.sentry_shield, LCItems.invincibility_gem, LCItems.power_gloves, LCItems.flaming_gemstone, LCItems.music_disc_legacy, LCItems.music_disc_sovereign_of_the_skies, LCItems.noble_trim}).m_206428_(LCTags.Items.PHOENIX_TOOLS);
        }

        private void aether() {
            this.m_206421_(AetherTags.Blocks.LOCKED_DUNGEON_BLOCKS, AetherTags.Items.LOCKED_DUNGEON_BLOCKS);
            this.m_206421_(AetherTags.Blocks.TRAPPED_DUNGEON_BLOCKS, AetherTags.Items.TRAPPED_DUNGEON_BLOCKS);
            this.m_206421_(AetherTags.Blocks.BOSS_DOORWAY_DUNGEON_BLOCKS, AetherTags.Items.BOSS_DOORWAY_DUNGEON_BLOCKS);
            this.m_206421_(AetherTags.Blocks.TREASURE_DOORWAY_DUNGEON_BLOCKS, AetherTags.Items.TREASURE_DOORWAY_DUNGEON_BLOCKS);
            this.m_206424_(AetherTags.Items.ACCESSORIES_CAPES).m_255245_((Object)LCItems.phoenix_cape);
            this.m_206424_(AetherTags.Items.ACCESSORIES_SHIELDS).m_255245_((Object)LCItems.sentry_shield);
            this.m_206424_(AetherTags.Items.ACCESSORIES_GLOVES).m_255245_((Object)LCItems.power_gloves);
            this.m_206424_(AetherTags.Items.ACCESSORIES_MISCELLANEOUS).m_255179_((Object[])new Item[]{LCItems.invincibility_gem, LCItems.flaming_gemstone});
            this.m_206424_(AetherTags.Items.DUNGEON_KEYS).m_255245_((Object)LCItems.platinum_key);
            this.m_206424_(AetherTags.Items.MOA_EGGS).m_255179_((Object[])new Item[]{LCItems.brown_moa_egg, LCItems.orange_moa_egg});
            this.m_206424_(AetherTags.Items.TREATED_AS_AETHER_ITEM).m_206428_(LCTags.Items.PHOENIX_TOOLS);
        }

        void vanilla() {
            this.m_206424_(ItemTags.f_271388_).m_255245_((Object)LCItems.phoenix_sword);
            this.m_206424_(ItemTags.f_271360_).m_255245_((Object)LCItems.phoenix_pickaxe);
            this.m_206424_(ItemTags.f_271207_).m_255245_((Object)LCItems.phoenix_axe);
            this.m_206424_(ItemTags.f_271138_).m_255245_((Object)LCItems.phoenix_shovel);
            this.m_206424_(ItemTags.f_271298_).m_255245_((Object)LCItems.phoenix_hoe);
            this.m_206424_(ItemTags.f_13158_).m_255179_((Object[])new Item[]{LCItems.music_disc_legacy, LCItems.music_disc_sovereign_of_the_skies});
            this.m_206424_(ItemTags.f_265942_).m_255179_((Object[])new Item[]{LCItems.power_gloves, LCItems.agility_boots});
            this.m_206424_(ItemTags.f_265940_).m_255245_((Object)LCItems.noble_trim);
        }

        void forge() {
            this.m_206424_(Tags.Items.ARMORS_HELMETS).m_255245_((Object)LCItems.swetty_mask);
            this.m_206424_(Tags.Items.ARMORS_BOOTS).m_255245_((Object)LCItems.agility_boots);
            this.m_206424_(Tags.Items.TOOLS_SHIELDS).m_206428_(LCTags.Items.AETHER_SHIELDS);
        }

        public String m_6055_() {
            return "Lost Content Item Tags";
        }

        private Stream<Item> getMatching(Function<Item, Boolean> condition) {
            return ForgeRegistries.ITEMS.getValues().stream().filter(block -> ForgeRegistries.ITEMS.getKey(block).m_135827_().equals(this.modId) && (Boolean)condition.apply((Item)block) != false);
        }

        private void addMatching(TagKey<Item> itemTag, Function<Item, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.m_206424_(itemTag)).m_255245_(arg_0));
        }
    }

    public static class BlockTagProv
    extends BlockTagsProvider {
        public BlockTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "lost_aether_content", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.lostContent();
            this.aether();
            this.vanilla();
            this.forge();
        }

        void lostContent() {
            this.m_206424_(LCTags.Blocks.GALE_BLOCKS).m_255179_((Object[])new Block[]{LCBlocks.gale_stone, LCBlocks.light_gale_stone, LCBlocks.gale_slab, LCBlocks.gale_stairs, LCBlocks.gale_wall, LCBlocks.locked_gale_stone, LCBlocks.locked_light_gale_stone, LCBlocks.trapped_gale_stone, LCBlocks.trapped_light_gale_stone, LCBlocks.boss_doorway_gale_stone, LCBlocks.boss_doorway_light_gale_stone, LCBlocks.treasure_doorway_gale_stone, LCBlocks.treasure_doorway_light_gale_stone});
            this.m_206424_(LCTags.Blocks.ALTAR_ENHANCER).m_255245_((Object)((Block)AetherBlocks.ENCHANTED_GRAVITITE.get()));
            this.m_206424_(LCTags.Blocks.INCUBATOR_ENHANCER).m_255179_((Object[])new Block[]{(Block)AetherBlocks.AMBROSIUM_BLOCK.get(), Blocks.f_50450_});
            this.m_206424_(LCTags.Blocks.FREEZER_ENHANCER).m_255245_((Object)((Block)AetherBlocks.ICESTONE.get()));
        }

        private void aether() {
            this.m_206424_(AetherTags.Blocks.DUNGEON_BLOCKS).m_255245_((Object)LCBlocks.songstone).m_206428_(LCTags.Blocks.GALE_BLOCKS);
            this.m_206424_(AetherTags.Blocks.LOCKED_DUNGEON_BLOCKS).m_255179_((Object[])new Block[]{LCBlocks.locked_gale_stone, LCBlocks.locked_light_gale_stone});
            this.m_206424_(AetherTags.Blocks.TRAPPED_DUNGEON_BLOCKS).m_255179_((Object[])new Block[]{LCBlocks.trapped_gale_stone, LCBlocks.trapped_light_gale_stone});
            this.m_206424_(AetherTags.Blocks.BOSS_DOORWAY_DUNGEON_BLOCKS).m_255179_((Object[])new Block[]{LCBlocks.boss_doorway_gale_stone, LCBlocks.boss_doorway_light_gale_stone});
            this.m_206424_(AetherTags.Blocks.TREASURE_DOORWAY_DUNGEON_BLOCKS).m_255179_((Object[])new Block[]{LCBlocks.treasure_doorway_gale_stone, LCBlocks.treasure_doorway_light_gale_stone});
        }

        void vanilla() {
            this.addMatching((TagKey<Block>)BlockTags.f_13032_, b -> b instanceof WallBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13031_, b -> b instanceof SlabBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13030_, b -> b instanceof StairBlock);
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{LCBlocks.gale_stone, LCBlocks.gale_stairs, LCBlocks.gale_slab, LCBlocks.gale_wall, LCBlocks.light_gale_stone, LCBlocks.gale_pillar});
            this.m_206424_(BlockTags.f_144281_).m_255179_((Object[])new Block[]{LCBlocks.pink_aercloud, LCBlocks.enchanted_pink_aercloud});
        }

        void forge() {
        }

        public String m_6055_() {
            return "Lost Content Block Tags";
        }

        private Stream<Block> getMatching(Function<Block, Boolean> condition) {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("lost_aether_content") && (Boolean)condition.apply((Block)block) != false);
        }

        private void addMatching(TagKey<Block> blockTag, Function<Block, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.m_206424_(blockTag)).m_255245_(arg_0));
        }
    }
}

