/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model.bedrock;

import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockCube;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.geom.PartPose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public final class BedrockPart {
    private final ObjectList<BedrockCube> cubes;
    private final Map<String, BedrockPart> children;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public boolean visible = true;
    public boolean mirror;
    public boolean emissive = false;
    private PartPose initialPose = PartPose.f_171404_;

    public PartPose getInitialPose() {
        return this.initialPose;
    }

    public void setInitialPose(PartPose p_233561_) {
        this.initialPose = p_233561_;
    }

    public void resetPose() {
        this.loadPose(this.initialPose);
    }

    public void loadPose(PartPose p_171323_) {
        this.x = p_171323_.f_171405_;
        this.y = p_171323_.f_171406_;
        this.z = p_171323_.f_171407_;
        this.xRot = p_171323_.f_171408_;
        this.yRot = p_171323_.f_171409_;
        this.zRot = p_171323_.f_171410_;
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        this.zScale = 1.0f;
    }

    public void offsetScale(Vector3f p_253957_) {
        this.xScale += p_253957_.x();
        this.yScale += p_253957_.y();
        this.zScale += p_253957_.z();
    }

    public BedrockPart() {
        this.cubes = new ObjectArrayList();
        this.children = new HashMap<String, BedrockPart>();
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int texU, int texV) {
        this.render(poseStack, consumer, texU, texV, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        if (this.visible) {
            this.renderCubes(false, poseStack, consumer, texU, texV, red, green, blue, alpha);
        }
    }

    public void renderEmissive(PoseStack poseStack, VertexConsumer consumer, int texU, int texV) {
        this.renderEmissive(poseStack, consumer, texU, texV, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderEmissive(PoseStack poseStack, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        if (this.visible) {
            this.renderCubes(true, poseStack, consumer, texU, texV, red, green, blue, alpha);
        }
    }

    public void renderCubes(boolean renderEmissive, PoseStack poseStack, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        if (!this.isEmpty()) {
            poseStack.m_85836_();
            this.translateAndRotate(poseStack);
            if (this.emissive == renderEmissive) {
                this.compile(poseStack.m_85850_(), consumer, texU, texV, red, green, blue, alpha);
            }
            for (BedrockPart part : this.children.values()) {
                if (renderEmissive) {
                    part.renderEmissive(poseStack, consumer, texU, texV, red, green, blue, alpha);
                    continue;
                }
                part.render(poseStack, consumer, texU, texV, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            poseStack.m_85841_(this.xScale, this.yScale, this.zScale);
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        for (BedrockCube bedrockCube : this.getCubes()) {
            bedrockCube.compile(pose, consumer, texU, texV, red, green, blue, alpha);
        }
    }

    public BedrockCube getRandomCube(Random random) {
        return (BedrockCube)this.getCubes().get(random.nextInt(this.getCubes().size()));
    }

    public boolean isEmissive() {
        return this.emissive;
    }

    public void setEmissive() {
        this.emissive = true;
    }

    public boolean isEmpty() {
        return this.getCubes().isEmpty() && this.children.isEmpty();
    }

    public PartPose storePose() {
        return PartPose.m_171423_((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
    }

    public void copyFrom(BedrockPart p_104316_) {
        this.xRot = p_104316_.xRot;
        this.yRot = p_104316_.yRot;
        this.zRot = p_104316_.zRot;
        this.x = p_104316_.x;
        this.y = p_104316_.y;
        this.z = p_104316_.z;
        this.xScale = p_104316_.xScale;
        this.yScale = p_104316_.yScale;
        this.zScale = p_104316_.zScale;
    }

    public void addChild(String name, BedrockPart model) {
        if (this.isEmissive()) {
            model.setEmissive();
        }
        if (this.getChild(name) != null) {
            this.addChild(name + "0", model);
        } else {
            this.children.put(name, model);
        }
    }

    public List<BedrockPart> getChildren() {
        return ImmutableList.copyOf(this.children.values());
    }

    public Map<String, BedrockPart> getChildrenMap() {
        return this.children;
    }

    public ObjectList<BedrockCube> getCubes() {
        return this.cubes;
    }

    public BedrockPart getChild(String childPartName) {
        return this.children.get(childPartName);
    }
}

