/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.setup.Registration;
import pyre.tinkerslevellingaddon.util.ModUtil;
import pyre.tinkerslevellingaddon.util.ToolLevellingUtil;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.teleport.SlingModifierTeleportEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ElytraFlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.armor.CoverGroundWalkerModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ReplaceBlockWalkerModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ToolActionWalkerTransformModule;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.CircleAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.interaction.InteractionToolModule;
import slimeknights.tconstruct.library.tools.definition.module.weapon.CircleWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.module.weapon.MeleeHitToolHook;
import slimeknights.tconstruct.library.tools.definition.module.weapon.SweepWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.modifiers.ability.armor.FlamewakeModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.melee.SweepingEdgeModifier;

@Mod.EventBusSubscriber(modid="tinkerslevellingaddon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ImprovableModifier
extends NoLevelsModifier
implements PlantHarvestModifierHook,
ShearsModifierHook,
BlockBreakModifierHook,
BlockTransformModifierHook,
ProjectileLaunchModifierHook,
OnAttackedModifierHook,
MeleeHitModifierHook,
ElytraFlightModifierHook,
ArmorWalkModifierHook,
ModifierRemovalHook,
VolatileDataModifierHook,
ToolStatsModifierHook {
    public static final TextColor IMPROVABLE_MODIFIER_COLOR = TextColor.m_131266_((int)9337340);
    public static final ResourceLocation EXPERIENCE_KEY = ModUtil.getResource("experience");
    public static final ResourceLocation LEVEL_KEY = ModUtil.getResource("level");
    public static final ResourceLocation SLOT_HISTORY_KEY = ModUtil.getResource("slot_history");
    public static final ResourceLocation STAT_HISTORY_KEY = ModUtil.getResource("stat_history");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.PLANT_HARVEST, ModifierHooks.SHEAR_ENTITY, ModifierHooks.BLOCK_TRANSFORM, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.BLOCK_BREAK, ModifierHooks.ON_ATTACKED, ModifierHooks.MELEE_HIT, ModifierHooks.ELYTRA_FLIGHT, ModifierHooks.BOOT_WALK, ModifierHooks.VOLATILE_DATA, ModifierHooks.TOOL_STATS, ModifierHooks.REMOVE});
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(EXPERIENCE_KEY);
        tool.getPersistentData().remove(LEVEL_KEY);
        tool.getPersistentData().remove(SLOT_HISTORY_KEY);
        tool.getPersistentData().remove(STAT_HISTORY_KEY);
        return null;
    }

    public void addVolatileData(IToolContext context, ModifierEntry modifier, ToolDataNBT volatileData) {
        if (ToolLevellingUtil.isSlotsLevellingEnabled(context)) {
            List<SlotType> slots = ToolLevellingUtil.parseSlotsHistory(context.getPersistentData().getString(SLOT_HISTORY_KEY));
            for (SlotType slot : slots) {
                volatileData.addSlots(slot, 1);
            }
        }
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        if (ToolLevellingUtil.isStatsLevellingEnabled(context)) {
            List<FloatToolStat> stats = ToolLevellingUtil.parseStatsHistory(context.getPersistentData().getString(STAT_HISTORY_KEY));
            for (FloatToolStat stat : stats) {
                stat.add(builder, ToolLevellingUtil.getStatValue(context, stat));
            }
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        ServerPlayer player = context.getPlayer();
        if (!((Boolean)Config.enableMiningXp.get()).booleanValue() || !context.isEffective() || player == null) {
            return;
        }
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!this.isEqualTinkersItem(tool, (IToolStackView)toolStack)) {
            toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.OFF_HAND);
        }
        ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusMiningXp.get(), player);
    }

    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player player;
        if (!((Boolean)Config.enableHarvestingXp.get()).booleanValue() || !((player = context.m_43723_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player2, (InteractionHand)context.m_43724_());
        ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusHarvestingXp.get(), player2);
    }

    public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
        if (!((Boolean)Config.enableShearingXp.get()).booleanValue() || !(player instanceof ServerPlayer)) {
            return;
        }
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!this.isEqualTinkersItem(tool, (IToolStackView)toolStack)) {
            toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.OFF_HAND);
        }
        ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusShearingXp.get(), (ServerPlayer)player);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        ServerPlayer player;
        block6: {
            block5: {
                Player player2;
                if (!((Boolean)Config.enableAttackingXp.get()).booleanValue() || !((player2 = context.getPlayerAttacker()) instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)player2;
                if (this.isAttackAllowed(context, tool) && (((Boolean)Config.enablePvp.get()).booleanValue() || !(context.getLivingTarget() instanceof Player)) && context.getLivingTarget() != null && !(context.getTarget() instanceof ArmorStand)) break block6;
            }
            return;
        }
        int xp = ((Boolean)Config.damageDealt.get() != false ? Math.round(damageDealt) : 1) + (Integer)Config.bonusAttackingXp.get();
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)context.getPlayerAttacker(), (EquipmentSlot)context.getSlotType());
        ToolLevellingUtil.addExperience(toolStack, xp, player);
        MeleeHitToolHook hook = (MeleeHitToolHook)tool.getDefinitionData().getHook(ToolHooks.MELEE_HIT);
        if (hook instanceof SweepWeaponAttack) {
            SweepWeaponAttack sweepHook = (SweepWeaponAttack)hook;
            this.handleSweepAttack(context, toolStack, player, damageDealt, sweepHook.range());
        }
        if (hook instanceof CircleWeaponAttack) {
            CircleWeaponAttack circleHook = (CircleWeaponAttack)hook;
            this.handleCircleAttack(context, toolStack, player, damageDealt, circleHook.diameter());
        }
    }

    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        ServerPlayer player;
        block5: {
            block4: {
                LivingEntity livingEntity;
                if (!((Boolean)Config.enableTakingDamageXp.get()).booleanValue() || slotType.m_20743_() != EquipmentSlot.Type.ARMOR || !isDirectDamage || !((livingEntity = context.getEntity()) instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)livingEntity;
                if (player.f_19802_ <= 10 && this.isValidDamageSource(source, (Player)player)) break block5;
            }
            return;
        }
        float damageBlocked = this.damageBlocked(player, source, amount);
        if (amount <= damageBlocked) {
            return;
        }
        int xp = ((Boolean)Config.damageTaken.get() != false ? Math.round(amount - damageBlocked) : 1) + (Integer)Config.bonusTakingDamageXp.get() + this.getThornsBonus(tool);
        ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)slotType), xp, player);
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (!((Boolean)Config.enableShootingXp.get()).booleanValue() || !(shooter instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)shooter;
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
        if (!this.isEqualTinkersItem(tool, (IToolStackView)toolStack)) {
            toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (InteractionHand)InteractionHand.OFF_HAND);
        }
        ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusShootingXp.get(), player);
    }

    public void afterTransformBlock(IToolStackView tool, ModifierEntry modifier, UseOnContext context, BlockState state, BlockPos pos, ToolAction action) {
        Player player = context.m_43723_();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player2, (InteractionHand)context.m_43724_());
        if (((Boolean)Config.enableStrippingXp.get()).booleanValue() && action.equals(ToolActions.AXE_STRIP)) {
            ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusStrippingXp.get(), player2);
        } else if (((Boolean)Config.enableScrappingXp.get()).booleanValue() && action.equals(ToolActions.AXE_SCRAPE)) {
            ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusScrappingXp.get(), player2);
        } else if (((Boolean)Config.enableWaxingOffXp.get()).booleanValue() && action.equals(ToolActions.AXE_WAX_OFF)) {
            ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusWaxingOffXp.get(), player2);
        } else if (((Boolean)Config.enableTillingXp.get()).booleanValue() && action.equals(ToolActions.HOE_TILL)) {
            ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusTillingXp.get(), player2);
        } else if (((Boolean)Config.enablePathMakingXp.get()).booleanValue() && action.equals(ToolActions.SHOVEL_FLATTEN)) {
            ToolLevellingUtil.addExperience(toolStack, 1 + (Integer)Config.bonusPathMakingXp.get(), player2);
        }
    }

    public boolean elytraFlightTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int flightTicks) {
        if (!((Boolean)Config.enableFlyingXp.get()).booleanValue() || !(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (flightTicks > 0 && flightTicks % (Integer)Config.flyingTime.get() == 0) {
            ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)EquipmentSlot.CHEST), 1 + (Integer)Config.bonusFlyingXp.get(), player);
        }
        return false;
    }

    @SubscribeEvent
    static void onBlock(ShieldBlockEvent event) {
        if (!((Boolean)Config.enableBlockingDamageXp.get()).booleanValue()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack activeStack = entity.m_21211_();
        if (ModifierUtil.getModifierLevel((ItemStack)activeStack, (ModifierId)((ImprovableModifier)Registration.IMPROVABLE.get()).getId()) <= 0) {
            return;
        }
        if (!activeStack.m_41619_() && activeStack.m_204117_(TinkerTags.Items.MODIFIABLE) && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ToolStack tool = ToolStack.from((ItemStack)activeStack);
            float blockAngle = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)ToolStats.BLOCK_ANGLE) / 2.0f;
            if (!tool.isBroken() && ImprovableModifier.canBlock(player, event.getDamageSource().m_7270_(), blockAngle)) {
                int xp = (int)(((Boolean)Config.damageBlocked.get() != false ? Math.min(event.getBlockedDamage(), ((Float)tool.getStats().get((IToolStat)ToolStats.BLOCK_AMOUNT)).floatValue()) : 1.0f) + (float)((Integer)Config.bonusBlockingDamageXp.get()).intValue());
                ToolLevellingUtil.addExperience(tool, xp, player);
            }
        }
    }

    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        ServerPlayer player;
        if (!(living instanceof ServerPlayer) || !(player = (ServerPlayer)living).m_20096_() || tool.isBroken()) {
            return;
        }
        int xp = 0;
        for (ModifierEntry entry : tool.getModifierList()) {
            ArmorWalkModifierHook hook = (ArmorWalkModifierHook)entry.getHook(ModifierHooks.BOOT_WALK);
            if (hook instanceof ToolActionWalkerTransformModule) {
                ToolActionWalkerTransformModule toolAction = (ToolActionWalkerTransformModule)hook;
                if (((Boolean)Config.enablePlowingXp.get()).booleanValue() && entry.getId().equals((Object)ModifierIds.plowing)) {
                    xp = 1 + (Integer)Config.bonusPlowingXp.get();
                }
                if (((Boolean)Config.enablePathMakerXp.get()).booleanValue() && entry.getId().equals((Object)ModifierIds.pathMaker)) {
                    xp = 1 + (Integer)Config.bonusPathMakerXp.get();
                }
                if (xp > 0) {
                    this.handleWalkerTransform(tool, player, entry, toolAction, xp);
                }
                return;
            }
            if (hook instanceof CoverGroundWalkerModule) {
                CoverGroundWalkerModule coverGround = (CoverGroundWalkerModule)hook;
                if (((Boolean)Config.enableSnowdriftXp.get()).booleanValue() && entry.getId().equals((Object)ModifierIds.snowdrift)) {
                    xp = 1 + (Integer)Config.bonusSnowdriftXp.get();
                }
                if (xp > 0) {
                    this.handleWalkerCoverGround(tool, player, entry, coverGround, xp);
                }
                return;
            }
            if (hook instanceof ReplaceBlockWalkerModule) {
                ReplaceBlockWalkerModule replaceBlock = (ReplaceBlockWalkerModule)hook;
                if (((Boolean)Config.enableFrostWalkerXp.get()).booleanValue() && entry.getId().equals((Object)ModifierIds.frostWalker)) {
                    xp = 1 + (Integer)Config.bonusFrostWalkerXp.get();
                }
                if (xp > 0) {
                    this.handleWalkerReplaceBlock(tool, player, entry, replaceBlock, xp);
                }
                return;
            }
            if (!(hook instanceof FlamewakeModifier) || !((Boolean)Config.enableFlamewakeXp.get()).booleanValue()) continue;
            xp = 1 + (Integer)Config.bonusFlamewakeXp.get();
            this.handleFlamewake(tool, player, xp);
            return;
        }
    }

    @SubscribeEvent
    static void onWarp(SlingModifierTeleportEvent event) {
        Entity entity;
        if (event.isCanceled()) {
            return;
        }
        IToolStackView tool = event.getTool();
        if (((Boolean)Config.enableWarpingXp.get()).booleanValue() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (event.getEntry().getId().equals((Object)TinkerModifiers.warping.getId()) && tool.getModifierLevel(((ImprovableModifier)Registration.IMPROVABLE.get()).getId()) > 0) {
                ToolLevellingUtil.addExperience((ToolStack)tool, 1 + (Integer)Config.bonusWarpingXp.get(), player);
            }
        }
    }

    @SubscribeEvent
    static void onStopUsing(LivingEntityUseItemEvent.Stop event) {
        ServerPlayer player;
        ItemStack item;
        block8: {
            block7: {
                LivingEntity livingEntity;
                item = event.getItem();
                if (event.isCanceled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block7;
                player = (ServerPlayer)livingEntity;
                if (!item.m_41619_() && item.m_204117_(TinkerTags.Items.MODIFIABLE)) break block8;
            }
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)item);
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        if (activeModifier == ModifierEntry.EMPTY) {
            return;
        }
        if (((Boolean)Config.enableFlingingXp.get()).booleanValue() && TinkerModifiers.flinging.getId().equals((Object)activeModifier.getId()) && player.m_20096_()) {
            ImprovableModifier.handleFlinging(player, tool);
            return;
        }
        if (((Boolean)Config.enableSpringingXp.get()).booleanValue() && TinkerModifiers.springing.getId().equals((Object)activeModifier.getId()) && !player.m_21255_()) {
            ImprovableModifier.handleSpringing(player, tool);
            return;
        }
        if (((Boolean)Config.enableBonkingXp.get()).booleanValue() && TinkerModifiers.bonking.getId().equals((Object)activeModifier.getId())) {
            ImprovableModifier.handleBonking(player, tool);
        }
    }

    @SubscribeEvent
    static void onClickEntity(PlayerInteractEvent.EntityInteract event) {
        ServerPlayer player;
        ItemStack item;
        block5: {
            block4: {
                Player player2;
                item = event.getItemStack();
                if (event.isCanceled() || !((player2 = event.getEntity()) instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                if (!item.m_41619_() && item.m_204117_(TinkerTags.Items.MODIFIABLE)) break block5;
            }
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)item);
        if (((Boolean)Config.enableFirestarterXp.get()).booleanValue() && !tool.isBroken() && event.getTarget() instanceof Creeper && tool.getModifier(TinkerModifiers.firestarter.getId()) != ModifierEntry.EMPTY && ((InteractionToolModule)tool.getHook(ToolHooks.INTERACTION)).canInteract((IToolStackView)tool, TinkerModifiers.firestarter.getId(), InteractionSource.RIGHT_CLICK)) {
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusFirestarterXp.get(), player);
        }
    }

    @SubscribeEvent
    static void onAttackEntity(AttackEntityEvent event) {
        ServerPlayer player;
        Player player2;
        if (event.isCanceled() || !((player2 = event.getEntity()) instanceof ServerPlayer) || (player = (ServerPlayer)player2).m_5833_()) {
            return;
        }
        ItemStack item = player.m_21205_();
        if (item.m_41619_() || !item.m_204117_(TinkerTags.Items.MODIFIABLE) || !item.m_204117_(TinkerTags.Items.INTERACTABLE_LEFT) || player.m_36335_().m_41519_(item.m_41720_())) {
            return;
        }
        ToolStack tool = ToolStack.from((ItemStack)item);
        if (((Boolean)Config.enableFirestarterXp.get()).booleanValue() && !tool.isBroken() && event.getTarget() instanceof Creeper && tool.getModifier(TinkerModifiers.firestarter.getId()) != ModifierEntry.EMPTY && ((InteractionToolModule)tool.getHook(ToolHooks.INTERACTION)).canInteract((IToolStackView)tool, TinkerModifiers.firestarter.getId(), InteractionSource.LEFT_CLICK)) {
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusFirestarterXp.get(), player);
        }
    }

    @SubscribeEvent
    static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        ItemStack item;
        block3: {
            block2: {
                Player player2;
                item = event.getItemStack();
                if (event.isCanceled() || !((player2 = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!item.m_41619_() && item.m_204117_(TinkerTags.Items.MODIFIABLE)) break block3;
            }
            return;
        }
        ImprovableModifier.handleBlockClick((PlayerInteractEvent)event, player, ToolStack.from((ItemStack)item), InteractionSource.RIGHT_CLICK);
    }

    @SubscribeEvent
    static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ServerPlayer player;
        ItemStack item;
        block3: {
            block2: {
                Player player2;
                item = event.getItemStack();
                if (event.isCanceled() || !((player2 = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!item.m_41619_() && item.m_204117_(TinkerTags.Items.MODIFIABLE) && item.m_204117_(TinkerTags.Items.INTERACTABLE_LEFT)) break block3;
            }
            return;
        }
        ImprovableModifier.handleBlockClick((PlayerInteractEvent)event, player, ToolStack.from((ItemStack)item), InteractionSource.LEFT_CLICK);
    }

    private boolean isEqualTinkersItem(IToolStackView item1, IToolStackView item2) {
        if (item1 == null || item2 == null || item1.getItem() != item2.getItem()) {
            return false;
        }
        return item1.getModifiers().equals((Object)item2.getModifiers()) && item1.getMaterials().equals((Object)item2.getMaterials());
    }

    private boolean isAttackAllowed(ToolAttackContext context, IToolStackView tool) {
        ModifierEntry activeModifier = GeneralInteractionModifierHook.getActiveModifier((IToolStackView)tool);
        return !context.isExtraAttack() || activeModifier == ModifierEntry.EMPTY || TinkerModifiers.bonking.getId().equals((Object)activeModifier.getId());
    }

    private boolean isValidDamageSource(DamageSource source, Player player) {
        LivingEntity attacker;
        Entity entity;
        return !source.m_269533_(DamageTypeTags.f_268490_) && (entity = source.m_7639_()) instanceof LivingEntity && !(attacker = (LivingEntity)entity).equals((Object)player) && ((Boolean)Config.enablePvp.get() != false || !(attacker instanceof Player));
    }

    private int getThornsBonus(IToolStackView tool) {
        int thornsLevel = tool.getModifierLevel(TinkerModifiers.thorns.getId());
        if (!((Boolean)Config.enableThornsXp.get()).booleanValue() || thornsLevel == 0) {
            return 0;
        }
        return RANDOM.nextFloat() < (float)thornsLevel * 0.15f ? 1 + RANDOM.nextInt((Integer)Config.bonusThornsXp.get() + 1) : 0;
    }

    private float damageBlocked(ServerPlayer player, DamageSource source, float amount) {
        ItemStack activeStack = player.m_21211_();
        if (activeStack.m_41619_()) {
            return 0.0f;
        }
        if (activeStack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from((ItemStack)activeStack);
            if (!tool.isBroken()) {
                float blockAngle = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)player, (FloatToolStat)ToolStats.BLOCK_ANGLE) / 2.0f;
                if (ImprovableModifier.canBlock(player, source.m_7270_(), blockAngle)) {
                    return ((Float)tool.getStats().get((IToolStat)ToolStats.BLOCK_AMOUNT)).floatValue();
                }
            }
        } else if (activeStack.m_41720_() instanceof ShieldItem && ImprovableModifier.canBlock(player, source.m_7270_(), 90.0f)) {
            return amount;
        }
        return 0.0f;
    }

    private static boolean canBlock(ServerPlayer player, @Nullable Vec3 sourcePosition, float blockAngle) {
        if (sourcePosition == null) {
            return false;
        }
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 entityPosition = player.m_20182_();
        Vec3 direction = new Vec3(entityPosition.f_82479_ - sourcePosition.f_82479_, 0.0, entityPosition.f_82481_ - sourcePosition.f_82481_);
        double length = viewVector.m_82553_() * direction.m_82553_();
        if (length < 1.0E-4) {
            return false;
        }
        double angle = Math.abs(180.0 - Math.acos(direction.m_82526_(viewVector) / length) * 57.2957763671875);
        return (double)blockAngle >= angle;
    }

    private void handleSweepAttack(ToolAttackContext context, ToolStack toolStack, ServerPlayer player, float damageDealt, float baseRange) {
        if (!context.isFullyCharged() || player.m_20142_() || context.isCritical() || !player.m_20096_() || player.f_19787_ - player.f_19867_ >= player.m_6113_()) {
            return;
        }
        double range = 2.0f + baseRange + (float)toolStack.getModifierLevel(TinkerModifiers.expanded.getId());
        float sweepDamage = ((SweepingEdgeModifier)TinkerModifiers.sweeping.get()).getSweepingDamage((IToolStackView)toolStack, damageDealt);
        this.handleAOETargets(toolStack, player, context.getTarget(), sweepDamage, range);
    }

    private void handleCircleAttack(ToolAttackContext context, ToolStack toolStack, ServerPlayer player, float damageDealt, float baseDiameter) {
        if (!context.isFullyCharged()) {
            return;
        }
        double range = baseDiameter + (float)toolStack.getModifierLevel(TinkerModifiers.expanded.getId());
        if (range <= 0.0) {
            return;
        }
        this.handleAOETargets(toolStack, player, context.getTarget(), damageDealt, range);
    }

    private void handleAOETargets(ToolStack toolStack, ServerPlayer player, Entity target, float damage, double range) {
        for (LivingEntity aoeTarget : player.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(range, 0.25, range))) {
            if (aoeTarget == player || aoeTarget == target || player.m_7307_((Entity)aoeTarget) || aoeTarget instanceof ArmorStand || !(target.m_20280_((Entity)aoeTarget) < range * range)) continue;
            int xp = ((Boolean)Config.damageDealt.get() != false ? Math.round(damage) : 1) + (Integer)Config.bonusAttackingXp.get();
            ToolLevellingUtil.addExperience(toolStack, xp, player);
        }
    }

    private void handleWalkerTransform(IToolStackView tool, ServerPlayer player, ModifierEntry entry, ToolActionWalkerTransformModule module, int xp) {
        float trueRadius = Math.min(16.0f, module.getRadius(tool, entry));
        int radius = Mth.m_14143_((float)trueRadius);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Vec3 posVec = player.m_20182_();
        BlockPos center = BlockPos.m_274561_((double)posVec.f_82479_, (double)(posVec.f_82480_ + 0.5), (double)posVec.f_82481_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, 0, radius))) {
            if (!pos.m_203195_((Position)player.m_20182_(), (double)trueRadius) || !player.m_9236_().m_8055_(pos).m_247087_()) continue;
            mutable.m_122178_(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
            MutableUseOnContext context = module.getContext(tool, entry, (LivingEntity)player, pos, (BlockPos)mutable);
            context.setOffsetPos((BlockPos)mutable);
            BlockState original = player.m_9236_().m_8055_((BlockPos)mutable);
            BlockState transformed = original.getToolModifiedState((UseOnContext)context, module.action(), true);
            if (transformed == null) continue;
            ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)EquipmentSlot.FEET), xp, player);
        }
    }

    private void handleWalkerCoverGround(IToolStackView tool, ServerPlayer player, ModifierEntry entry, CoverGroundWalkerModule module, int xp) {
        float trueRadius = Math.min(16.0f, module.getRadius(tool, entry));
        int radius = Mth.m_14143_((float)trueRadius);
        Vec3 posVec = player.m_20182_();
        Level world = player.m_9236_();
        BlockPos center = BlockPos.m_274561_((double)posVec.f_82479_, (double)(posVec.f_82480_ + 0.5), (double)posVec.f_82481_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, 0, radius))) {
            if (!pos.m_203195_((Position)player.m_20182_(), (double)trueRadius) || !world.m_46859_(pos) || !module.state().m_60710_((LevelReader)world, pos)) continue;
            ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)EquipmentSlot.FEET), xp, player);
        }
    }

    private void handleWalkerReplaceBlock(IToolStackView tool, ServerPlayer player, ModifierEntry entry, ReplaceBlockWalkerModule module, int xp) {
        float trueRadius = Math.min(16.0f, module.getRadius(tool, entry));
        int radius = Mth.m_14143_((float)trueRadius);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Level world = player.m_9236_();
        Vec3 posVec = player.m_20182_();
        BlockPos center = BlockPos.m_274561_((double)posVec.f_82479_, (double)(posVec.f_82480_ + 0.5), (double)posVec.f_82481_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, 0, radius))) {
            if (!pos.m_203195_((Position)player.m_20182_(), (double)trueRadius) || !world.m_46859_(pos)) continue;
            mutable.m_122178_(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
            BlockState state = Blocks.f_50449_.m_49966_();
            if (!world.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_49990_) || !state.m_60710_((LevelReader)world, (BlockPos)mutable) || !world.m_45752_(state, (BlockPos)mutable, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)mutable), (Direction)Direction.UP)) continue;
            ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)EquipmentSlot.FEET), xp, player);
        }
    }

    private void handleFlamewake(IToolStackView tool, ServerPlayer player, int xp) {
        float trueRadius = Math.min(16.0f, 1.5f + (float)tool.getModifierLevel(TinkerModifiers.expanded.getId()));
        int radius = Mth.m_14143_((float)trueRadius);
        Vec3 posVec = player.m_20182_();
        BlockPos center = BlockPos.m_274561_((double)posVec.f_82479_, (double)(posVec.f_82480_ + 0.5), (double)posVec.f_82481_);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, 0, radius))) {
            if (!pos.m_203195_((Position)player.m_20182_(), (double)trueRadius) || !BaseFireBlock.m_49255_((Level)player.m_9236_(), (BlockPos)pos, (Direction)player.m_6350_())) continue;
            ToolLevellingUtil.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlot)EquipmentSlot.FEET), xp, player);
        }
    }

    private static void handleFlinging(ServerPlayer player, ToolStack tool) {
        BlockHitResult mop = ModifiableItem.blockRayTrace((Level)player.m_9236_(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (mop.m_6662_() == HitResult.Type.BLOCK) {
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusFlingingXp.get(), player);
        }
    }

    private static void handleSpringing(ServerPlayer player, ToolStack tool) {
        ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusSpringingXp.get(), player);
    }

    private static void handleBonking(ServerPlayer player, ToolStack tool) {
        float range = 5.0f;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 look = player.m_20154_();
        Vec3 direction = start.m_82520_(look.f_82479_ * (double)range, look.f_82480_ * (double)range, look.f_82481_ * (double)range);
        AABB bb = player.m_20191_().m_82363_(look.f_82479_ * (double)range, look.f_82480_ * (double)range, look.f_82481_ * (double)range).m_82363_(1.0, 1.0, 1.0);
        EntityHitResult hit = ProjectileUtil.m_37304_((Level)player.m_9236_(), (Entity)player, (Vec3)start, (Vec3)direction, (AABB)bb, e -> e instanceof LivingEntity);
        if (hit != null) {
            LivingEntity target = (LivingEntity)hit.m_82443_();
            double targetDist = start.m_82557_(target.m_20299_(1.0f));
            BlockHitResult mop = ModifiableItem.blockRayTrace((Level)player.m_9236_(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (mop.m_6662_() != HitResult.Type.BLOCK || targetDist < mop.m_82425_().m_203193_((Position)start)) {
                ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusBonkingXp.get(), player);
            }
        }
    }

    private static void handleBlockClick(PlayerInteractEvent event, ServerPlayer player, ToolStack tool, InteractionSource clickSource) {
        if (((Boolean)Config.enableGlowingXp.get()).booleanValue() && tool.getCurrentDurability() >= 10 && event.getFace() != null && tool.getModifier(TinkerModifiers.glowing.getId()) != ModifierEntry.EMPTY && ((InteractionToolModule)tool.getHook(ToolHooks.INTERACTION)).canInteract((IToolStackView)tool, TinkerModifiers.glowing.getId(), clickSource)) {
            ImprovableModifier.handleGlowing(event, player, tool);
            return;
        }
        if (((Boolean)Config.enableFirestarterXp.get()).booleanValue() && !tool.isBroken() && event.getFace() != null && tool.getModifier(TinkerModifiers.firestarter.getId()) != ModifierEntry.EMPTY && ((InteractionToolModule)tool.getHook(ToolHooks.INTERACTION)).canInteract((IToolStackView)tool, TinkerModifiers.firestarter.getId(), clickSource)) {
            ImprovableModifier.handleFirestarter(event, player, tool);
        }
    }

    private static void handleGlowing(PlayerInteractEvent event, ServerPlayer player, ToolStack tool) {
        Level world = event.getLevel();
        Direction face = event.getFace();
        BlockPos pos = event.getPos().m_121945_(face);
        if (ImprovableModifier.canPlaceGlow(world, pos, face.m_122424_())) {
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusGlowingXp.get(), player);
        }
    }

    private static boolean canPlaceGlow(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        GlowBlock glowBlock = (GlowBlock)TinkerCommons.glow.get();
        if (state.m_60734_() != glowBlock && state.m_247087_()) {
            if (ImprovableModifier.canGlowBlockStay(world, pos, direction)) {
                return true;
            }
            for (Direction direction1 : Direction.values()) {
                if (!ImprovableModifier.canGlowBlockStay(world, pos, direction1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canGlowBlockStay(Level world, BlockPos pos, Direction facing) {
        BlockPos placedOn = pos.m_121945_(facing);
        boolean isSolidSide = Block.m_49918_((VoxelShape)world.m_8055_(placedOn).m_60768_((BlockGetter)world, pos), (Direction)facing.m_122424_());
        boolean isLiquid = world.m_8055_(pos).m_60734_() instanceof LiquidBlock;
        return !isLiquid && isSolidSide;
    }

    private static void handleFirestarter(PlayerInteractEvent event, ServerPlayer player, ToolStack tool) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Direction sideHit = event.getFace();
        BlockState state = world.m_8055_(pos);
        boolean targetingFire = false;
        if (state.m_204336_(BlockTags.f_13076_)) {
            pos = pos.m_121945_(sideHit.m_122424_());
            targetingFire = true;
        }
        int range = tool.getModifierLevel(TinkerModifiers.fireprimer.getId()) + tool.getModifierLevel(TinkerModifiers.expanded.getId());
        Iterable<Object> targets = Collections.emptyList();
        if (range > 0) {
            targets = CircleAOEIterator.calculate((IToolStackView)tool, (ItemStack)ItemStack.f_41583_, (Level)world, (Player)player, (BlockPos)pos, (Direction)sideHit, (int)(1 + range), (boolean)true, (AreaOfEffectIterator.AOEMatchType)AreaOfEffectIterator.AOEMatchType.TRANSFORM);
        }
        Direction horizontalFacing = player.m_6350_();
        if (!targetingFire && ImprovableModifier.canIgnite(world, pos, state, sideHit, horizontalFacing)) {
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusFirestarterXp.get(), player);
        }
        for (BlockPos target : targets) {
            if (!ImprovableModifier.canIgnite(world, target, world.m_8055_(target), sideHit, horizontalFacing)) continue;
            ToolLevellingUtil.addExperience(tool, 1 + (Integer)Config.bonusFirestarterXp.get(), player);
        }
    }

    private static boolean canIgnite(Level world, BlockPos pos, BlockState state, Direction sideHit, Direction facing) {
        return CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state) || state.m_60734_() instanceof TntBlock || BaseFireBlock.m_49255_((Level)world, (BlockPos)pos.m_121945_(sideHit), (Direction)facing);
    }
}

