/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import xratedjunior.betterdefaultbiomes.block.block.StarfishBlock;
import xratedjunior.betterdefaultbiomes.data.BDBTags;
import xratedjunior.betterdefaultbiomes.world.generation.feature.configurations.StarfishConfiguration;

public class StarfishFeature
extends Feature<StarfishConfiguration> {
    private boolean isCoralFeature;
    private boolean debugMode = false;

    public StarfishFeature(Codec<StarfishConfiguration> codec, boolean isCoralFeatureIn) {
        super(codec);
        this.isCoralFeature = isCoralFeatureIn;
    }

    public boolean m_142674_(FeaturePlaceContext<StarfishConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        List<DyeColor> generationColors = ((StarfishConfiguration)context.m_159778_()).getGenerationColors();
        if (this.isCoralFeature) {
            int starfishCount = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = 0; y <= 6; ++y) {
                        BlockState coralStarfishBlockState;
                        BlockPos coralBlockPos = pos.m_7918_(x, y, z);
                        BlockState coralBlock = worldgenlevel.m_8055_(coralBlockPos);
                        if (!(coralBlock.m_60734_() instanceof CoralBlock)) continue;
                        if (worldgenlevel.m_8055_(coralBlockPos.m_7495_()).m_60713_(Blocks.f_49990_) && rand.m_188503_(2) == 0) {
                            coralStarfishBlockState = (BlockState)((BlockState)((BlockState)((BlockState)StarfishBlock.getBlockByColor(this.getRandomColor(rand, generationColors)).m_49966_().m_61124_((Property)StarfishBlock.f_54117_, (Comparable)this.getRandomHorizontalDirection(rand))).m_61124_((Property)StarfishBlock.f_53179_, (Comparable)AttachFace.CEILING)).m_61124_((Property)StarfishBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)StarfishBlock.LIT, (Comparable)Boolean.valueOf(rand.m_188503_(4) == 0));
                            worldgenlevel.m_7731_(coralBlockPos.m_7495_(), coralStarfishBlockState, 2);
                            ++starfishCount;
                        }
                        if (worldgenlevel.m_8055_(coralBlockPos.m_7494_()).m_60713_(Blocks.f_49990_) && rand.m_188503_(4) == 0) {
                            coralStarfishBlockState = (BlockState)((BlockState)((BlockState)((BlockState)StarfishBlock.getBlockByColor(this.getRandomColor(rand, generationColors)).m_49966_().m_61124_((Property)StarfishBlock.f_54117_, (Comparable)this.getRandomHorizontalDirection(rand))).m_61124_((Property)StarfishBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)StarfishBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)StarfishBlock.LIT, (Comparable)Boolean.valueOf(rand.m_188503_(4) == 0));
                            worldgenlevel.m_7731_(coralBlockPos.m_7494_(), coralStarfishBlockState, 2);
                            ++starfishCount;
                        }
                        for (Direction direction : Direction.Plane.HORIZONTAL) {
                            if (!worldgenlevel.m_8055_(coralBlockPos.m_121945_(direction)).m_60713_(Blocks.f_49990_) || rand.m_188503_(4) != 0) continue;
                            BlockState coralStarfishBlockState2 = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)StarfishBlock.getWallBlockByColor(this.getRandomColor(rand, generationColors)).m_49966_().m_61124_(StarfishBlock.WALL_FACING, (Comparable)((Object)StarfishBlock.WallFacing.getRandomWallFacingDirection(rand)))).m_61124_((Property)StarfishBlock.f_54117_, (Comparable)direction)).m_61124_((Property)StarfishBlock.f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)StarfishBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)StarfishBlock.LIT, (Comparable)Boolean.valueOf(rand.m_188503_(4) == 0));
                            worldgenlevel.m_7731_(coralBlockPos.m_121945_(direction), coralStarfishBlockState2, 2);
                            ++starfishCount;
                        }
                        if (!this.debugMode) continue;
                        worldgenlevel.m_7731_(coralBlockPos, Blocks.f_50386_.m_49966_(), 2);
                    }
                }
            }
            return starfishCount > 0;
        }
        DyeColor randomColor = this.getRandomColor(rand, generationColors);
        Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(rand);
        BlockState starfishBlockState = (BlockState)StarfishBlock.getBlockByColor(randomColor).m_49966_().m_61124_((Property)StarfishBlock.f_54117_, (Comparable)randomDirection);
        if (starfishBlockState.m_60710_((LevelReader)worldgenlevel, pos)) {
            if (worldgenlevel.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                this.placeStarfish(worldgenlevel, rand, pos, starfishBlockState, randomColor, true);
                return true;
            }
            if (worldgenlevel.m_46859_(pos) && worldgenlevel.m_8055_(pos.m_7495_()).m_204336_(BDBTags.Blocks.BEACH_SAND)) {
                this.placeStarfish(worldgenlevel, rand, pos, starfishBlockState, randomColor, false);
                return true;
            }
        }
        return false;
    }

    private void placeStarfish(WorldGenLevel world, RandomSource rand, BlockPos blockpos, BlockState starfishBlockState, DyeColor starfishColor, boolean waterlogged) {
        if (waterlogged && rand.m_188503_(4) <= 2) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.m_8055_(blockpos.m_7495_().m_121945_(direction)).m_60713_(Blocks.f_49990_)) continue;
                starfishBlockState = (BlockState)((BlockState)((BlockState)StarfishBlock.getWallBlockByColor(starfishColor).m_49966_().m_61124_((Property)StarfishBlock.f_54117_, (Comparable)direction)).m_61124_((Property)StarfishBlock.f_53179_, (Comparable)AttachFace.WALL)).m_61124_(StarfishBlock.WALL_FACING, (Comparable)((Object)StarfishBlock.WallFacing.getRandomWallFacingDirection(rand)));
                world.m_7731_(blockpos.m_7495_().m_121945_(direction), (BlockState)starfishBlockState.m_61124_((Property)StarfishBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 2);
                if (this.debugMode) {
                    world.m_7731_(blockpos.m_7495_(), Blocks.f_50141_.m_49966_(), 2);
                }
                return;
            }
        }
        world.m_7731_(blockpos, (BlockState)starfishBlockState.m_61124_((Property)StarfishBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 2);
        if (this.debugMode) {
            world.m_7731_(blockpos.m_7495_(), Blocks.f_50141_.m_49966_(), 2);
        }
    }

    private Direction getRandomHorizontalDirection(RandomSource rand) {
        return Direction.Plane.HORIZONTAL.m_235690_(rand);
    }

    private DyeColor getRandomColor(RandomSource rand, List<DyeColor> colorList) {
        return colorList.get(rand.m_188503_(colorList.size()));
    }
}

