/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.generation;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.world.generation.BDBFeatures;
import xratedjunior.betterdefaultbiomes.world.generation.feature.BigGrayMushroomFeature;
import xratedjunior.betterdefaultbiomes.world.generation.feature.BigWhiteMushroomFeature;
import xratedjunior.betterdefaultbiomes.world.generation.feature.BigYellowMushroomFeature;
import xratedjunior.betterdefaultbiomes.world.generation.feature.configurations.SmallRockConfiguration;
import xratedjunior.betterdefaultbiomes.world.generation.feature.configurations.StarfishConfiguration;

public class BDBConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> FEATHER_REED_GRASS = BDBConfiguredFeatures.createKey("patch_feather_reed_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_GRASS = BDBConfiguredFeatures.createKey("patch_dead_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHORT_GRASS = BDBConfiguredFeatures.createKey("patch_short_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNE_GRASS = BDBConfiguredFeatures.createKey("patch_dune_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WATER_REEDS = BDBConfiguredFeatures.createKey("patch_water_reeds");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINK_CACTUS_FLOWER = BDBConfiguredFeatures.createKey("patch_pink_cactus_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_VERBENA = BDBConfiguredFeatures.createKey("patch_purple_verbena");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_POPPY = BDBConfiguredFeatures.createKey("patch_blue_poppy");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_VIOLET = BDBConfiguredFeatures.createKey("patch_dark_violet");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHITE_MUSHROOM = BDBConfiguredFeatures.createKey("patch_white_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_MUSHROOM = BDBConfiguredFeatures.createKey("patch_yellow_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAY_MUSHROOM = BDBConfiguredFeatures.createKey("patch_gray_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIG_WHITE_MUSHROOM = BDBConfiguredFeatures.createKey("big_white_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIG_YELLOW_MUSHROOM = BDBConfiguredFeatures.createKey("big_yellow_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIG_GRAY_MUSHROOM = BDBConfiguredFeatures.createKey("big_gray_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_ROCK = BDBConfiguredFeatures.createKey("small_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINECONE = BDBConfiguredFeatures.createKey("pinecone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAND_CASTLE = BDBConfiguredFeatures.createKey("sand_castle");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SEASHELL = BDBConfiguredFeatures.createKey("seashell");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STARFISH = BDBConfiguredFeatures.createKey("starfish");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STARFISH_CORAL = BDBConfiguredFeatures.createKey("starfish_coral");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE = BDBConfiguredFeatures.createKey("palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE_BIG = BDBConfiguredFeatures.createKey("palm_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE_RANDOM = BDBConfiguredFeatures.createKey("palm_tree_random");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SWAMP_WILLOW_TREE = BDBConfiguredFeatures.createKey("swamp_willow_tree");

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        BetterDefaultBiomes.LOGGER.debug("Registering Configured Features");
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        BDBConfiguredFeatures.register(context, FEATHER_REED_GRASS, Feature.f_65763_, BDBConfiguredFeatures.patchConfig(24, 6, 2, BDBBlocks.FEATHER_REED_GRASS));
        BDBConfiguredFeatures.register(context, DEAD_GRASS, Feature.f_65763_, BDBConfiguredFeatures.commonPatchConfig(BDBBlocks.DEAD_GRASS));
        BDBConfiguredFeatures.register(context, SHORT_GRASS, Feature.f_65763_, BDBConfiguredFeatures.commonPatchConfig(BDBBlocks.SHORT_GRASS));
        BDBConfiguredFeatures.register(context, DUNE_GRASS, Feature.f_65763_, BDBConfiguredFeatures.commonPatchConfig(BDBBlocks.DUNE_GRASS));
        BDBConfiguredFeatures.register(context, WATER_REEDS, Feature.f_65763_, new RandomPatchConfiguration(20, 6, 2, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BDBBlocks.TALL_WATER_REEDS.get()))), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)BlockPos.f_121853_, (Block[])new Block[]{Blocks.f_49990_}), (BlockPredicate)BlockPredicate.m_224774_((Vec3i)BlockPos.f_121853_.m_7494_(), (Block[])new Block[]{Blocks.f_50016_})))));
        BDBConfiguredFeatures.register(context, PINK_CACTUS_FLOWER, Feature.f_65763_, BDBConfiguredFeatures.flowerPatchConfig(BDBBlocks.PINK_CACTUS_FLOWER));
        BDBConfiguredFeatures.register(context, PURPLE_VERBENA, Feature.f_65763_, BDBConfiguredFeatures.flowerPatchConfig(BDBBlocks.PURPLE_VERBENA));
        BDBConfiguredFeatures.register(context, BLUE_POPPY, Feature.f_65763_, BDBConfiguredFeatures.flowerPatchConfig(BDBBlocks.BLUE_POPPY));
        BDBConfiguredFeatures.register(context, DARK_VIOLET, Feature.f_65763_, BDBConfiguredFeatures.flowerPatchConfig(BDBBlocks.DARK_VIOLET));
        BDBConfiguredFeatures.register(context, WHITE_MUSHROOM, Feature.f_65763_, BDBConfiguredFeatures.patchConfig(10, 6, 2, BDBBlocks.WHITE_MUSHROOM));
        BDBConfiguredFeatures.register(context, YELLOW_MUSHROOM, Feature.f_65763_, BDBConfiguredFeatures.patchConfig(10, 6, 2, BDBBlocks.YELLOW_MUSHROOM));
        BDBConfiguredFeatures.register(context, GRAY_MUSHROOM, Feature.f_65763_, BDBConfiguredFeatures.patchConfig(10, 6, 2, BDBBlocks.GRAY_MUSHROOM));
        BDBConfiguredFeatures.register(context, BIG_WHITE_MUSHROOM, (BigWhiteMushroomFeature)((Object)BDBFeatures.BIG_WHITE_MUSHROOM.get()), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.WHITE_MUSHROOM_BLOCK), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.MUSHROOM_STEM), 2));
        BDBConfiguredFeatures.register(context, BIG_YELLOW_MUSHROOM, (BigYellowMushroomFeature)((Object)BDBFeatures.BIG_YELLOW_MUSHROOM.get()), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.YELLOW_MUSHROOM_BLOCK), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.MUSHROOM_STEM), 2));
        BDBConfiguredFeatures.register(context, BIG_GRAY_MUSHROOM, (BigGrayMushroomFeature)((Object)BDBFeatures.BIG_GRAY_MUSHROOM.get()), new HugeMushroomFeatureConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.GRAY_MUSHROOM_BLOCK), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.MUSHROOM_STEM), 2));
        BDBConfiguredFeatures.register(context, SMALL_ROCK, (Feature)BDBFeatures.SMALL_ROCK.get(), new SmallRockConfiguration());
        BDBConfiguredFeatures.register(context, PINECONE, (Feature)BDBFeatures.PINECONE.get(), FeatureConfiguration.f_67737_);
        BDBConfiguredFeatures.register(context, SAND_CASTLE, (Feature)BDBFeatures.SIMPLE_BLOCK.get(), new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BDBBlocks.SAND_CASTLE.get()))));
        BDBConfiguredFeatures.register(context, SEASHELL, (Feature)BDBFeatures.SIMPLE_BLOCK.get(), new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BDBBlocks.SEASHELL.get()))));
        BDBConfiguredFeatures.register(context, STARFISH, (Feature)BDBFeatures.STARFISH.get(), new StarfishConfiguration());
        BDBConfiguredFeatures.register(context, STARFISH_CORAL, (Feature)BDBFeatures.STARFISH_CORAL.get(), new StarfishConfiguration());
        BDBConfiguredFeatures.register(context, PALM_TREE, (Feature)BDBFeatures.PALM_TREE.get(), FeatureConfiguration.f_67737_);
        BDBConfiguredFeatures.register(context, PALM_TREE_BIG, (Feature)BDBFeatures.PALM_TREE_BIG.get(), FeatureConfiguration.f_67737_);
        BDBConfiguredFeatures.register(context, PALM_TREE_RANDOM, Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)configuredFeatures.m_255043_(PALM_TREE_BIG), (PlacementModifier[])new PlacementModifier[0]), 0.3f)), PlacementUtils.m_206506_((Holder)configuredFeatures.m_255043_(PALM_TREE), (PlacementModifier[])new PlacementModifier[0])));
        BDBConfiguredFeatures.register(context, SWAMP_WILLOW_TREE, (Feature)BDBFeatures.SWAMP_WILLOW_TREE.get(), FeatureConfiguration.f_67737_);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)BetterDefaultBiomes.locate(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> bigWhiteMushroom2, F feature, FC config) {
        context.m_255272_(bigWhiteMushroom2, (Object)new ConfiguredFeature(feature, config));
    }

    private static RandomPatchConfiguration patchConfig(int tries, int xzSpread, int ySpread, Supplier<Block> block) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, BDBConfiguredFeatures.simpleBlockPlacement(block));
    }

    private static RandomPatchConfiguration flowerPatchConfig(Supplier<Block> block) {
        return BDBConfiguredFeatures.patchConfig(16, 7, 3, block);
    }

    private static RandomPatchConfiguration commonPatchConfig(Supplier<Block> block) {
        return BDBConfiguredFeatures.patchConfig(64, 7, 3, block);
    }

    private static Holder<PlacedFeature> simpleBlockPlacement(Supplier<Block> block) {
        return PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.get())));
    }

    private static final class States {
        private static final BlockState WHITE_MUSHROOM_BLOCK = ((Block)BDBBlocks.WHITE_MUSHROOM_BLOCK.get()).m_49966_();
        private static final BlockState YELLOW_MUSHROOM_BLOCK = ((Block)BDBBlocks.YELLOW_MUSHROOM_BLOCK.get()).m_49966_();
        private static final BlockState GRAY_MUSHROOM_BLOCK = ((Block)BDBBlocks.GRAY_MUSHROOM_BLOCK.get()).m_49966_();
        private static final BlockState MUSHROOM_STEM = (BlockState)((BlockState)Blocks.f_50182_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false));

        private States() {
        }
    }
}

