/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.biomemodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.configuration.DebugConfig;
import xratedjunior.betterdefaultbiomes.world.BDBBiomeModifiers;

public record AddFeaturesWithLogger(HolderSet<Biome> biomes, Optional<HolderSet<Biome>> excludedBiomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) implements BiomeModifier
{
    public static final Codec<AddFeaturesWithLogger> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AddFeaturesWithLogger::biomes), (App)Biome.f_47432_.optionalFieldOf("excluded_biomes").forGetter(modifier -> modifier.excludedBiomes.isEmpty() ? Optional.empty() : Optional.of(modifier.excludedBiomes.get())), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(AddFeaturesWithLogger::features), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(AddFeaturesWithLogger::step)).apply((Applicative)builder, AddFeaturesWithLogger::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            if (!this.excludedBiomes.isEmpty()) {
                if (this.excludedBiomes.get().m_203333_(biome)) {
                    this.features.forEach(featureHolder -> {
                        if (((Boolean)DebugConfig.generation_logger.get()).booleanValue()) {
                            BetterDefaultBiomes.LOGGER.info("The \"{}\" is excluded from: {}.", (Object)((ResourceKey)featureHolder.m_203543_().get()).m_135782_().m_135815_().toUpperCase(), (Object)((ResourceKey)biome.m_203543_().get()).m_135782_());
                        }
                    });
                    return;
                }
            } else {
                BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
                this.features.forEach(featureHolder -> {
                    if (((Boolean)DebugConfig.generation_logger.get()).booleanValue()) {
                        BetterDefaultBiomes.LOGGER.info("The \"{}\" generates in the: {}.", (Object)((ResourceKey)featureHolder.m_203543_().get()).m_135782_().m_135815_().toUpperCase(), (Object)((ResourceKey)biome.m_203543_().get()).m_135782_());
                    }
                    generationSettings.m_255419_(this.step, featureHolder);
                });
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BDBBiomeModifiers.ADD_FEATURES_CODEC.get();
    }
}

