/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.data.BDBTags;
import xratedjunior.betterdefaultbiomes.world.biomemodifier.AddFeaturesWithLogger;
import xratedjunior.betterdefaultbiomes.world.generation.BDBPlacedFeatures;

public class BDBGenerationModifiers {
    public static final ResourceKey<BiomeModifier> FEATHER_REED_GRASS = BDBGenerationModifiers.createKey("add_patch_feather_reed_grass");
    public static final ResourceKey<BiomeModifier> DEAD_GRASS = BDBGenerationModifiers.createKey("add_patch_dead_grass");
    public static final ResourceKey<BiomeModifier> SHORT_GRASS = BDBGenerationModifiers.createKey("add_patch_short_grass");
    public static final ResourceKey<BiomeModifier> DUNE_GRASS = BDBGenerationModifiers.createKey("add_patch_dune_grass");
    public static final ResourceKey<BiomeModifier> WATER_REEDS = BDBGenerationModifiers.createKey("add_patch_water_reeds");
    public static final ResourceKey<BiomeModifier> PINK_CACTUS_FLOWER = BDBGenerationModifiers.createKey("add_patch_pink_cactus_flower");
    public static final ResourceKey<BiomeModifier> PURPLE_VERBENA = BDBGenerationModifiers.createKey("add_patch_purple_verbena");
    public static final ResourceKey<BiomeModifier> BLUE_POPPY = BDBGenerationModifiers.createKey("add_patch_blue_poppy");
    public static final ResourceKey<BiomeModifier> DARK_VIOLET = BDBGenerationModifiers.createKey("add_patch_dark_violet");
    public static final ResourceKey<BiomeModifier> WHITE_MUSHROOM = BDBGenerationModifiers.createKey("add_patch_white_mushroom");
    public static final ResourceKey<BiomeModifier> YELLOW_MUSHROOM = BDBGenerationModifiers.createKey("add_patch_yellow_mushroom");
    public static final ResourceKey<BiomeModifier> GRAY_MUSHROOM = BDBGenerationModifiers.createKey("add_patch_gray_mushroom");
    public static final ResourceKey<BiomeModifier> BIG_WHITE_MUSHROOM = BDBGenerationModifiers.createKey("add_big_white_mushroom");
    public static final ResourceKey<BiomeModifier> BIG_YELLOW_MUSHROOM = BDBGenerationModifiers.createKey("add_big_yellow_mushroom");
    public static final ResourceKey<BiomeModifier> BIG_GRAY_MUSHROOM = BDBGenerationModifiers.createKey("add_big_gray_mushroom");
    public static final ResourceKey<BiomeModifier> SMALL_ROCK = BDBGenerationModifiers.createKey("add_small_rock");
    public static final ResourceKey<BiomeModifier> SMALL_ROCK_UNDERGROUND = BDBGenerationModifiers.createKey("add_small_rock_underground");
    public static final ResourceKey<BiomeModifier> PINECONE = BDBGenerationModifiers.createKey("add_pinecone");
    public static final ResourceKey<BiomeModifier> SAND_CASTLE = BDBGenerationModifiers.createKey("add_sand_castle");
    public static final ResourceKey<BiomeModifier> SEASHELL = BDBGenerationModifiers.createKey("add_seashell");
    public static final ResourceKey<BiomeModifier> STARFISH = BDBGenerationModifiers.createKey("add_starfish");
    public static final ResourceKey<BiomeModifier> STARFISH_CORAL = BDBGenerationModifiers.createKey("add_starfish_coral");
    public static final ResourceKey<BiomeModifier> PALM_TREE = BDBGenerationModifiers.createKey("add_palm_tree");
    public static final ResourceKey<BiomeModifier> SWAMP_WILLOW_TREE = BDBGenerationModifiers.createKey("add_swamp_willow_tree");

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
        List<Holder.Reference<Biome>> mushroomFieldsExcluded = BDBGenerationModifiers.biomeList((HolderGetter<Biome>)biomeGetter, Arrays.asList(Biomes.f_48215_));
        BDBGenerationModifiers.addFeature(context, FEATHER_REED_GRASS, BDBPlacedFeatures.FEATHER_REED_GRASS_FEATURE, BDBTags.Biomes.FEATHER_REED_GRASS, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeatureWithExclusion(context, DEAD_GRASS, BDBPlacedFeatures.DEAD_GRASS_FEATURE, BDBTags.Biomes.DEAD_GRASS, mushroomFieldsExcluded, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeatureWithExclusion(context, SHORT_GRASS, BDBPlacedFeatures.SHORT_GRASS_FEATURE, BDBTags.Biomes.SHORT_GRASS, mushroomFieldsExcluded, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, DUNE_GRASS, BDBPlacedFeatures.DUNE_GRASS_FEATURE, BDBTags.Biomes.DUNE_GRASS, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeatureWithExclusion(context, WATER_REEDS, BDBPlacedFeatures.WATER_REEDS_FEATURE, BDBTags.Biomes.WATER_REEDS, mushroomFieldsExcluded, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, PINK_CACTUS_FLOWER, BDBPlacedFeatures.PINK_CACTUS_FLOWER_FEATURE, BDBTags.Biomes.PINK_CACTUS_FLOWER, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, PURPLE_VERBENA, BDBPlacedFeatures.PURPLE_VERBENA_FEATURE, BDBTags.Biomes.PURPLE_VERBENA, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, BLUE_POPPY, BDBPlacedFeatures.BLUE_POPPY_FEATURE, BDBTags.Biomes.BLUE_POPPY, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, DARK_VIOLET, BDBPlacedFeatures.DARK_VIOLET_FEATURE, BDBTags.Biomes.DARK_VIOLET, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, WHITE_MUSHROOM, BDBPlacedFeatures.WHITE_MUSHROOM_FEATURE, BDBTags.Biomes.WHITE_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, YELLOW_MUSHROOM, BDBPlacedFeatures.YELLOW_MUSHROOM_FEATURE, BDBTags.Biomes.YELLOW_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, GRAY_MUSHROOM, BDBPlacedFeatures.GRAY_MUSHROOM_FEATURE, BDBTags.Biomes.GRAY_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, BIG_WHITE_MUSHROOM, BDBPlacedFeatures.BIG_WHITE_MUSHROOM_FEATURE, BDBTags.Biomes.BIG_WHITE_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, BIG_YELLOW_MUSHROOM, BDBPlacedFeatures.BIG_YELLOW_MUSHROOM_FEATURE, BDBTags.Biomes.BIG_YELLOW_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, BIG_GRAY_MUSHROOM, BDBPlacedFeatures.BIG_GRAY_MUSHROOM_FEATURE, BDBTags.Biomes.BIG_GRAY_MUSHROOM, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeatureWithExclusion(context, SMALL_ROCK, BDBPlacedFeatures.SMALL_ROCK_FEATURE, BDBTags.Biomes.SMALL_ROCK, mushroomFieldsExcluded, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, SMALL_ROCK_UNDERGROUND, BDBPlacedFeatures.SMALL_ROCK_UNDERGROUND_FEATURE, BDBTags.Biomes.SMALL_ROCK, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, PINECONE, BDBPlacedFeatures.PINECONE_FEATURE, BDBTags.Biomes.PINECONE, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, SEASHELL, BDBPlacedFeatures.SEASHELL_FEATURE, BDBTags.Biomes.SEASHELL, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, SAND_CASTLE, BDBPlacedFeatures.SAND_CASTLE_FEATURE, BDBTags.Biomes.SAND_CASTLE, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, STARFISH, BDBPlacedFeatures.STARFISH_FEATURE, BDBTags.Biomes.STARFISH, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, STARFISH_CORAL, BDBPlacedFeatures.STARFISH_CORAL_FEATURE, BDBTags.Biomes.STARFISH, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, PALM_TREE, BDBPlacedFeatures.PALM_TREE_FEATURE, BDBTags.Biomes.PALM_TREE, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
        BDBGenerationModifiers.addFeature(context, SWAMP_WILLOW_TREE, BDBPlacedFeatures.SWAMP_WILLOW_TREE_FEATURE, BDBTags.Biomes.SWAMP_WILLOW_TREE, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomeGetter);
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BetterDefaultBiomes.locate(name));
    }

    private static void addFeature(BootstapContext<BiomeModifier> context, ResourceKey<BiomeModifier> name, ResourceKey<PlacedFeature> feature, TagKey<Biome> biomeTag, HolderGetter<PlacedFeature> featureRegistry, HolderGetter<Biome> biomeRegistry) {
        context.m_255272_(name, (Object)new AddFeaturesWithLogger((HolderSet<Biome>)biomeRegistry.m_254956_(biomeTag), Optional.empty(), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{featureRegistry.m_255043_(feature)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static void addFeatureWithExclusion(BootstapContext<BiomeModifier> context, ResourceKey<BiomeModifier> name, ResourceKey<PlacedFeature> feature, TagKey<Biome> biomeTag, List<Holder.Reference<Biome>> excludedBiomes, HolderGetter<PlacedFeature> featureRegistry, HolderGetter<Biome> biomeRegistry) {
        context.m_255272_(name, (Object)new AddFeaturesWithLogger((HolderSet<Biome>)biomeRegistry.m_254956_(biomeTag), Optional.of(HolderSet.m_205800_(excludedBiomes)), (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{featureRegistry.m_255043_(feature)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static List<Holder.Reference<Biome>> biomeList(HolderGetter<Biome> biomeGetter, List<ResourceKey<Biome>> biomeList) {
        ArrayList<Holder.Reference<Biome>> list = new ArrayList<Holder.Reference<Biome>>();
        biomeList.forEach(biome -> list.add(biomeGetter.m_255043_(biome)));
        return list;
    }
}

