/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.projectile;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import xratedjunior.betterdefaultbiomes.configuration.ItemConfig;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.item.BDBItems;

public class TorchArrowEntity
extends AbstractArrow {
    private static final Supplier<Item> ARROW_TYPE = BDBItems.TORCH_ARROW;
    private int secondsFireDuration = 2;
    private int animateFireTick = 0;

    public TorchArrowEntity(EntityType<? extends TorchArrowEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public TorchArrowEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType)BDBEntityTypes.TORCH_ARROW.get(), shooter, worldIn);
    }

    public TorchArrowEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)BDBEntityTypes.TORCH_ARROW.get(), x, y, z, worldIn);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Duration")) {
            this.secondsFireDuration = compound.m_128451_("Duration");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Duration", this.secondsFireDuration);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ARROW_TYPE.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.animateFireTick >= 4) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20184_().m_7096_() * 0.5, this.m_20184_().m_7098_() * (double)0.8f, this.m_20184_().m_7094_() * 0.5);
                this.animateFireTick = -this.f_19796_.m_188503_(12);
            }
            ++this.animateFireTick;
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (((Boolean)ItemConfig.torch_arrow_fire.get()).booleanValue()) {
            living.m_20254_(this.secondsFireDuration);
        }
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)raytraceResultIn;
            BlockPos pos = blockraytraceresult.m_82425_();
            BlockState blockState = this.m_9236_().m_8055_(pos);
            Block block = blockState.m_60734_();
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            this.m_146870_();
            Block torch = Blocks.f_50081_;
            BlockState defaultTorchState = torch.m_49966_();
            Block wallTorch = Blocks.f_50082_;
            BlockState defaultWallTorchState = wallTorch.m_49966_();
            BlockResult result = BlockResult.PLACE;
            Direction blockFace = blockraytraceresult.m_82434_();
            DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.f_54117_;
            switch (blockFace) {
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    result = BlockResult.DROP;
                    break;
                }
                case NORTH: {
                    --z;
                    defaultWallTorchState = (BlockState)defaultWallTorchState.m_61124_((Property)HORIZONTAL_FACING, (Comparable)blockFace);
                    break;
                }
                case EAST: {
                    ++x;
                    defaultWallTorchState = (BlockState)defaultWallTorchState.m_61124_((Property)HORIZONTAL_FACING, (Comparable)blockFace);
                    break;
                }
                case SOUTH: {
                    ++z;
                    defaultWallTorchState = (BlockState)defaultWallTorchState.m_61124_((Property)HORIZONTAL_FACING, (Comparable)blockFace);
                    break;
                }
                case WEST: {
                    --x;
                    defaultWallTorchState = (BlockState)defaultWallTorchState.m_61124_((Property)HORIZONTAL_FACING, (Comparable)blockFace);
                }
            }
            if (!(blockState.m_60783_((BlockGetter)this.m_9236_(), pos, blockFace) || blockFace.equals((Object)Direction.UP) && (block instanceof FenceBlock || block instanceof WallBlock))) {
                result = BlockResult.DROP;
            }
            pos = new BlockPos(x, y, z);
            if (!this.m_9236_().m_46859_(pos)) {
                result = BlockResult.DROP;
            }
            if (this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_278394_)) {
                result = BlockResult.BREAK;
            }
            switch (result) {
                case PLACE: {
                    if (blockFace.equals((Object)Direction.UP)) {
                        this.m_9236_().m_46597_(pos, defaultTorchState);
                        break;
                    }
                    this.m_9236_().m_46597_(pos, defaultWallTorchState);
                    break;
                }
                case BREAK: {
                    this.m_9236_().m_46961_(pos, true);
                    if (blockFace.equals((Object)Direction.UP)) {
                        this.m_9236_().m_46597_(pos, defaultTorchState);
                        break;
                    }
                    if (!blockState.m_60783_((BlockGetter)this.m_9236_(), pos, blockFace)) break;
                    this.m_9236_().m_46597_(pos, defaultWallTorchState);
                    break;
                }
                case DROP: {
                    ItemEntity torchItem = new ItemEntity(this.m_9236_(), (double)x, (double)y, (double)z, new ItemStack((ItemLike)ARROW_TYPE.get()));
                    this.m_9236_().m_7967_((Entity)torchItem);
                }
            }
        }
    }

    private static enum BlockResult {
        PLACE,
        BREAK,
        DROP;

    }
}

