/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.passive;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.entity.passive.BDBAnimalEntityAbstract;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class FrogEntity
extends BDBAnimalEntityAbstract {
    private static final float adultHealth = 8.0f;
    private static final float babyHealth = 4.0f;
    private static final int jumpStateID = 1;
    private static final int attackStateID = 4;
    private static final int soundStateID = 60;
    private static final double walkingSpeed = 0.6;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private int jumpTicks;
    private int jumpDuration;
    private int attackDuration;
    private int attackTicks;
    private int soundDuration;
    private int soundTicks;

    public FrogEntity(EntityType<? extends FrogEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21343_ = new JumpHelperController(this);
        this.f_21342_ = new MoveHelperController(this);
        this.setMovementSpeed(0.0);
    }

    public void setMovementSpeed(double newSpeed) {
        this.m_21573_().m_26517_(newSpeed);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), newSpeed);
    }

    public static AttributeSupplier.Builder createFrogAttributes() {
        return BDBAnimalEntityAbstract.m_21552_().m_22268_(Attributes.f_22276_, 8.0);
    }

    @Override
    protected void babyHealth() {
        if (this.m_6162_() && this.m_21133_(Attributes.f_22276_) != 4.0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
            this.m_21153_(4.0f);
        } else if (!this.m_6162_() && this.m_21133_(Attributes.f_22276_) != 8.0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
            this.m_21153_(8.0f);
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FrogPanicGoal(this, 0.85));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new FrogAttackGoal(this, 0.85));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Silverfish.class, true));
    }

    @Override
    protected void addTemptGoal(Level worldIn) {
        if (worldIn != null && !worldIn.m_5776_()) {
            this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, this.foodItems, false));
        }
    }

    @Override
    protected String getBreedingConfig() {
        return "frog_food";
    }

    @Override
    protected FrogEntity createChild(ServerLevel serverWorld) {
        return (FrogEntity)((EntityType)BDBEntityTypes.FROG.get()).m_20615_((Level)serverWorld);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.5f : sizeIn.f_20378_ * 0.85f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    public boolean canEatGroundBlock() {
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
        if (this.attackTicks != this.attackDuration) {
            ++this.attackTicks;
        } else if (this.attackDuration != 0) {
            this.attackTicks = 0;
            this.attackDuration = 0;
        }
        if (this.soundTicks != this.soundDuration) {
            ++this.soundTicks;
        } else if (this.soundDuration != 0) {
            this.soundTicks = 0;
            this.soundDuration = 0;
        }
    }

    public void m_8024_() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.m_20096_()) {
            JumpHelperController FrogEntity$jumphelpercontroller;
            LivingEntity livingentity;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (this.currentMoveTypeDuration == 0 && (livingentity = this.m_5448_()) != null && this.m_20280_((Entity)livingentity) < 16.0) {
                this.calculateRotationYaw(livingentity.m_20185_(), livingentity.m_20189_());
                this.f_21342_.m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), this.f_21342_.m_24999_());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (!(FrogEntity$jumphelpercontroller = (JumpHelperController)this.f_21343_).getIsJumping()) {
                if (this.f_21342_.m_24995_() && this.currentMoveTypeDuration == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vector3d = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vector3d = path.m_77380_((Entity)this);
                    }
                    this.calculateRotationYaw(vector3d.f_82479_, vector3d.f_82481_);
                    this.startJumping();
                }
            } else if (!FrogEntity$jumphelpercontroller.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    private void calculateRotationYaw(double x, double z) {
        this.m_146922_((float)(Mth.m_14136_((double)(z - this.m_20189_()), (double)(x - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void enableJumpControl() {
        ((JumpHelperController)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelperController)this.f_21343_).setCanJump(false);
    }

    protected void m_6135_() {
        double currentVelocity;
        super.m_6135_();
        double movementSpeed = this.f_21342_.m_24999_();
        if (movementSpeed > 0.0 && (currentVelocity = this.m_20184_().m_165925_()) < 0.01) {
            float horizontalSpeed = 0.1f;
            this.m_19920_(horizontalSpeed, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    protected float m_6118_() {
        float bigJump = 0.5f;
        if (!(this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5)) {
            Path path = this.f_21344_.m_26570_();
            if (path != null && !path.m_77392_()) {
                Vec3 vector3d = path.m_77380_((Entity)this);
                if (vector3d.f_82480_ > this.m_20186_() + 0.5) {
                    return bigJump;
                }
            }
            float defaultJump = 0.2f;
            float runningJump = 0.32f;
            return this.f_21342_.m_24999_() <= 0.6 ? defaultJump : runningJump;
        }
        return bigJump;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public boolean m_5843_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        }
        if (id == 4 && this.attackDuration == 0) {
            this.attackDuration = 5;
            this.attackTicks = 0;
        }
        if (id == 60) {
            this.soundDuration = 10;
            this.soundTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    @Override
    protected SoundEvent getAnimalEatingSound() {
        return super.getAnimalEatingSound();
    }

    @Override
    protected SoundEvent m_7515_() {
        this.setSoundState();
        return (SoundEvent)BDBSoundEvents.ENTITY_FROG_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        this.setSoundState();
        return (SoundEvent)BDBSoundEvents.ENTITY_FROG_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        this.setSoundState();
        return (SoundEvent)BDBSoundEvents.ENTITY_FROG_DEATH.get();
    }

    private void setSoundState() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpCompletion(float partialTick) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTick) / (float)this.jumpDuration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackCompletion(float partialTick) {
        return this.attackDuration == 0 ? 0.0f : ((float)this.attackTicks + partialTick) / (float)this.attackDuration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSoundCompletion(float partialTick) {
        return this.soundDuration == 0 ? 0.0f : ((float)this.soundTicks + partialTick) / (float)this.soundDuration;
    }

    public class JumpHelperController
    extends JumpControl {
        private final FrogEntity frog;
        private boolean canJump;

        public JumpHelperController(FrogEntity frog) {
            super((Mob)frog);
            this.frog = frog;
        }

        public boolean getIsJumping() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.frog.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final FrogEntity frog;
        private double nextJumpSpeed;

        public MoveHelperController(FrogEntity frog) {
            super((Mob)frog);
            this.frog = frog;
        }

        public void m_8126_() {
            if (this.frog.m_20096_() && !this.frog.f_20899_ && !((JumpHelperController)this.frog.f_21343_).getIsJumping()) {
                this.frog.setMovementSpeed(0.0);
            } else if (this.m_24995_()) {
                this.frog.setMovementSpeed(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speedIn) {
            if (this.frog.m_20069_()) {
                speedIn = 1.5;
            }
            super.m_6849_(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    static class FrogPanicGoal
    extends PanicGoal {
        private final FrogEntity frog;

        public FrogPanicGoal(FrogEntity frog, double speedIn) {
            super((PathfinderMob)frog, speedIn);
            this.frog = frog;
        }

        public void m_8037_() {
            super.m_8037_();
            this.frog.setMovementSpeed(this.f_25685_);
        }
    }

    static class FrogAttackGoal
    extends MeleeAttackGoal {
        public FrogAttackGoal(FrogEntity frog, double speedIn) {
            super((PathfinderMob)frog, speedIn, true);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 2.0f + attackTarget.m_20205_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0 && !this.f_25540_.m_9236_().m_5776_()) {
                this.f_25540_.m_9236_().m_7605_((Entity)this.f_25540_, (byte)4);
            }
            super.m_6739_(enemy, distToEnemySqr);
        }
    }
}

