/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.passive;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfigRegistry;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingItem;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.item.BDBItems;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class DuckEntity
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DUCK_TEXTURES = 7;
    protected Ingredient foodItems = Ingredient.m_43921_(BreedingConfigRegistry.getTemptationItemStacks(this.getBreedingConfig()).stream());
    protected Ingredient breedingItems = Ingredient.m_43921_(BreedingConfigRegistry.getBreedingItemStacks(this.getBreedingConfig()).stream());
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
    public boolean duckJockey;

    public DuckEntity(EntityType<? extends DuckEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.addTemptGoal(worldIn, 3, 1.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("IsDuckJockey", this.duckJockey);
        compound.m_128405_("EggLayTime", this.timeUntilNextEgg);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.duckJockey = compound.m_128471_("IsDuckJockey");
        if (compound.m_128441_("EggLayTime")) {
            this.timeUntilNextEgg = compound.m_128451_("EggLayTime");
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID)), (int)0, (int)7);
    }

    public void setVariant(int variantIn) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variantIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    protected void addTemptGoal(Level worldIn, int goalSelectorNumber, double speedIn) {
        if (worldIn != null && !worldIn.m_5776_()) {
            this.f_21345_.m_25352_(goalSelectorNumber, (Goal)new TemptGoal((PathfinderMob)this, speedIn, this.foodItems, false));
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.78f : sizeIn.f_20378_ * 1.22f;
    }

    public static AttributeSupplier.Builder createDuckAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int duckVariant;
        if (spawnDataIn instanceof DuckData) {
            duckVariant = ((DuckData)((Object)spawnDataIn)).variant;
        } else {
            duckVariant = this.f_19796_.m_188503_(7);
            spawnDataIn = new DuckData(duckVariant);
        }
        this.setVariant(duckVariant);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6898_(ItemStack stack) {
        return this.breedingItems.test(stack);
    }

    protected String getBreedingConfig() {
        return "duck_food";
    }

    public DuckEntity getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        DuckEntity duckEntity = this.createChild();
        DuckEntity duckEntity1 = (DuckEntity)ageableEntity;
        duckEntity.setVariant(this.f_19796_.m_188499_() ? this.getVariant() : duckEntity1.getVariant());
        return duckEntity;
    }

    private DuckEntity createChild() {
        return (DuckEntity)((EntityType)BDBEntityTypes.DUCK.get()).m_20615_(this.m_9236_());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41619_()) {
            return this.playerInteractEating(player, itemstack);
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult playerInteractEating(Player player, ItemStack itemStackInHand) {
        boolean flag = this.handleEating(player, itemStackInHand);
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean handleEating(Player player, ItemStack itemStackInHand) {
        boolean eat = false;
        BreedingConfig breedingConfig = BreedingConfigRegistry.BREEDING_CONFIGS.get(this.getBreedingConfig());
        for (BreedingItem breedingItem : breedingConfig.getBreedingItems()) {
            Item itemInHand = itemStackInHand.m_41720_();
            List<Item> itemList = BreedingConfigRegistry.getItemList(breedingItem);
            for (Item item : itemList) {
                if (itemInHand != item) continue;
                boolean isBreedingItem = breedingItem.getBreeding();
                float healAmount = breedingItem.getHealAmount();
                int growthAmount = breedingItem.getGrowthAmount();
                if (!this.m_9236_().m_5776_() && this.m_146764_() == 0 && !this.m_27593_() && isBreedingItem) {
                    this.m_27595_(player);
                    eat = true;
                }
                if (this.m_21223_() < this.m_21233_() && healAmount > 0.0f) {
                    this.m_5634_(healAmount);
                    eat = true;
                }
                if (this.m_6162_() && growthAmount > 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    if (!this.m_9236_().m_5776_()) {
                        this.m_146758_(growthAmount);
                    }
                    eat = true;
                }
                if (!eat || player.m_150110_().f_35937_) continue;
                itemStackInHand.m_41774_(1);
            }
        }
        return eat;
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction move) {
        super.m_19956_(entity, move);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        move.m_20372_(entity, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + entity.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20883_ = this.f_20883_;
        }
    }

    public int m_213860_() {
        return this.isDuckJockey() ? 10 : super.m_213860_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.isDuckJockey();
    }

    public boolean isDuckJockey() {
        return this.duckJockey;
    }

    public void setDuckJockey(boolean jockey) {
        this.duckJockey = jockey;
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.m_20096_() || this.m_20069_() && !this.f_19800_ ? -1 : 4) * 0.3);
        this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && !this.m_20069_() && this.f_19800_ && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && !this.m_20069_() && this.f_19800_ && vector3d.f_82480_ < 0.0) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!this.m_9236_().m_5776_() && this.m_6084_() && !this.m_6162_() && !this.isDuckJockey() && --this.timeUntilNextEgg <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)BDBItems.DUCK_EGG.get());
            this.timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)BDBSoundEvents.ENTITY_DUCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        SoundEvent soundEvent = (SoundEvent)BDBSoundEvents.ENTITY_DUCK_HURT.get();
        if (this.m_6162_()) {
            soundEvent = (SoundEvent)BDBSoundEvents.ENTITY_DUCK_HURT_BABY.get();
        }
        return soundEvent;
    }

    protected SoundEvent m_5592_() {
        SoundEvent soundEvent = (SoundEvent)BDBSoundEvents.ENTITY_DUCK_DEATH.get();
        if (this.m_6162_()) {
            soundEvent = (SoundEvent)BDBSoundEvents.ENTITY_DUCK_DEATH_BABY.get();
        }
        return soundEvent;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12400_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.04f, 2.0f);
    }

    static class DuckData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        private DuckData(int variantIn) {
            super(true);
            this.variant = variantIn;
        }
    }
}

