/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.passive;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfigRegistry;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingItem;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.entity.ai.goal.CamelFollowCaravanGoal;

public class CamelEntity
extends Llama {
    protected Ingredient foodItems = Ingredient.m_43921_(BreedingConfigRegistry.getTemptationItemStacks(this.getBreedingConfig()).stream());
    private static final EntityDataAccessor<Integer> DATA_CAMEL_STRENGTH_ID = SynchedEntityData.m_135353_(CamelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int waterCooldown;
    private boolean hasEaten;

    public CamelEntity(EntityType<? extends CamelEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    private void setCamelStrength(int strengthIn) {
        this.f_19804_.m_135381_(DATA_CAMEL_STRENGTH_ID, (Object)Math.max(1, Math.min(5, strengthIn)));
    }

    private void setRandomCamelStrength() {
        int i = this.f_19796_.m_188501_() < 0.2f ? 4 : 2;
        this.setCamelStrength(2 + this.f_19796_.m_188503_(i));
    }

    private int getCamelStrength() {
        return (Integer)this.f_19804_.m_135370_(DATA_CAMEL_STRENGTH_ID);
    }

    protected int m_7506_() {
        return this.m_30502_() ? 2 + 3 * this.m_7488_() : super.m_7506_();
    }

    public int m_7488_() {
        return this.getCamelStrength();
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_6741_() {
        return true;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("CamelStrength", this.getCamelStrength());
        compound.m_128405_("WaterCooldown", this.waterCooldown);
        compound.m_128379_("HasEaten", this.hasEaten);
    }

    public void m_7378_(CompoundTag compound) {
        this.setCamelStrength(compound.m_128451_("CamelStrength"));
        super.m_7378_(compound);
        this.waterCooldown = compound.m_128451_("WaterCooldown");
        this.hasEaten = compound.m_128471_("HasEaten");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CAMEL_STRENGTH_ID, (Object)0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setRandomCamelStrength();
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canCamelSpawn(EntityType<CamelEntity> camel, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState blockstate = world.m_8055_(pos.m_7495_());
        return (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_49992_)) && world.m_45524_(pos, 0) > 8;
    }

    public int m_5792_() {
        return 4;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new CamelFollowCaravanGoal(this, 2.1f));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.m_7509_();
    }

    protected void m_7509_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.72 * (double)this.m_20192_(), (double)this.m_20205_() * 0.4);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.55;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction move) {
        if (this.m_20363_(passenger)) {
            float zOffset = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float xOffset = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            move.m_20372_(passenger, this.m_20185_() + (double)(0.3f * xOffset), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_() - (double)(0.16f * zOffset));
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).f_20883_ = this.f_20883_;
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.waterCooldown > 0) {
            --this.waterCooldown;
        }
        if (this.m_30617_()) {
            this.setHasEaten(true);
        }
    }

    private void setWaterCooldown(int ticks) {
        this.waterCooldown = ticks;
    }

    private boolean canWater() {
        return this.waterCooldown <= 0;
    }

    private void setHasEaten(boolean bool) {
        this.hasEaten = bool;
    }

    private boolean getHasEaten() {
        return this.hasEaten;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.m_30614_() && !this.m_6162_() && item == Items.f_42446_ && this.canWater()) {
            BetterDefaultBiomes.LOGGER.info("water!!!");
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack waterBucket = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42447_.m_7968_());
            player.m_21008_(hand, waterBucket);
            this.setWaterCooldown(6000);
            this.setHasEaten(false);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    protected String getBreedingConfig() {
        return "camel_food";
    }

    public InteractionResult m_30580_(Player player, ItemStack itemInHand) {
        boolean isEating = this.m_5994_(player, itemInHand);
        if (!player.m_150110_().f_35937_) {
            itemInHand.m_41774_(1);
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        return isEating ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return this.foodItems.test(stack);
    }

    protected boolean m_5994_(Player player, ItemStack itemStackInHand) {
        boolean eat = false;
        BreedingConfig breedingConfig = BreedingConfigRegistry.BREEDING_CONFIGS.get(this.getBreedingConfig());
        for (BreedingItem breedingItem : breedingConfig.getBreedingItems()) {
            Item itemInHand = itemStackInHand.m_41720_();
            List<Item> itemList = BreedingConfigRegistry.getItemList(breedingItem);
            for (Item item : itemList) {
                SoundEvent soundevent;
                if (itemInHand != item) continue;
                boolean isBreedingItem = breedingItem.getBreeding();
                float healAmount = breedingItem.getHealAmount();
                int growthAmount = breedingItem.getGrowthAmount();
                int decreaseTemperAmount = (int)Math.ceil(growthAmount / 20);
                if (!this.m_9236_().m_5776_() && this.m_146764_() == 0 && this.m_30614_() && !this.m_27593_() && isBreedingItem) {
                    this.m_27595_(player);
                    eat = true;
                }
                if (this.m_21223_() < this.m_21233_() && healAmount > 0.0f) {
                    this.m_5634_(healAmount);
                    eat = true;
                }
                if (this.m_6162_() && growthAmount > 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    if (!this.m_9236_().m_5776_()) {
                        this.m_146758_(growthAmount);
                    }
                    eat = true;
                }
                if (decreaseTemperAmount > 0 && !this.m_30614_() && this.m_30624_() < this.m_7555_()) {
                    eat = true;
                    if (!this.m_9236_().m_5776_()) {
                        this.m_30653_(decreaseTemperAmount);
                    }
                }
                if (!eat) continue;
                this.m_146850_(GameEvent.f_157806_);
                if (this.m_20067_() || (soundevent = this.m_7872_()) == null) continue;
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return eat;
    }

    public boolean m_7848_(Animal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof CamelEntity && this.m_30628_() && ((CamelEntity)otherAnimal).m_30628_();
    }

    public CamelEntity getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        CamelEntity camelEntity = this.makeBaby();
        this.m_149508_(ageableEntity, (AbstractHorse)camelEntity);
        CamelEntity camelEntity1 = (CamelEntity)ageableEntity;
        int i = this.f_19796_.m_188503_(Math.max(this.getCamelStrength(), camelEntity1.getCamelStrength())) + 1;
        if (this.f_19796_.m_188501_() < 0.03f) {
            ++i;
        }
        camelEntity.setCamelStrength(i);
        camelEntity.m_28464_(this.f_19796_.m_188499_() ? this.m_28554_() : camelEntity1.m_28554_());
        return camelEntity;
    }

    protected CamelEntity makeBaby() {
        return (CamelEntity)((EntityType)BDBEntityTypes.CAMEL.get()).m_20615_(this.m_9236_());
    }
}

