/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.passive;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfigRegistry;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingItem;

public abstract class BDBAnimalEntityAbstract
extends Animal {
    private static final Predicate<LivingEntity> PARENT_SELECTOR = livingEntity -> livingEntity instanceof BDBAnimalEntityAbstract && ((BDBAnimalEntityAbstract)((Object)livingEntity)).isParent();
    private static final TargetingConditions PARENT_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26888_(PARENT_SELECTOR);
    private static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.m_135353_(BDBAnimalEntityAbstract.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
    protected Ingredient foodItems = Ingredient.m_43921_(BreedingConfigRegistry.getTemptationItemStacks(this.getBreedingConfig()).stream());
    protected Ingredient breedingItems = Ingredient.m_43921_(BreedingConfigRegistry.getBreedingItemStacks(this.getBreedingConfig()).stream());
    private static final int DATA_FLAG_PARENT = 8;
    private int eatingCounter;
    private int openMouthCounter;
    private float headLean;
    private float prevHeadLean;
    private float mouthOpenness;
    private float prevMouthOpenness;
    private float prevHealth = this.m_21223_();
    public int tailCounter;

    public BDBAnimalEntityAbstract(EntityType<? extends BDBAnimalEntityAbstract> type, Level worldIn) {
        super(type, worldIn);
        this.addTemptGoal(worldIn);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsEating", this.isEatingGroundBlock());
        compound.m_128379_("IsParent", this.isParent());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEatingGroundBlock(compound.m_128471_("IsEating"));
        this.setParent(compound.m_128471_("IsParent"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS, (Object)0);
    }

    protected boolean getAnimalWatchableBoolean(int statusInt) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS) & statusInt) != 0;
    }

    protected void setAnimalWatchableBoolean(int flag, boolean bool) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS);
        if (bool) {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(b0 | flag)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)(b0 & ~flag)));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int m_5792_() {
        return 6;
    }

    public static AttributeSupplier.Builder createBDBAnimalAttributes() {
        return BDBAnimalEntityAbstract.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void babyHealth() {
        if (this.m_6162_() && this.m_21133_(Attributes.f_22276_) != 10.0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            this.m_21153_(10.0f);
        } else if (!this.m_6162_() && this.m_21133_(Attributes.f_22276_) < 20.0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void addTemptGoal(Level worldIn) {
        if (worldIn != null && !worldIn.m_5776_()) {
            this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.foodItems, false));
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return this.breedingItems.test(stack);
    }

    protected abstract String getBreedingConfig();

    public boolean isParent() {
        return this.getAnimalWatchableBoolean(8);
    }

    public void setParent(boolean parent) {
        this.setAnimalWatchableBoolean(8, parent);
    }

    public boolean m_7848_(Animal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof BDBAnimalEntityAbstract && this.canParent() && ((BDBAnimalEntityAbstract)otherAnimal).canParent();
    }

    protected boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Nullable
    public BDBAnimalEntityAbstract getBreedOffspring(ServerLevel serverWorld, AgeableMob otherParent) {
        if (!this.isParent()) {
            this.setParent(true);
        }
        if (otherParent instanceof BDBAnimalEntityAbstract && !((BDBAnimalEntityAbstract)otherParent).isParent()) {
            ((BDBAnimalEntityAbstract)otherParent).setParent(true);
        }
        BDBAnimalEntityAbstract babyEntity = this.createChild(serverWorld);
        return babyEntity;
    }

    protected BDBAnimalEntityAbstract createChild(ServerLevel serverWorld) {
        return null;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isEatingGroundBlock();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier, damageSource);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? sizeIn.f_20378_ * 0.7f : sizeIn.f_20378_ * 0.95f;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    protected void followParent() {
        LivingEntity livingentity;
        if (this.isParent() && this.m_6162_() && !this.isEatingGroundBlock() && (livingentity = this.m_9236_().m_45963_(BDBAnimalEntityAbstract.class, PARENT_TARGETING, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(16.0))) != null && this.m_20280_((Entity)livingentity) > 4.0) {
            this.f_21344_.m_6570_((Entity)livingentity, 0);
        }
    }

    public void m_8107_() {
        if (this.f_19796_.m_188503_(200) == 0) {
            this.moveTail();
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            this.babyHealth();
            if (this.f_19796_.m_188503_(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.canEatGroundBlock() && !this.isEatingGroundBlock() && this.f_19796_.m_188503_(100) == 0 && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_)) {
                this.setEatingGroundBlock(true);
            }
            if (this.isEatingGroundBlock() && ++this.eatingCounter > 50) {
                this.eatingCounter = 0;
                this.setEatingGroundBlock(false);
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_5634_(1.0f);
                }
            }
            this.followParent();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() > this.prevHealth && this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
        this.prevHealth = this.m_21223_();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.closeAnimalMouth();
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingGroundBlock()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getAnimalWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_41619_()) {
            return this.playerInteractEating(player, itemstack);
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult playerInteractEating(Player player, ItemStack itemStackInHand) {
        boolean flag = this.handleEating(player, itemStackInHand);
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean handleEating(Player player, ItemStack itemStackInHand) {
        boolean eat = false;
        BreedingConfig breedingConfig = BreedingConfigRegistry.BREEDING_CONFIGS.get(this.getBreedingConfig());
        for (BreedingItem breedingItem : breedingConfig.getBreedingItems()) {
            Item itemInHand = itemStackInHand.m_41720_();
            List<Item> itemList = BreedingConfigRegistry.getItemList(breedingItem);
            for (Item item : itemList) {
                if (itemInHand != item) continue;
                boolean isBreedingItem = breedingItem.getBreeding();
                float healAmount = breedingItem.getHealAmount();
                int growthAmount = breedingItem.getGrowthAmount();
                if (!this.m_9236_().m_5776_() && this.m_146764_() == 0 && !this.m_27593_() && isBreedingItem) {
                    this.m_27595_(player);
                    eat = true;
                }
                if (this.m_21223_() < this.m_21233_() && healAmount > 0.0f) {
                    this.m_5634_(healAmount);
                    eat = true;
                }
                if (this.m_6162_() && growthAmount > 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                    if (!this.m_9236_().m_5776_()) {
                        this.m_146758_(growthAmount);
                    }
                    eat = true;
                }
                if (!eat) continue;
                this.eatingAnimal();
                if (player.m_150110_().f_35937_) continue;
                itemStackInHand.m_41774_(1);
            }
        }
        return eat;
    }

    private void eatingAnimal() {
        SoundEvent soundevent;
        this.openAnimalMouth();
        if (!this.m_20067_() && (soundevent = this.getAnimalEatingSound()) != null) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
    }

    private void openAnimalMouth() {
        if (!this.m_9236_().m_5776_()) {
            this.openMouthCounter = 1;
            this.setAnimalWatchableBoolean(64, true);
        }
    }

    private void closeAnimalMouth() {
        this.setAnimalWatchableBoolean(64, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEatingAmount(float input) {
        return Mth.m_14179_((float)input, (float)this.prevHeadLean, (float)this.headLean);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMouthOpennessAngle(float input) {
        return Mth.m_14179_((float)input, (float)this.prevMouthOpenness, (float)this.mouthOpenness);
    }

    private boolean isTempted() {
        Player player = this.m_9236_().m_45946_(PLAYER_PREDICATE, (LivingEntity)this);
        if (player == null) {
            return false;
        }
        return this.foodItems.test(player.m_21205_()) || this.foodItems.test(player.m_21206_());
    }

    public boolean canEatGroundBlock() {
        return !this.m_21523_() && !this.isTempted();
    }

    public void setEatingGroundBlock(boolean bool) {
        this.setAnimalWatchableBoolean(16, bool);
    }

    public boolean isEatingGroundBlock() {
        return this.getAnimalWatchableBoolean(16);
    }

    protected void m_7880_(float distance) {
        if (distance > 6.0f && this.isEatingGroundBlock()) {
            this.setEatingGroundBlock(false);
        }
        super.m_7880_(distance);
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public float m_6100_() {
        return super.m_6100_();
    }

    public int m_8100_() {
        return 400;
    }

    @Nullable
    protected SoundEvent getAnimalEatingSound() {
        return SoundEvents.f_11912_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return super.m_7975_(damageSourceIn);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
    }
}

