/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.hostile.hunter;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import xratedjunior.betterdefaultbiomes.configuration.entity.HunterConfig;
import xratedjunior.betterdefaultbiomes.entity.ai.attribute.BDBCreatureAttribute;
import xratedjunior.betterdefaultbiomes.entity.hostile.AbstractHostileHumanoid;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.HunterArrowEntity;

public class HunterEntity
extends AbstractHostileHumanoid {
    public HunterEntity(EntityType<? extends HunterEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, DesertBanditEntity.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, true));
    }

    @Override
    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        return HunterArrowEntity.shootHunterArrow((LivingEntity)this, arrowStack, distanceFactor);
    }

    public static AttributeSupplier.Builder createHunterAttributes() {
        return HunterEntity.createHumanoidAttributes();
    }

    @Override
    public MobType m_6336_() {
        return BDBCreatureAttribute.HUNTER;
    }

    public static boolean checkHunterSpawnRules(EntityType<? extends HunterEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return AbstractHostileHumanoid.checkHostileSpawnRules(type, worldIn, reason, pos, randomIn) && pos.m_123342_() > worldIn.m_5736_() && worldIn.m_45517_(LightLayer.SKY, pos) < 12 && worldIn.m_45517_(LightLayer.SKY, pos) > 4 && worldIn.m_45517_(LightLayer.BLOCK, pos) <= 0;
    }

    @Override
    protected void setDefaultEquipmentAndEnchants(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_21409_(EquipmentSlot.MAINHAND, (float)((Integer)HunterConfig.hunter_bow_drop_chance.get()).intValue() / 100.0f);
        this.applyDefaultEnchantments();
    }

    private void applyDefaultEnchantments() {
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41793_()) {
            this.m_6844_(EquipmentSlot.MAINHAND).m_41663_(Enchantments.f_44988_, 1);
            this.m_6844_(EquipmentSlot.MAINHAND).m_41663_(Enchantments.f_44989_, 1);
            this.m_6844_(EquipmentSlot.MAINHAND).m_41714_((Component)Component.m_237115_((String)"equipment.betterdefaultbiomes.hunter_bow").m_130940_(ChatFormatting.GREEN));
        }
    }
}

