/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.hostile;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.ai.goal.StealthGoal;

public class JungleCreeperEntity
extends Creeper {
    private static final EntityDataAccessor<Boolean> STEALTH = SynchedEntityData.m_135353_(JungleCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int stealthCooldown;
    private int oldFuseCount;
    private int fuseTickCount;
    private int maxFuseTickCount = 12;
    private int explosionRadius = 3;

    public JungleCreeperEntity(EntityType<? extends JungleCreeperEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STEALTH, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Fuse", (short)this.maxFuseTickCount);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compound.m_128379_("ignited", this.m_32311_());
        compound.m_128379_("stealth", this.isStealth());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Fuse", 99)) {
            this.maxFuseTickCount = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128445_("ExplosionRadius");
        }
        if (compound.m_128471_("ignited")) {
            this.m_32312_();
        }
        if (compound.m_128425_("stealth", 1)) {
            this.setStealth(compound.m_128471_("stealth"));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal((Creeper)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new StealthGoal(this, 28.0f));
    }

    public static AttributeSupplier.Builder createJungleCreeperAttributes() {
        return JungleCreeperEntity.m_33035_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.m_142535_(distance, damageMultiplier, damageSource);
        this.fuseTickCount = (int)((float)this.fuseTickCount + distance * 1.5f);
        if (this.fuseTickCount > this.maxFuseTickCount - 5) {
            this.fuseTickCount = this.maxFuseTickCount - 5;
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setStealth(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean checkJungleCreeperSpawnRules(EntityType<? extends JungleCreeperEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return Monster.m_219019_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn) && pos.m_123342_() > worldIn.m_5736_() && worldIn.m_45517_(LightLayer.SKY, pos) < 12 && worldIn.m_45517_(LightLayer.SKY, pos) > 4 && worldIn.m_45517_(LightLayer.BLOCK, pos) <= 0;
    }

    public boolean isStealth() {
        return (Boolean)this.f_19804_.m_135370_(STEALTH);
    }

    public boolean canStealth() {
        return this.stealthCooldown <= 0 && !this.isStealth();
    }

    public void setStealth(boolean flag) {
        this.f_19804_.m_135381_(STEALTH, (Object)flag);
        if (!flag) {
            this.stealthCooldown = 30;
        }
    }

    public float m_6113_() {
        return super.m_6113_() * (this.isStealth() ? 2.0f : 1.0f);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        super.m_6475_(damageSrc, damageAmount);
        this.setStealth(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderStealth(Player player) {
        return this.isStealth() && this.m_32310_() <= 0 && !player.m_7500_() || player.m_7500_() && this.m_20280_((Entity)player) >= 28.0;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.stealthCooldown > 0) {
            --this.stealthCooldown;
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldFuseCount = this.fuseTickCount;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((i = this.m_32310_()) > 0 && this.fuseTickCount == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.fuseTickCount += i;
            if (this.fuseTickCount < 0) {
                this.fuseTickCount = 0;
            }
            if (this.fuseTickCount >= this.maxFuseTickCount) {
                this.fuseTickCount = this.maxFuseTickCount;
                this.m_32315_();
            }
        }
        super.m_8119_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_32320_(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldFuseCount, (float)this.fuseTickCount) / ((float)this.maxFuseTickCount - 2.5f);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().m_5776_()) {
                this.m_32312_();
                itemstack.m_41622_(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void m_32315_() {
        if (!this.m_9236_().m_5776_()) {
            float radiusMultiplier = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * radiusMultiplier, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            this.m_32316_();
        }
    }

    private void m_32316_() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        }
    }
}

