/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.client.model.passive;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBAgeableModel;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBModelPart;
import xratedjunior.betterdefaultbiomes.entity.passive.BDBAnimalEntityAbstract;
import xratedjunior.betterdefaultbiomes.entity.passive.ZebraEntity;

@OnlyIn(value=Dist.CLIENT)
public class ZebraModel<E extends ZebraEntity>
extends BDBAgeableModel<E> {
    private final BDBModelPart body_rotation_point;
    private final BDBModelPart neck_rotation_point;
    private final BDBModelPart head_rotation_point;
    private final BDBModelPart mouth_bottom_rotation_point;
    private final BDBModelPart front_right_leg_rotation_point;
    private final BDBModelPart front_right_leg_knee_rotation_point;
    private final BDBModelPart front_left_leg_rotation_point;
    private final BDBModelPart front_left_leg_knee_rotation_point;
    private final BDBModelPart back_right_leg_rotation_point;
    private final BDBModelPart back_right_leg_knee_rotation_point;
    private final BDBModelPart back_left_leg_rotation_point;
    private final BDBModelPart back_left_leg_knee_rotation_point;
    private final BDBModelPart tail_rotation_point;
    private final BDBModelPart tail_bottom_rotation_point;

    public ZebraModel(ModelPart root) {
        this.body_rotation_point = this.createModelPart(this, root, "body_rotation_point");
        this.neck_rotation_point = this.createModelPart(this, this.body_rotation_point, "neck_rotation_point");
        this.head_rotation_point = this.createModelPart(this, this.neck_rotation_point, "head_rotation_point");
        this.mouth_bottom_rotation_point = this.createModelPart(this, this.head_rotation_point, "mouth_bottom_rotation_point");
        this.tail_rotation_point = this.createModelPart(this, this.body_rotation_point, "tail_rotation_point");
        this.tail_bottom_rotation_point = this.createModelPart(this, this.tail_rotation_point, "tail_bottom_rotation_point");
        this.front_right_leg_rotation_point = this.createModelPart(this, root, "front_right_leg_rotation_point");
        this.front_right_leg_knee_rotation_point = this.createModelPart(this, this.front_right_leg_rotation_point, "front_right_leg_knee_rotation_point");
        this.front_left_leg_rotation_point = this.createModelPart(this, root, "front_left_leg_rotation_point");
        this.front_left_leg_knee_rotation_point = this.createModelPart(this, this.front_left_leg_rotation_point, "front_left_leg_knee_rotation_point");
        this.back_right_leg_rotation_point = this.createModelPart(this, root, "back_right_leg_rotation_point");
        this.back_right_leg_knee_rotation_point = this.createModelPart(this, this.back_right_leg_rotation_point, "back_right_leg_knee_rotation_point");
        this.back_left_leg_rotation_point = this.createModelPart(this, root, "back_left_leg_rotation_point");
        this.back_left_leg_knee_rotation_point = this.createModelPart(this, this.back_left_leg_rotation_point, "back_left_leg_knee_rotation_point");
        this.setDefaultModelValues();
    }

    public static LayerDefinition createBodyLayer(float scaleIn) {
        float textureOverlapFix = 0.05f;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body_rotation_point = partdefinition.m_171599_("body_rotation_point", CubeListBuilder.m_171558_().m_171514_(1, 96).m_171488_(-5.0f, -5.0f, -11.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(textureOverlapFix + scaleIn)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition neck_rotation_point = body_rotation_point.m_171599_("neck_rotation_point", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171488_(-2.0f, -11.4837f, -2.6711f, 4.0f, 12.0f, 7.0f, new CubeDeformation(scaleIn)).m_171514_(44, 96).m_171488_(-1.0f, -17.4837f, 2.3289f, 2.0f, 17.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-7.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition head_rotation_point = neck_rotation_point.m_171599_("head_rotation_point", CubeListBuilder.m_171558_().m_171514_(16, 97).m_171488_(-2.5f, -9.0f, 3.99f, 2.0f, 3.0f, 1.0f, new CubeDeformation(scaleIn)).m_171514_(0, 97).m_171488_(0.5f, -9.0f, 3.99f, 2.0f, 3.0f, 1.0f, new CubeDeformation(scaleIn)).m_171514_(0, 82).m_171488_(-3.0f, -6.0f, -2.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(scaleIn)).m_171514_(26, 78).m_171488_(-2.0f, -6.0f, -7.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)-10.4837f, (float)-0.6711f));
        head_rotation_point.m_171599_("mouth_bottom_rotation_point", CubeListBuilder.m_171558_().m_171514_(27, 87).m_171488_(-1.5f, 0.075f, -5.25f, 3.0f, 2.0f, 5.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)-3.325f, (float)-1.25f));
        PartDefinition tail_rotation_point = body_rotation_point.m_171599_("tail_rotation_point", CubeListBuilder.m_171558_().m_171514_(81, 106).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(scaleIn)), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)11.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        tail_rotation_point.m_171599_("tail_bottom_rotation_point", CubeListBuilder.m_171558_().m_171514_(78, 113).m_171488_(-1.5f, -0.4459f, -1.7559f, 3.0f, 11.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171423_((float)0.0f, (float)2.7926f, (float)-0.3359f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition front_right_leg_rotation_point = partdefinition.m_171599_("front_right_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(112, 98).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)-3.5f, (float)11.0f, (float)-9.5f));
        front_right_leg_rotation_point.m_171599_("front_right_leg_knee_rotation_point", CubeListBuilder.m_171558_().m_171514_(114, 111).m_171488_(-1.5f, -0.5f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(scaleIn)).m_171514_(112, 121).m_171488_(-2.0f, 5.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)0.0f));
        PartDefinition front_left_leg_rotation_point = partdefinition.m_171599_("front_left_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(95, 98).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)3.5f, (float)11.0f, (float)-9.5f));
        front_left_leg_rotation_point.m_171599_("front_left_leg_knee_rotation_point", CubeListBuilder.m_171558_().m_171514_(97, 111).m_171488_(-1.5f, -0.5f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(scaleIn)).m_171514_(95, 121).m_171488_(-2.0f, 5.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)0.0f));
        PartDefinition back_right_leg_rotation_point = partdefinition.m_171599_("back_right_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(112, 66).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)-3.5f, (float)11.0f, (float)9.5f));
        back_right_leg_rotation_point.m_171599_("back_right_leg_knee_rotation_point", CubeListBuilder.m_171558_().m_171514_(114, 79).m_171488_(-1.5f, -0.5f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(scaleIn)).m_171514_(112, 89).m_171488_(-2.0f, 5.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)0.0f));
        PartDefinition back_left_leg_rotation_point = partdefinition.m_171599_("back_left_leg_rotation_point", CubeListBuilder.m_171558_().m_171514_(95, 66).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)3.5f, (float)11.0f, (float)9.5f));
        back_left_leg_rotation_point.m_171599_("back_left_leg_knee_rotation_point", CubeListBuilder.m_171558_().m_171514_(97, 79).m_171488_(-1.5f, -0.5f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(scaleIn)).m_171514_(95, 89).m_171488_(-2.0f, 5.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(scaleIn)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            this.body_rotation_point.getModelPart().m_104301_(matrixStack, buffer, packedLight, packedOverlay);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStack.m_85837_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.back_right_leg_rotation_point, (Object)this.back_left_leg_rotation_point, (Object)this.front_right_leg_rotation_point, (Object)this.front_left_leg_rotation_point).forEach(modelParts -> modelParts.getModelPart().m_104301_(matrixStack, buffer, packedLight, packedOverlay));
            matrixStack.m_85849_();
        } else {
            ImmutableList.of((Object)this.body_rotation_point, (Object)this.front_right_leg_rotation_point, (Object)this.front_left_leg_rotation_point, (Object)this.back_right_leg_rotation_point, (Object)this.back_left_leg_rotation_point).forEach(modelPart -> modelPart.getModelPart().m_104301_(matrixStack, buffer, packedLight, packedOverlay));
        }
    }

    public void prepareMobModel(E entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        this.revertToDefaultModelValues();
        float ticks = (float)((ZebraEntity)((Object)entity)).f_19797_ + partialTick;
        float yawOffset = this.rotlerp(((ZebraEntity)((Object)entity)).f_20884_, ((ZebraEntity)((Object)entity)).f_20883_, partialTick);
        float yawRotation = this.rotlerp(((ZebraEntity)((Object)entity)).f_20886_, ((ZebraEntity)((Object)entity)).f_20885_, partialTick);
        float netHeadYaw = yawRotation - yawOffset;
        float headPitch = Mth.m_14179_((float)partialTick, (float)((ZebraEntity)((Object)entity)).f_19860_, (float)entity.m_146909_());
        float headPitchDegrees = headPitch * ((float)Math.PI / 180);
        if (limbSwingAmount > 0.2f) {
            headPitchDegrees += Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        this.neck_rotation_point.getModelPart().f_104204_ = netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        this.neck_rotation_point.getModelPart().f_104203_ = this.neck_rotation_point.defaultRotateAngleX + headPitchDegrees * ((float)Math.PI / 180);
        this.head_rotation_point.getModelPart().f_104204_ = netHeadYaw * ((float)Math.PI / 180) / 8.0f;
        this.head_rotation_point.getModelPart().f_104205_ = netHeadYaw * ((float)Math.PI / 180) / 8.0f;
        if (this.isWalking(entity)) {
            this.walkingAnimation(entity, limbSwing, limbSwingAmount, partialTick, netHeadYaw, headPitchDegrees);
        } else {
            boolean swingTail;
            limbSwing = ((ZebraEntity)((Object)entity)).f_19797_;
            limbSwingAmount = 1.0f;
            float globalSpeed = 0.1f;
            float globalDegree = 0.4f;
            float globalHeight = 1.0f;
            this.bounce(this.body_rotation_point, 0.75f * globalSpeed, 0.2f * globalHeight, 0.0f, limbSwing, limbSwingAmount);
            this.rotateXPositive(this.tail_rotation_point, globalSpeed * 0.25f, 0.2f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
            this.rotateZ(this.tail_rotation_point, globalSpeed, 0.2f * globalDegree, true, 0.5f, limbSwing, limbSwingAmount);
            this.rotateX(this.neck_rotation_point, globalSpeed, 0.1f * globalDegree, false, 0.0f, limbSwing, limbSwingAmount);
            this.rotateXPositive(this.mouth_bottom_rotation_point, globalSpeed * 0.25f, 0.8f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
            float startEating = ((BDBAnimalEntityAbstract)((Object)entity)).getEatingAmount(partialTick);
            if (startEating > 0.0f) {
                float isEating = ((BDBAnimalEntityAbstract)((Object)entity)).getMouthOpennessAngle(partialTick);
                float grassEatingAngle = 2.1f;
                float setDefaultRotation = (1.0f - startEating) * (this.neck_rotation_point.defaultRotateAngleX + headPitchDegrees + isEating * this.doNeckWobble(ticks));
                this.neck_rotation_point.getModelPart().f_104203_ = startEating * (grassEatingAngle + this.doNeckWobble(ticks)) + setDefaultRotation;
                if (startEating == 1.0f) {
                    this.rotateXPositive(this.mouth_bottom_rotation_point, 5.0f * globalSpeed, 0.5f * globalDegree, false, 0.0f, limbSwing, limbSwingAmount);
                }
            }
            boolean bl = swingTail = ((ZebraEntity)((Object)entity)).tailCounter != 0;
            if (swingTail) {
                this.rotateXPositive(this.tail_rotation_point, 10.0f * globalSpeed, 0.2f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
                this.rotateZ(this.tail_rotation_point, 10.0f * globalSpeed, 0.8f * globalDegree, true, 0.5f, limbSwing, limbSwingAmount);
                this.rotateX(this.tail_bottom_rotation_point, 10.0f * globalSpeed, 0.2f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
                this.rotateZ(this.tail_bottom_rotation_point, 10.0f * globalSpeed, 0.8f * globalDegree, true, 0.5f, limbSwing, limbSwingAmount);
            }
        }
    }

    private float doNeckWobble(float ticks) {
        return Mth.m_14031_((float)ticks) * 0.05f;
    }

    public void walkingAnimation(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float globalSpeed = 0.8f;
        float globalDegree = 0.5f;
        float globalHeight = 1.0f;
        float halfSpeed = 0.5f;
        float pi = (float)Math.PI;
        this.bounce(this.body_rotation_point, globalSpeed, 1.0f * globalHeight, 0.0f, limbSwing, limbSwingAmount);
        this.rotateXPositive(this.tail_rotation_point, globalSpeed * 0.25f, 0.8f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
        this.rotateZ(this.tail_rotation_point, globalSpeed, 0.8f * globalDegree, true, 0.5f, limbSwing, limbSwingAmount);
        this.rotateX(this.neck_rotation_point, globalSpeed, 0.2f * globalDegree, false, 0.0f, limbSwing, limbSwingAmount);
        this.rotateXPositive(this.mouth_bottom_rotation_point, globalSpeed * 0.25f, 0.8f * globalDegree, false, 0.5f, limbSwing, limbSwingAmount);
        this.rotateX(this.front_left_leg_rotation_point, globalSpeed, 1.4f * globalDegree, false, 0.0f, limbSwing, limbSwingAmount);
        this.rotateX(this.back_right_leg_rotation_point, globalSpeed, 1.4f * globalDegree, false, -0.5f * pi, limbSwing, limbSwingAmount);
        this.rotateX(this.front_right_leg_rotation_point, globalSpeed, 1.4f * globalDegree, false, -1.0f * pi, limbSwing, limbSwingAmount);
        this.rotateX(this.back_left_leg_rotation_point, globalSpeed, 1.4f * globalDegree, false, -1.5f * pi, limbSwing, limbSwingAmount);
        float kneeRotation = 1.4f;
        this.rotateXPositive(this.front_left_leg_knee_rotation_point, globalSpeed * halfSpeed, kneeRotation * globalDegree, true, -0.1f * pi, limbSwing, limbSwingAmount);
        this.rotateXPositive(this.back_right_leg_knee_rotation_point, globalSpeed * halfSpeed, kneeRotation * globalDegree, true, -0.35f * pi, limbSwing, limbSwingAmount);
        this.rotateXPositive(this.front_right_leg_knee_rotation_point, globalSpeed * halfSpeed, kneeRotation * globalDegree, true, -0.6f * pi, limbSwing, limbSwingAmount);
        this.rotateXPositive(this.back_left_leg_knee_rotation_point, globalSpeed * halfSpeed, kneeRotation * globalDegree, true, -0.85f * pi, limbSwing, limbSwingAmount);
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return null;
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return null;
    }
}

