/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.client;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.entity.client.model.passive.CamelModel;
import xratedjunior.betterdefaultbiomes.entity.client.model.passive.FrogModel;
import xratedjunior.betterdefaultbiomes.entity.client.model.passive.ZebraModel;
import xratedjunior.betterdefaultbiomes.entity.client.model.util.BDBModelLayer;

@OnlyIn(value=Dist.CLIENT)
public class BDBModelLayers {
    private static final float DEFAULT_SCALE = 0.0f;
    public static final Set<BDBModelLayer> BDB_MODELS = Sets.newHashSet();
    public static final BDBModelLayer CAMEL = BDBModelLayers.registerMainModel("camel", () -> CamelModel.createBodyLayer(0.0f));
    public static final BDBModelLayer CAMEL_SADDLE = BDBModelLayers.registerModel("camel", "saddle", () -> CamelModel.createBodyLayer(0.2f));
    public static final BDBModelLayer CAMEL_DECOR = BDBModelLayers.registerModel("camel", "decor", () -> CamelModel.createBodyLayer(0.1f));
    public static final BDBModelLayer ZEBRA = BDBModelLayers.registerMainModel("zebra", () -> ZebraModel.createBodyLayer(0.0f));
    public static final BDBModelLayer FROG = BDBModelLayers.registerMainModel("frog", () -> FrogModel.createBodyLayer(0.0f));

    private static BDBModelLayer registerMainModel(String entityName, Supplier<LayerDefinition> supplier) {
        return BDBModelLayers.registerModel(entityName, "main", supplier);
    }

    private static BDBModelLayer registerModel(String entityName, String modelName, Supplier<LayerDefinition> modelSupplier) {
        ModelLayerLocation modelLayerLocation = new ModelLayerLocation(BetterDefaultBiomes.locate(entityName), modelName);
        BDBModelLayer modelLayer = new BDBModelLayer(modelLayerLocation, modelSupplier);
        if (!BDB_MODELS.add(modelLayer)) {
            throw new IllegalStateException("Duplicate registration for " + modelLayer);
        }
        return modelLayer;
    }
}

