/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity;

import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.entity.hostile.FrozenZombieEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.JungleCreeperEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.LostMinerEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditArbalistEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditArcherEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditMasterEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.hunter.HeadHunterEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.hunter.HunterEntity;
import xratedjunior.betterdefaultbiomes.entity.passive.CamelEntity;
import xratedjunior.betterdefaultbiomes.entity.passive.DuckEntity;
import xratedjunior.betterdefaultbiomes.entity.passive.FrogEntity;
import xratedjunior.betterdefaultbiomes.entity.passive.MuddyPigEntity;
import xratedjunior.betterdefaultbiomes.entity.passive.ZebraEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.BanditArrowEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.DuckEggEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.HunterArrowEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.SmallRockEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.TorchArrowEntity;
import xratedjunior.betterdefaultbiomes.item.BDBItems;

@Mod.EventBusSubscriber(modid="betterdefaultbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BDBEntityTypes {
    public static final DeferredRegister<EntityType<?>> DEFERRED_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"betterdefaultbiomes");
    public static final RegistryObject<EntityType<HunterEntity>> HUNTER = BDBEntityTypes.registerEntityType("hunter", 6919524, 6705977, EntityType.Builder.m_20704_(HunterEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<HeadHunterEntity>> HEAD_HUNTER = BDBEntityTypes.registerEntityType("head_hunter", 7043163, 4343088, EntityType.Builder.m_20704_(HeadHunterEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<JungleCreeperEntity>> JUNGLE_CREEPER = BDBEntityTypes.registerEntityType("jungle_creeper", 2648358, 0x1A1A1A, EntityType.Builder.m_20704_(JungleCreeperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).m_20702_(8));
    public static final RegistryObject<EntityType<LostMinerEntity>> LOST_MINER = BDBEntityTypes.registerEntityType("lost_miner", 0xD1D1D1, 0x5E5E5E, EntityType.Builder.m_20704_(LostMinerEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<FrozenZombieEntity>> FROZEN_ZOMBIE = BDBEntityTypes.registerEntityType("frozen_zombie", 4678509, 13488583, EntityType.Builder.m_20704_(FrozenZombieEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(8));
    public static final RegistryObject<EntityType<DesertBanditEntity>> DESERT_BANDIT = BDBEntityTypes.registerEntityType("desert_bandit", 15717250, 5717296, EntityType.Builder.m_20704_(DesertBanditEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<DesertBanditArcherEntity>> DESERT_BANDIT_ARCHER = BDBEntityTypes.registerEntityType("desert_bandit_archer", 15717250, 7555124, EntityType.Builder.m_20704_(DesertBanditArcherEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<DesertBanditArbalistEntity>> DESERT_BANDIT_ARBALIST = BDBEntityTypes.registerEntityType("desert_bandit_arbalist", 15717250, 7555124, EntityType.Builder.m_20704_(DesertBanditArbalistEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<DesertBanditMasterEntity>> DESERT_BANDIT_MASTER = BDBEntityTypes.registerEntityType("desert_bandit_master", 15717250, 1456474, EntityType.Builder.m_20704_(DesertBanditMasterEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final RegistryObject<EntityType<MuddyPigEntity>> MUDDY_PIG = BDBEntityTypes.registerEntityType("muddy_pig", 15771042, 5584685, EntityType.Builder.m_20704_(MuddyPigEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.9f).m_20702_(10));
    public static final RegistryObject<EntityType<CamelEntity>> CAMEL = BDBEntityTypes.registerEntityType("camel", 11572320, 8350533, EntityType.Builder.m_20704_(CamelEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.1f, 1.95f).m_20702_(10));
    public static final RegistryObject<EntityType<DuckEntity>> DUCK = BDBEntityTypes.registerEntityType("duck", 13747125, 26112, EntityType.Builder.m_20704_(DuckEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(10));
    public static final RegistryObject<EntityType<ZebraEntity>> ZEBRA = BDBEntityTypes.registerEntityType("zebra", 0xE6E6E6, 0x111111, EntityType.Builder.m_20704_(ZebraEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.4f, 1.5f).m_20702_(10));
    public static final RegistryObject<EntityType<FrogEntity>> FROG = BDBEntityTypes.registerEntityType("frog", 4693550, 13284987, EntityType.Builder.m_20704_(FrogEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.7f).m_20702_(10));
    public static final RegistryObject<EntityType<DuckEggEntity>> DUCK_EGG = BDBEntityTypes.registerEntityType("duck_egg", EntityType.Builder.m_20704_(DuckEggEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10));
    public static final RegistryObject<EntityType<SmallRockEntity>> SMALL_ROCK = BDBEntityTypes.registerEntityType("small_rock", EntityType.Builder.m_20704_(SmallRockEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10));
    public static final RegistryObject<EntityType<HunterArrowEntity>> HUNTER_ARROW = BDBEntityTypes.registerEntityType("hunter_arrow", EntityType.Builder.m_20704_(HunterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<EntityType<BanditArrowEntity>> BANDIT_ARROW = BDBEntityTypes.registerEntityType("bandit_arrow", EntityType.Builder.m_20704_(BanditArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<EntityType<TorchArrowEntity>> TORCH_ARROW = BDBEntityTypes.registerEntityType("torch_arrow", EntityType.Builder.m_20704_(TorchArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));

    @SubscribeEvent
    public static void registerEntitySpawnPlacement(SpawnPlacementRegisterEvent event) {
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)HUNTER.get(), HunterEntity::checkHunterSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)HEAD_HUNTER.get(), HunterEntity::checkHunterSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)JUNGLE_CREEPER.get(), JungleCreeperEntity::checkJungleCreeperSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)LOST_MINER.get(), LostMinerEntity::checkLostMinerSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)FROZEN_ZOMBIE.get(), Monster::m_219013_);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)DESERT_BANDIT.get(), DesertBanditEntity::checkBanditSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)DESERT_BANDIT_ARCHER.get(), DesertBanditEntity::checkBanditSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)DESERT_BANDIT_ARBALIST.get(), DesertBanditEntity::checkBanditSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)DESERT_BANDIT_MASTER.get(), DesertBanditEntity::checkBanditSpawnRules);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)MUDDY_PIG.get(), Animal::m_218104_);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)CAMEL.get(), CamelEntity::canCamelSpawn);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)DUCK.get(), Animal::m_218104_);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)ZEBRA.get(), Animal::m_218104_);
        BDBEntityTypes.registerSpawnPlacement(event, (EntityType)FROG.get(), Animal::m_218104_);
    }

    @SubscribeEvent
    public static void buildEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUNTER.get(), HeadHunterEntity.createHunterAttributes().m_22265_());
        event.put((EntityType)HEAD_HUNTER.get(), HeadHunterEntity.createHeadHunterAttributes().m_22265_());
        event.put((EntityType)JUNGLE_CREEPER.get(), JungleCreeperEntity.createJungleCreeperAttributes().m_22265_());
        event.put((EntityType)LOST_MINER.get(), AbstractSkeleton.m_32166_().m_22265_());
        event.put((EntityType)FROZEN_ZOMBIE.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)DESERT_BANDIT.get(), DesertBanditEntity.createDesertBanditAttributes().m_22265_());
        event.put((EntityType)DESERT_BANDIT_ARCHER.get(), DesertBanditEntity.createDesertBanditAttributes().m_22265_());
        event.put((EntityType)DESERT_BANDIT_ARBALIST.get(), DesertBanditArbalistEntity.createDesertArbalistAttributes().m_22265_());
        event.put((EntityType)DESERT_BANDIT_MASTER.get(), DesertBanditMasterEntity.createDesertMasterAttributes().m_22265_());
        event.put((EntityType)MUDDY_PIG.get(), Pig.m_29503_().m_22265_());
        event.put((EntityType)CAMEL.get(), Llama.m_30824_().m_22265_());
        event.put((EntityType)DUCK.get(), DuckEntity.createDuckAttributes().m_22265_());
        event.put((EntityType)ZEBRA.get(), ZebraEntity.createBDBAnimalAttributes().m_22265_());
        event.put((EntityType)FROG.get(), FrogEntity.createFrogAttributes().m_22265_());
    }

    private static <T extends Mob> RegistryObject<EntityType<T>> registerEntityType(String registryName, int eggBackgroundColor, int eggHighlightColor, EntityType.Builder<T> builder) {
        RegistryObject entityType = BDBEntityTypes.registerEntityType(registryName, builder);
        BDBItems.registerItem(registryName + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityType, eggBackgroundColor, eggHighlightColor, new Item.Properties()));
        return entityType;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String registryName, EntityType.Builder<T> builder) {
        return DEFERRED_ENTITY_TYPES.register(registryName, () -> builder.m_20712_(BetterDefaultBiomes.find(registryName)));
    }

    private static <T extends Mob> void registerSpawnPlacement(SpawnPlacementRegisterEvent event, EntityType<T> entityType, SpawnPlacements.SpawnPredicate<T> placementPredicate) {
        event.register(entityType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, placementPredicate, SpawnPlacementRegisterEvent.Operation.OR);
    }
}

