/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.enchantment;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.FloatingEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.GuardEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.HorseProtectionEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.HuntingEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.ScoutEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.SmeltingTouchEnchantment;
import xratedjunior.betterdefaultbiomes.enchantment.enchantment.SpikesEnchantment;

public class BDBEnchantments {
    public static final DeferredRegister<Enchantment> DEFERRED_ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"betterdefaultbiomes");
    public static Map<String, String> ENCHANTMENTS = Maps.newHashMap();
    public static final RegistryObject<Enchantment> SMELTING_TOUCH = BDBEnchantments.registerEnchantment("smelting_touch", "Smelt blocks when mining.", () -> new SmeltingTouchEnchantment());
    public static final RegistryObject<Enchantment> SCOUT = BDBEnchantments.registerEnchantment("scout", "Mobs in a small area around the Player get the Glowing effect.", () -> new ScoutEnchantment());
    public static final RegistryObject<Enchantment> HUNTING = BDBEnchantments.registerEnchantment("hunting", "Bows/Crossbows do more damage against animals.", () -> new HuntingEnchantment());
    public static final RegistryObject<Enchantment> HORSE_PROTECTION = BDBEnchantments.registerEnchantment("horse_protection", "Horse Protection Enchantments like the Vanilla Protection Enchantments for the Player.", () -> new HorseProtectionEnchantment(HorseProtectionEnchantment.Type.ALL, Enchantment.Rarity.COMMON));
    public static final RegistryObject<Enchantment> HORSE_FIRE_PROTECTION = BDBEnchantments.registerEnchantment("horse_fire_protection", BDBEnchantments.getComment("horse_protection"), () -> new HorseProtectionEnchantment(HorseProtectionEnchantment.Type.FIRE, Enchantment.Rarity.UNCOMMON));
    public static final RegistryObject<Enchantment> HORSE_FEATHER_FALLING = BDBEnchantments.registerEnchantment("horse_feather_falling", BDBEnchantments.getComment("horse_protection"), () -> new HorseProtectionEnchantment(HorseProtectionEnchantment.Type.FALL, Enchantment.Rarity.UNCOMMON));
    public static final RegistryObject<Enchantment> HORSE_BLAST_PROTECTION = BDBEnchantments.registerEnchantment("horse_blast_protection", BDBEnchantments.getComment("horse_protection"), () -> new HorseProtectionEnchantment(HorseProtectionEnchantment.Type.EXPLOSION, Enchantment.Rarity.RARE));
    public static final RegistryObject<Enchantment> HORSE_PROJECTILE_PROTECTION = BDBEnchantments.registerEnchantment("horse_projectile_protection", BDBEnchantments.getComment("horse_protection"), () -> new HorseProtectionEnchantment(HorseProtectionEnchantment.Type.PROJECTILE, Enchantment.Rarity.UNCOMMON));
    public static final RegistryObject<Enchantment> SPIKES = BDBEnchantments.registerEnchantment("spikes", "Thorns for Shields.", () -> new SpikesEnchantment());
    public static final RegistryObject<Enchantment> GUARD = BDBEnchantments.registerEnchantment("guard", "Knockback for Shields.", () -> new GuardEnchantment());
    public static final RegistryObject<Enchantment> FLOATING = BDBEnchantments.registerEnchantment("floating", "Horses float in water.", () -> new FloatingEnchantment());

    public static String getComment(String enchantmentName) {
        return ENCHANTMENTS.get(enchantmentName);
    }

    public static <E extends Enchantment> RegistryObject<E> registerEnchantment(@Nonnull String registryName, @Nonnull String comment, Supplier<E> enchantment) {
        ENCHANTMENTS.put(registryName, comment);
        return DEFERRED_ENCHANTMENTS.register(registryName, enchantment);
    }
}

