/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.configuration.extra;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;

public class BiomeTagInfoGenerator {
    private static final String BDB_CONFIG_FOLDER = BetterDefaultBiomes.BDBFolderPath.toString();
    private static final File EXTRA_INFO_FOLDER = new File(BDB_CONFIG_FOLDER, "Biome Tag Info");

    public static void makeInfoTextFiles(String worldName, Registry<Biome> biomeRegistry, List<TagKey<Biome>> tagList) {
        if (!EXTRA_INFO_FOLDER.exists()) {
            EXTRA_INFO_FOLDER.mkdirs();
        }
        BiomeTagInfoGenerator.textFileGenerator(worldName, biomeRegistry, tagList);
    }

    private static void textFileGenerator(String worldName, Registry<Biome> biomeRegistry, List<TagKey<Biome>> tagList) {
        ArrayList<Object> masterList = new ArrayList<Object>();
        masterList.add("This is a text file generated by Better Default Biomes.");
        masterList.add("The generation of this file can be turned on/off in the mod config.");
        masterList.add("A new file will be generated when opening a world.");
        masterList.add("This file was generated when opening: \"" + worldName + "\".");
        masterList.add("The purpose of this file is to help you customise mods.");
        masterList.add("");
        ArrayList<BiomeTagList> allBiomeTagLists = new ArrayList<BiomeTagList>();
        for (TagKey<Biome> tagKey : tagList) {
            String tagName = tagKey.f_203868_().toString();
            BiomeTagList biomeTagList = new BiomeTagList(tagName);
            Optional tagContents = biomeRegistry.m_203431_(tagKey);
            if (!tagContents.isEmpty()) {
                if (((HolderSet.Named)tagContents.get()).m_203632_() > 0) {
                    biomeTagList.createSubheader(BiomeTagInfoGenerator.newBiomeInfo(tagName));
                    ((HolderSet.Named)tagContents.get()).forEach(biome -> {
                        String biomeName = biomeRegistry.m_7981_((Object)((Biome)biome.get())).toString();
                        biomeTagList.addBiome(biomeName);
                    });
                } else {
                    biomeTagList.createSubheader(BiomeTagInfoGenerator.newEmptyBiomeInfo(tagName));
                }
            } else {
                BetterDefaultBiomes.LOGGER.error("No matching Biome Tag found for: {}", (Object)tagName);
            }
            allBiomeTagLists.add(biomeTagList);
        }
        Collections.sort(allBiomeTagLists);
        for (BiomeTagList biomeTagList : allBiomeTagLists) {
            masterList.add(biomeTagList.getSubheader());
            Collections.sort(biomeTagList.getBiomeList());
            masterList.addAll(biomeTagList.getBiomeList());
            masterList.add("");
        }
        ArrayList<Object> finalText = masterList;
        try {
            String fileName = "info";
            File infoFile = new File(EXTRA_INFO_FOLDER.getPath(), fileName.concat(".txt"));
            Files.write(Paths.get(infoFile.getPath(), new String[0]), finalText, StandardCharsets.UTF_8, new OpenOption[0]);
            BetterDefaultBiomes.LOGGER.debug("Finished creating Biome Tag Info File.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String newBiomeInfo(String tagName) {
        return "These Biomes are part of the \"" + tagName + "\" Biome Tag:";
    }

    private static String newEmptyBiomeInfo(String tagName) {
        return "The \"" + tagName + "\" Biome Tag does not contain any Biomes.";
    }

    private static class BiomeTagList
    implements Comparable<BiomeTagList> {
        private String name;
        private String subheader;
        private ArrayList<String> biomeList = new ArrayList();

        private BiomeTagList(String name) {
            this.name = name;
        }

        private String getName() {
            return this.name;
        }

        private String getSubheader() {
            return this.subheader;
        }

        private ArrayList<String> getBiomeList() {
            return this.biomeList;
        }

        private void createSubheader(String subheader) {
            this.subheader = subheader;
        }

        private void addBiome(String biome) {
            this.biomeList.add(biome);
        }

        @Override
        public int compareTo(BiomeTagList otherList) {
            return this.getName().compareTo(otherList.getName());
        }
    }
}

