/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.configuration.entity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import xratedjunior.betterdefaultbiomes.configuration.MobSpawningConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.util.EntityConfigHelper;
import xratedjunior.betterdefaultbiomes.configuration.entity.util.MobConfig;

public class HunterConfig
implements MobConfig {
    public static ForgeConfigSpec.IntValue weight;
    public static ForgeConfigSpec.ConfigValue<Integer> min_group;
    public static ForgeConfigSpec.ConfigValue<Integer> max_group;
    public static ForgeConfigSpec.ConfigValue<Integer> hunter_bow_drop_chance;
    public static ForgeConfigSpec.ConfigValue<List<String>> spawn_biomes;
    public static ForgeConfigSpec.BooleanValue spawn_head_hunter;
    public static ForgeConfigSpec.IntValue head_hunter_weight;
    public static ForgeConfigSpec.ConfigValue<Integer> head_hunter_firing_speed;
    public static ForgeConfigSpec.ConfigValue<Integer> head_hunter_firing_speed_hard;
    private static int spawnWeight;
    private static int mobSpawnWeightMin;
    private static int mobSpawnWeightMax;
    private static int minGroup;
    private static int maxGroup;
    private static int hunterBowDropChance;
    private static List<String> spawnBiomes;
    private static String mobName;
    private static String mobNameSpecial;
    private static boolean spawnHeadHunter;
    private static int headHunterSpawnWeight;
    private static int headHunterFiringSpeed;
    private static int headHunterFiringSpeedHard;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.comment("Config options for the Hunter and Variants.").push("Hunter");
        weight = builder.comment(EntityConfigHelper.weightComment(mobName, spawnWeight)).defineInRange("weight", spawnWeight, mobSpawnWeightMin, mobSpawnWeightMax);
        min_group = builder.comment(EntityConfigHelper.minGroupComment(mobName, minGroup)).define("min_group", (Object)minGroup);
        max_group = builder.comment(EntityConfigHelper.maxGroupComment(mobName, maxGroup)).define("max_group", (Object)maxGroup);
        hunter_bow_drop_chance = builder.comment("Drop chance for the \"Hunter's Bow\" (Default: " + hunterBowDropChance + ")").defineInRange("drop_chance", hunterBowDropChance, 0, 200);
        spawn_biomes = builder.comment(EntityConfigHelper.spawnBiomesComment(mobName)).define("spawn_biomes", spawnBiomes);
        builder.comment("The Head Hunter is a special variant of the Hunter. It's even more deadly!").push("Head_Hunter");
        spawn_head_hunter = builder.comment("Enables the spawning of the Head Hunter. (Default: " + spawnHeadHunter + ")").define("head_hunter", spawnHeadHunter);
        head_hunter_weight = builder.comment(EntityConfigHelper.weightComment(mobNameSpecial, headHunterSpawnWeight)).defineInRange("weight", headHunterSpawnWeight, mobSpawnWeightMin, mobSpawnWeightMax);
        builder.comment("This is the interval between shots.").push("Firing_Speed");
        head_hunter_firing_speed = builder.comment(new String[]{"Tweak the firing speed of the Head Hunter. (Default: " + headHunterFiringSpeed + ")", "For reference: The Vanilla Skeleton firing speed is: 40."}).define("firing_speed", (Object)headHunterFiringSpeed);
        head_hunter_firing_speed_hard = builder.comment(new String[]{"Tweak the firing speed of the Head Hunter for the Hard Difficulty. (Default: " + headHunterFiringSpeedHard + ")", "For reference: The Vanilla Skeleton firing speed for the Hard difficulty is: 20."}).define("firing_speed_hard", (Object)headHunterFiringSpeedHard);
        builder.pop();
        builder.pop(2);
    }

    @Override
    public int getWeight() {
        return (Integer)weight.get();
    }

    @Override
    public int getMinGroup() {
        return (Integer)min_group.get();
    }

    @Override
    public int getMaxGroup() {
        return (Integer)max_group.get();
    }

    @Override
    public List<String> getSpawnBiomes() {
        return (List)spawn_biomes.get();
    }

    static {
        spawnWeight = 90;
        mobSpawnWeightMin = MobSpawningConfig.mobSpawnWeightMin;
        mobSpawnWeightMax = MobSpawningConfig.mobSpawnWeightMax;
        minGroup = 1;
        maxGroup = 3;
        hunterBowDropChance = 8;
        spawnBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:is_jungle"});
        mobName = "Hunter";
        mobNameSpecial = "Head Hunter";
        spawnHeadHunter = true;
        headHunterSpawnWeight = 10;
        headHunterFiringSpeed = 20;
        headHunterFiringSpeedHard = 10;
    }
}

