/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.block.block;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.block.StarfishWallBlock;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class StarfishBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<WallFacing> WALL_FACING = EnumProperty.m_61587_((String)"wall_facing", WallFacing.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape STARFISH_FLOOR = StarfishBlock.makeSquareShape(3.0, 0.0, 1.0);
    private static final VoxelShape STARFISH_CEILING = StarfishBlock.makeSquareShape(3.0, 15.0, 16.0);
    private static final VoxelShape STARFISH_EAST = StarfishBlock.makeShape(3.0, 13.0, 0.0, 1.0, 3.0, 13.0);
    private static final VoxelShape STARFISH_WEST = StarfishBlock.makeShape(3.0, 13.0, 15.0, 16.0, 3.0, 13.0);
    private static final VoxelShape STARFISH_SOUTH = StarfishBlock.makeShape(0.0, 1.0, 3.0, 13.0, 3.0, 13.0);
    private static final VoxelShape STARFISH_NORTH = StarfishBlock.makeShape(15.0, 16.0, 3.0, 13.0, 3.0, 13.0);
    @Nullable
    private final DyeColor starfishColor;

    public StarfishBlock(@Nullable DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(properties);
        this.starfishColor = colorIn;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_(WALL_FACING, (Comparable)((Object)WallFacing.UP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)StarfishBlock.getBlockByColor(this.starfishColor));
    }

    private static VoxelShape makeSquareShape(double widthPixelOffset, double yPixelStart, double yPixelHeight) {
        return Block.m_49796_((double)widthPixelOffset, (double)yPixelStart, (double)widthPixelOffset, (double)(16.0 - widthPixelOffset), (double)yPixelHeight, (double)(16.0 - widthPixelOffset));
    }

    private static VoxelShape makeShape(double northPixelOffset, double southPixelOffset, double westPixelOffset, double eastPixelOffset, double yPixelBottom, double yPixelTop) {
        return Block.m_49796_((double)westPixelOffset, (double)yPixelBottom, (double)northPixelOffset, (double)eastPixelOffset, (double)yPixelTop, (double)southPixelOffset);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            default: {
                return STARFISH_FLOOR.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
            case CEILING: {
                return STARFISH_CEILING.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
            case WALL: 
        }
        switch (direction) {
            case EAST: {
                return STARFISH_EAST;
            }
            case WEST: {
                return STARFISH_WEST;
            }
            case SOUTH: {
                return STARFISH_SOUTH;
            }
        }
        return STARFISH_NORTH;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return StarfishBlock.m_53196_((LevelReader)worldIn, (BlockPos)pos, (Direction)StarfishBlock.m_53200_((BlockState)state).m_122424_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = this.m_49966_();
            FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
            if (direction.m_122434_() == Direction.Axis.Y) {
                blockstate = fluidstate.m_76152_() == Fluids.f_76193_ ? (BlockState)((BlockState)blockstate.m_61124_((Property)f_53179_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_()) : (BlockState)((BlockState)blockstate.m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
            } else if (fluidstate.m_76152_() == Fluids.f_76193_) {
                blockstate = StarfishBlock.getWallBlockByColor(this.starfishColor).m_49966_();
                blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            } else {
                blockstate = (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
            }
            if (!this.m_7898_(blockstate, (LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53179_, WALL_FACING, WATERLOGGED, LIT});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemStackInHand = player.m_21120_(handIn);
        Item itemInHand = itemStackInHand.m_41720_();
        boolean useItem = false;
        if (itemInHand instanceof DyeItem) {
            Block coloredStarfish;
            DyeItem dyeInHand = (DyeItem)itemInHand;
            Block starfish = state.m_60734_();
            if (starfish instanceof StarfishWallBlock) {
                coloredStarfish = StarfishBlock.getWallBlockByColor(dyeInHand.m_41089_());
                if (starfish != coloredStarfish) {
                    useItem = true;
                }
            } else {
                coloredStarfish = StarfishBlock.getBlockByColor(dyeInHand.m_41089_());
                if (starfish != coloredStarfish) {
                    useItem = true;
                }
            }
            if (useItem) {
                worldIn.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)coloredStarfish.m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)f_53179_, (Comparable)((AttachFace)state.m_61143_((Property)f_53179_)))).m_61124_(WALL_FACING, (Comparable)((Object)((WallFacing)((Object)state.m_61143_(WALL_FACING)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)))).m_61124_((Property)LIT, (Comparable)((Boolean)state.m_61143_((Property)LIT))));
            }
        } else if (itemInHand == Items.f_42525_ && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            useItem = true;
        }
        if (useItem) {
            if (!player.m_150110_().f_35937_) {
                itemStackInHand.m_41774_(1);
            }
        } else if (player.m_36326_()) {
            this.rotateBlock(player, state, worldIn, pos);
            useItem = true;
        }
        return useItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private void rotateBlock(Player player, BlockState state, Level worldIn, BlockPos pos) {
        SoundType sound = this.getSoundType(state, (LevelReader)worldIn, pos, (Entity)player);
        worldIn.m_5594_(player, pos, (SoundEvent)BDBSoundEvents.BLOCK_SMALL_ROTATE.get(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        if (this instanceof StarfishWallBlock) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_(WALL_FACING, (Comparable)((Object)WallFacing.rotateClockwise((WallFacing)((Object)state.m_61143_(WALL_FACING))))));
            return;
        }
        if (((AttachFace)state.m_61143_((Property)f_53179_)).equals((Object)AttachFace.FLOOR)) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                default: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
                    break;
                }
                case EAST: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH));
                    break;
                }
                case SOUTH: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.WEST));
                    break;
                }
                case WEST: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
                    break;
                }
            }
        } else {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                default: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.WEST));
                    break;
                }
                case EAST: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
                    break;
                }
                case SOUTH: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
                    break;
                }
                case WEST: {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH));
                }
            }
        }
    }

    public static Block getBlockByColor(@Nullable DyeColor colorIn) {
        switch (colorIn) {
            case WHITE: {
                return (Block)BDBBlocks.STARFISH_WHITE.get();
            }
            case ORANGE: {
                return (Block)BDBBlocks.STARFISH_ORANGE.get();
            }
            case MAGENTA: {
                return (Block)BDBBlocks.STARFISH_MAGENTA.get();
            }
            case LIGHT_BLUE: {
                return (Block)BDBBlocks.STARFISH_LIGHT_BLUE.get();
            }
            case YELLOW: {
                return (Block)BDBBlocks.STARFISH_YELLOW.get();
            }
            case LIME: {
                return (Block)BDBBlocks.STARFISH_LIME.get();
            }
            default: {
                return (Block)BDBBlocks.STARFISH_PINK.get();
            }
            case GRAY: {
                return (Block)BDBBlocks.STARFISH_GRAY.get();
            }
            case LIGHT_GRAY: {
                return (Block)BDBBlocks.STARFISH_LIGHT_GRAY.get();
            }
            case CYAN: {
                return (Block)BDBBlocks.STARFISH_CYAN.get();
            }
            case PURPLE: {
                return (Block)BDBBlocks.STARFISH_PURPLE.get();
            }
            case BLUE: {
                return (Block)BDBBlocks.STARFISH_BLUE.get();
            }
            case BROWN: {
                return (Block)BDBBlocks.STARFISH_BROWN.get();
            }
            case GREEN: {
                return (Block)BDBBlocks.STARFISH_GREEN.get();
            }
            case RED: {
                return (Block)BDBBlocks.STARFISH_RED.get();
            }
            case BLACK: 
        }
        return (Block)BDBBlocks.STARFISH_BLACK.get();
    }

    public static Block getWallBlockByColor(@Nullable DyeColor colorIn) {
        switch (colorIn) {
            case WHITE: {
                return (Block)BDBBlocks.STARFISH_WALL_WHITE.get();
            }
            case ORANGE: {
                return (Block)BDBBlocks.STARFISH_WALL_ORANGE.get();
            }
            case MAGENTA: {
                return (Block)BDBBlocks.STARFISH_WALL_MAGENTA.get();
            }
            case LIGHT_BLUE: {
                return (Block)BDBBlocks.STARFISH_WALL_LIGHT_BLUE.get();
            }
            case YELLOW: {
                return (Block)BDBBlocks.STARFISH_WALL_YELLOW.get();
            }
            case LIME: {
                return (Block)BDBBlocks.STARFISH_WALL_LIME.get();
            }
            default: {
                return (Block)BDBBlocks.STARFISH_WALL_PINK.get();
            }
            case GRAY: {
                return (Block)BDBBlocks.STARFISH_WALL_GRAY.get();
            }
            case LIGHT_GRAY: {
                return (Block)BDBBlocks.STARFISH_WALL_LIGHT_GRAY.get();
            }
            case CYAN: {
                return (Block)BDBBlocks.STARFISH_WALL_CYAN.get();
            }
            case PURPLE: {
                return (Block)BDBBlocks.STARFISH_WALL_PURPLE.get();
            }
            case BLUE: {
                return (Block)BDBBlocks.STARFISH_WALL_BLUE.get();
            }
            case BROWN: {
                return (Block)BDBBlocks.STARFISH_WALL_BROWN.get();
            }
            case GREEN: {
                return (Block)BDBBlocks.STARFISH_WALL_GREEN.get();
            }
            case RED: {
                return (Block)BDBBlocks.STARFISH_WALL_RED.get();
            }
            case BLACK: 
        }
        return (Block)BDBBlocks.STARFISH_WALL_BLACK.get();
    }

    public static enum WallFacing implements StringRepresentable
    {
        UP("up"),
        RIGHT("right"),
        DOWN("down"),
        LEFT("left");

        private String name;
        public static final WallFacing[] WALLFACING_DIRECTIONS;

        private WallFacing(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static WallFacing getRandomWallFacingDirection(RandomSource rand) {
            return (WallFacing)((Object)Util.m_214670_((Object[])WALLFACING_DIRECTIONS, (RandomSource)rand));
        }

        public static WallFacing rotateClockwise(WallFacing currentWallFacingDirection) {
            switch (currentWallFacingDirection) {
                default: {
                    return RIGHT;
                }
                case RIGHT: {
                    return DOWN;
                }
                case DOWN: {
                    return LEFT;
                }
                case LEFT: 
            }
            return UP;
        }

        static {
            WALLFACING_DIRECTIONS = WallFacing.values();
        }
    }
}

