/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.block.block;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.block.SimpleBlock;
import xratedjunior.betterdefaultbiomes.data.BDBTags;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class SmallRockBlock
extends SimpleBlock {
    public static final int MAX_ROCK_SIZE = 2;
    public static final IntegerProperty ROCK_SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)2);
    private static final VoxelShape ROCK_SMALL = SmallRockBlock.makeSquareShape(4.8, 2.2);
    private static final VoxelShape ROCK_MEDIUM = SmallRockBlock.makeSquareShape(3.0, 3.2);

    public SmallRockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROCK_SIZE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        switch ((Integer)state.m_61143_((Property)ROCK_SIZE)) {
            default: {
                return ROCK_SMALL.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
            case 2: 
        }
        return ROCK_MEDIUM.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ROCK_SIZE});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundBlock = worldIn.m_8055_(groundPos);
        return worldIn.m_8055_(groundPos).m_60783_((BlockGetter)worldIn, groundPos, Direction.UP) || groundBlock.m_60734_() instanceof LeavesBlock;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean swingArm = false;
        ItemStack itemStackInHand = player.m_21120_(handIn);
        Item itemInHand = itemStackInHand.m_41720_();
        if (itemInHand == this.m_5456_()) {
            if ((Integer)state.m_61143_((Property)ROCK_SIZE) == 1) {
                this.increaseBlockSize(state, worldIn, pos, player, itemStackInHand);
                swingArm = true;
            } else {
                this.decreaseBlockSize(state, worldIn, pos, player, itemInHand);
                swingArm = true;
            }
        } else {
            swingArm = super.m_6227_(state, worldIn, pos, player, handIn, hit) == InteractionResult.SUCCESS;
        }
        return swingArm ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private void increaseBlockSize(BlockState state, Level worldIn, BlockPos pos, Player player, ItemStack itemStackInHand) {
        SoundType sound = this.getSoundType(state, (LevelReader)worldIn, pos, (Entity)player);
        worldIn.m_5594_(player, pos, (SoundEvent)BDBSoundEvents.BLOCK_SMALL_ADD.get(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ROCK_SIZE, (Comparable)Integer.valueOf(2)));
        if (!player.m_150110_().f_35937_) {
            itemStackInHand.m_41774_(1);
        }
    }

    private void decreaseBlockSize(BlockState state, Level worldIn, BlockPos pos, Player player, Item itemInHand) {
        SoundType sound = this.getSoundType(state, (LevelReader)worldIn, pos, (Entity)player);
        worldIn.m_5594_(player, pos, (SoundEvent)BDBSoundEvents.BLOCK_SMALL_REMOVE.get(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ROCK_SIZE, (Comparable)Integer.valueOf(1)));
        if (!player.m_150110_().f_35937_) {
            ItemEntity item = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)itemInHand));
            worldIn.m_7967_((Entity)item);
        }
    }

    public static enum RockVariant implements StringRepresentable
    {
        STONE("stone", (Block)BDBBlocks.SMALL_ROCK_STONE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_STONE),
        COBBLE("cobble", (Block)BDBBlocks.SMALL_ROCK_COBBLE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_COBBLE),
        MOSSY("mossy", (Block)BDBBlocks.SMALL_ROCK_MOSSY.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_MOSSY),
        ANDESITE("andesite", (Block)BDBBlocks.SMALL_ROCK_ANDESITE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_ANDESITE),
        DIORITE("diorite", (Block)BDBBlocks.SMALL_ROCK_DIORITE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_DIORITE),
        GRANITE("granite", (Block)BDBBlocks.SMALL_ROCK_GRANITE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_GRANITE),
        SANDSTONE("sandstone", (Block)BDBBlocks.SMALL_ROCK_SANDSTONE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_SANDSTONE),
        RED_SANDSTONE("red_sandstone", (Block)BDBBlocks.SMALL_ROCK_RED_SANDSTONE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_RED_SANDSTONE),
        DEEPSLATE("deepslate", (Block)BDBBlocks.SMALL_ROCK_DEEPSLATE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_DEEPSLATE),
        COBBLED_DEEPSLATE("cobbled_deepslate", (Block)BDBBlocks.SMALL_ROCK_COBBLED_DEEPSLATE.get(), BDBTags.Blocks.GENERATE_SMALL_ROCK_COBBLED_DEEPSLATE);

        public static final Codec<RockVariant> CODEC;
        public static final RockVariant DEFAULT_VARIANT;
        public static final RockVariant[] ALL_VARIANTS;
        public static final RockVariant[] STONE_VARIANTS;
        private String name;
        private Block smallRock;
        private TagKey<Block> floorBlock;

        private RockVariant(String name, Block smallRock, TagKey<Block> floorBlock) {
            this.name = name;
            this.smallRock = smallRock;
            this.floorBlock = floorBlock;
        }

        public String m_7912_() {
            return this.name;
        }

        public Block getSmallRockBlock() {
            return this.smallRock;
        }

        public TagKey<Block> getPossibleFloorBlocks() {
            return this.floorBlock;
        }

        static {
            CODEC = StringRepresentable.m_216439_(RockVariant::values);
            DEFAULT_VARIANT = STONE;
            ALL_VARIANTS = RockVariant.values();
            STONE_VARIANTS = new RockVariant[]{STONE, COBBLE, MOSSY, ANDESITE, DIORITE, GRANITE};
        }
    }
}

