/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TurnAndCopyRecipeSerializer
implements RecipeSerializer<TurnAndCopyRecipe> {
    @Nonnull
    public TurnAndCopyRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ShapedRecipe basic = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
        TurnAndCopyRecipe recipe = new TurnAndCopyRecipe(recipeId, basic.m_6076_(), basic.m_44220_(), basic.m_44221_(), (NonNullList<Ingredient>)basic.m_7527_(), basic.m_8043_(null), CraftingBookCategory.MISC);
        if (GsonHelper.m_13855_((JsonObject)json, (String)"quarter_turn", (boolean)false)) {
            recipe.allowQuarterTurn();
        }
        if (GsonHelper.m_13855_((JsonObject)json, (String)"eighth_turn", (boolean)false)) {
            recipe.allowEighthTurn();
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"copy_nbt")) {
            if (GsonHelper.m_13885_((JsonObject)json, (String)"copy_nbt")) {
                JsonArray jArray = GsonHelper.m_13933_((JsonObject)json, (String)"copy_nbt");
                int[] array = new int[jArray.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = jArray.get(i).getAsInt();
                }
                recipe.setNBTCopyTargetRecipe(array);
            } else {
                recipe.setNBTCopyTargetRecipe(GsonHelper.m_13927_((JsonObject)json, (String)"copy_nbt"));
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"copy_nbt_predicate")) {
                recipe.setNBTCopyPredicate(GsonHelper.m_13906_((JsonObject)json, (String)"copy_nbt_predicate"));
            }
        }
        return recipe;
    }

    @Nonnull
    public TurnAndCopyRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int[] array;
        ShapedRecipe basic = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
        TurnAndCopyRecipe recipe = new TurnAndCopyRecipe(recipeId, basic.m_6076_(), basic.m_44220_(), basic.m_44221_(), (NonNullList<Ingredient>)basic.m_7527_(), basic.m_8043_(null), CraftingBookCategory.MISC);
        if (buffer.readBoolean()) {
            recipe.allowQuarterTurn();
        }
        if (buffer.readBoolean()) {
            recipe.allowEighthTurn();
        }
        if ((array = buffer.m_130100_()).length > 0) {
            recipe.setNBTCopyTargetRecipe(array);
            if (buffer.readBoolean()) {
                recipe.setNBTCopyPredicate(buffer.m_130136_(512));
            }
        }
        return recipe;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TurnAndCopyRecipe recipe) {
        RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.toVanilla());
        buffer.writeBoolean(recipe.isQuarterTurn());
        buffer.writeBoolean(recipe.isEightTurn());
        int[] copying = recipe.getCopyTargets();
        if (copying == null) {
            copying = new int[]{};
        }
        buffer.m_130089_(copying);
        if (copying.length > 0) {
            if (recipe.hasCopyPredicate()) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.getBufferPredicate());
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

