/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TurntableBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    private Rotation[] rotationMapping = new Rotation[]{Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_90};
    private boolean[] redstone = new boolean[]{false, false, false, false};
    private static final int[] rotationDirectionIndexMap = new int[]{0, 2, 1, 3, 1};

    public TurntableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.TURNTABLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        byte redstoneByte = nbt.m_128445_("redstone");
        byte rotationMapValue = nbt.m_128445_("rotationMapping");
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.intToRotation(rotationMapValue >> 2 * i & 3);
            this.redstone[i] = (redstoneByte & 1 << i) != 0;
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        byte rotationMapValue = 0;
        byte redstoneByte = 0;
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            rotationMapValue = (byte)(rotationMapValue + (this.rotationToInt(this.rotationMapping[i]) << 2 * i));
            if (!this.redstone[i]) continue;
            redstoneByte = (byte)(redstoneByte + (1 << i));
        }
        nbt.m_128344_("redstone", redstoneByte);
        nbt.m_128344_("rotationMapping", rotationMapValue);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int directionIndex;
        boolean r;
        super.onNeighborBlockChange(otherPos);
        Direction facing = this.getFacing();
        BlockPos difference = otherPos.m_121996_((Vec3i)this.f_58858_);
        Direction otherDir = Direction.m_122372_((float)difference.m_123341_(), (float)difference.m_123342_(), (float)difference.m_123343_());
        if (otherDir.m_122434_() != facing.m_122434_() && (r = this.f_58857_.m_276987_(this.f_58858_.m_121945_(otherDir), otherDir)) != this.redstone[directionIndex = this.getRotationDirectionIndexFromFacing(otherDir, facing)]) {
            this.redstone[directionIndex] = r;
            if (this.redstone[directionIndex]) {
                BlockPos target = this.f_58858_.m_121945_(facing);
                RotationUtil.rotateBlock(this.f_58857_, target, this.rotationMapping[directionIndex]);
            }
        }
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.m_6144_();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return !entity.m_6144_();
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        Direction facing = this.getFacing();
        if (player.m_6144_() && side.m_122434_() != facing.m_122434_()) {
            if (!this.f_58857_.f_46443_) {
                int directionIndex = this.getRotationDirectionIndexFromFacing(side, facing);
                this.rotationMapping[directionIndex] = this.intToRotation(this.rotationToInt(this.rotationMapping[directionIndex]) % 3 + 1);
                this.m_6596_();
                this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 254, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    private Rotation intToRotation(int rotationValue) {
        switch (rotationValue) {
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.CLOCKWISE_90;
    }

    private int rotationToInt(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        return 1;
    }

    private int getRotationDirectionIndexFromFacing(Direction indexee, Direction facing) {
        int index = indexee.m_122411_();
        if (facing.m_122411_() < index) {
            index -= 2;
        }
        if (index >= 2 && facing.m_122421_() == Direction.AxisDirection.POSITIVE != (facing.m_122434_() == Direction.Axis.Z)) {
            ++index;
        }
        return rotationDirectionIndexMap[index];
    }

    public Rotation getRotationFromSide(Direction side) {
        Direction facing = this.getFacing();
        if (side.m_122434_() == facing.m_122434_()) {
            return Rotation.NONE;
        }
        return this.rotationMapping[this.getRotationDirectionIndexFromFacing(side, facing)];
    }

    public void rotateRotationMap(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return;
        }
        int offset = this.rotationToInt(rotation);
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            this.rotationMapping[i] = this.rotationMapping[Math.floorMod(i - offset, this.rotationMapping.length)];
        }
    }

    public void verticalTransitionRotationMap(Direction facingOld, Direction facingNew) {
        Direction horizontalFacing;
        boolean toVert = false;
        if (facingNew.m_122434_() == Direction.Axis.Y) {
            toVert = true;
        }
        if (facingOld.m_122434_() == Direction.Axis.Y == toVert) {
            return;
        }
        Direction direction = horizontalFacing = toVert ? facingOld : facingNew;
        int offset = horizontalFacing.m_122434_() == Direction.Axis.Z ? (facingNew.m_122421_() == facingOld.m_122421_() ? 2 : 0) : (horizontalFacing.m_122421_() == Direction.AxisDirection.POSITIVE == toVert ? 3 : 1);
        Rotation[] oldRotMap = (Rotation[])this.rotationMapping.clone();
        boolean[] oldRedstone = (boolean[])this.redstone.clone();
        for (int i = 0; i < this.rotationMapping.length; ++i) {
            int sourceIndex = Math.floorMod(i + offset, this.rotationMapping.length);
            this.rotationMapping[i] = oldRotMap[sourceIndex];
            this.redstone[i] = oldRedstone[sourceIndex];
        }
    }
}

