/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class CircuitTableBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IInteractionObjectIE<CircuitTableBlockEntity>,
IModelOffsetProvider {
    public static final BlockPos MASTER_POS = BlockPos.f_121853_;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    public static final String[] SLOT_TYPES = new String[]{"backplane", "logic", "solder"};
    public static final int ASSEMBLY_ENERGY = 5000;
    public static final int ENERGY_CAPACITY = 32000;
    public static final int NUM_SLOTS = SLOT_TYPES.length + 1;
    public final MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)NUM_SLOTS, (Object)ItemStack.f_41583_);
    private AABB renderAABB;
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, CircuitTableBlockEntity::master, this.registerEnergyInput(this.energyStorage));

    public CircuitTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CIRCUIT_TABLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (!descPacket) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        if (!descPacket) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    public static int getEditSlot() {
        return SLOT_TYPES.length;
    }

    public static int getIngredientAmount(LogicCircuitHandler.LogicCircuitInstruction instruction, int slot) {
        return switch (slot) {
            case 0 -> 1;
            case 1 -> instruction.getOperator().getComplexity();
            case 2 -> (int)Math.ceil((float)(instruction.getOperator().getComplexity() + instruction.getInputs().length + 1) / 2.0f);
            default -> -1;
        };
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AABB((double)(this.m_58899_().m_123341_() - 1), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - 1), (double)(this.m_58899_().m_123341_() + 2), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 2));
        }
        return this.renderAABB;
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public CircuitTableBlockEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public IEMenuTypes.ArgContainer<CircuitTableBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CIRCUIT_TABLE;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    @Nullable
    public CircuitTableBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE != null) {
            return (CircuitTableBlockEntity)this.tempMasterBE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        BlockPos masterPos = this.m_58899_().m_121945_(dummyDir);
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return te instanceof CircuitTableBlockEntity ? (CircuitTableBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        DeskBlock.placeDummies(this.m_58900_(), this.f_58857_, this.f_58858_, ctx);
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        Direction dummyDir = this.isDummy() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        this.f_58857_.m_7471_(pos.m_121945_(dummyDir), false);
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return DUMMY_POS;
        }
        return MASTER_POS;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side == this.getFacing() && this.isDummy())) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(cap, side);
    }
}

