/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SiloShapes;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SiloLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    private static final int MAX_STORAGE = 41472;
    public static final BlockPos OUTPUT_POS = new BlockPos(1, 0, 1);
    private static final Set<BlockPos> IO_OFFSETS = Set.of(OUTPUT_POS, new BlockPos(1, 6, 1));

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        state.comparatorHelper.update(context, state.storageAmount);
        if (state.identStack.m_41619_() || state.storageAmount <= 0) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!level.shouldTickModulo(8) || !state.rsState.isEnabled(context)) {
            return;
        }
        for (CapabilityReference<IItemHandler> output : state.outputs) {
            ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)state.identStack, (int)1);
            if (!(stack = Utils.insertStackIntoInventory(output, stack, false)).m_41619_()) continue;
            --state.storageAmount;
            if (state.storageAmount <= 0) {
                state.identStack = ItemStack.f_41583_;
            }
            context.markMasterDirty();
            context.requestMasterBESync();
            if (state.storageAmount > 0) continue;
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && IO_OFFSETS.contains(position.posInMultiblock())) {
            return ctx.getState().inputHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SiloShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public ItemStack identStack = ItemStack.f_41583_;
        public int storageAmount = 0;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        private final LayeredComparatorOutput<IMultiblockContext<?>> comparatorHelper = LayeredComparatorOutput.makeForSiloLike(41472, 6);
        private final List<CapabilityReference<IItemHandler>> outputs;
        private final StoredCapability<IItemHandler> inputHandler;

        public State(IInitialMultiblockContext<State> capabilitySource) {
            ImmutableList.Builder outputBuilder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.values()) {
                if (face == RelativeBlockFace.DOWN) continue;
                BlockPos neighbor = face.offsetRelative(OUTPUT_POS, -1);
                outputBuilder.add(capabilitySource.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, neighbor, face));
            }
            this.outputs = outputBuilder.build();
            this.inputHandler = new StoredCapability<InventoryHandler>(new InventoryHandler(this, () -> {
                capabilitySource.getMarkDirtyRunnable().run();
                capabilitySource.getSyncRunnable().run();
            }));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("identStack", (Tag)this.identStack.m_41739_(new CompoundTag()));
            nbt.m_128405_("count", this.storageAmount);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.identStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("identStack"));
            this.storageAmount = nbt.m_128451_("count");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }
    }

    private record InventoryHandler(State state, Runnable onChange) implements IItemHandler
    {
        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.state.identStack, (int)this.state.storageAmount);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int space = 41472 - this.state.storageAmount;
            if (slot != 0 || space < 1 || stack.m_41619_() || !this.state.identStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.state.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.m_41613_());
            if (!simulate) {
                this.state.storageAmount += accepted;
                if (this.state.identStack.m_41619_()) {
                    this.state.identStack = stack.m_41777_();
                }
                this.onChange.run();
            }
            stack = stack.m_41777_();
            stack.m_41774_(accepted);
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1 || this.state.storageAmount < 1 || amount < 1 || this.state.identStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int returned = Math.min(Math.min(this.state.storageAmount, amount), this.state.identStack.m_41741_());
            ItemStack out = ItemHandlerHelper.copyStackWithSize((ItemStack)this.state.identStack, (int)returned);
            if (!simulate) {
                this.state.storageAmount -= out.m_41613_();
                if (this.state.storageAmount <= 0) {
                    this.state.identStack = ItemStack.f_41583_;
                }
                this.onChange.run();
            }
            return out;
        }

        public int getSlotLimit(int slot) {
            return 41472;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }
}

