/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.LightningRodShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class LightningRodLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final BlockPos MASTER_OFFSET = new BlockPos(1, 1, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        BlockPos strikePosition;
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        if (state.energy.getEnergyStored() > 0) {
            for (CapabilityReference outputRef : state.energyOutputs) {
                IEnergyStorage output = (IEnergyStorage)outputRef.getNullable();
                if (output == null) continue;
                int accepted = output.receiveEnergy(state.energy.getEnergyStored(), false);
                state.energy.modifyEnergyStored(-accepted);
            }
        }
        if (level.shouldTickModulo(256)) {
            state.fenceNet = null;
        }
        if (state.fenceNet == null) {
            state.fenceNet = LightningRodLogic.getFenceNet(level.getRawLevel(), level.toAbsolute(MASTER_OFFSET));
        }
        if (state.fenceNet.isValid() && level.shouldTickModulo(128) && (level.isThundering() || level.isRaining() && ApiUtils.RANDOM.nextInt(10) == 0) && (strikePosition = state.fenceNet.getAbsoluteStrikePosition(level)) != null) {
            state.energy.setStoredEnergy((Integer)IEServerConfig.MACHINES.lightning_output.get());
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(level.getRawLevel());
            lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)strikePosition));
            lightningboltentity.m_20874_(true);
            level.getRawLevel().m_7967_((Entity)lightningboltentity);
        }
    }

    @Nonnull
    private static FenceNet getFenceNet(Level level, BlockPos absoluteMasterPos) {
        int height = 0;
        boolean broken = false;
        BlockPos lastFence = null;
        for (int i = absoluteMasterPos.m_123342_() + 2; i < level.m_151558_() - 1; ++i) {
            BlockPos pos = new BlockPos(absoluteMasterPos.m_123341_(), i, absoluteMasterPos.m_123343_());
            if (!broken && LightningRodLogic.isFence(level, pos)) {
                ++height;
                lastFence = pos;
                continue;
            }
            if (!level.m_46859_(pos)) {
                return FenceNet.INVALID;
            }
            if (broken) continue;
            broken = true;
        }
        if (lastFence == null) {
            return FenceNet.INVALID;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(lastFence);
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && LightningRodLogic.isFence(level, next)) {
                closedList.add(next);
                openList.add(next.m_121945_(Direction.WEST));
                openList.add(next.m_121945_(Direction.EAST));
                openList.add(next.m_121945_(Direction.NORTH));
                openList.add(next.m_121945_(Direction.SOUTH));
                openList.add(next.m_121945_(Direction.UP));
            }
            openList.remove(0);
        }
        return new FenceNet(height, closedList);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        BlockPos posInMultiblock = position.posInMultiblock();
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || posInMultiblock.m_123342_() == 1 && (posInMultiblock.m_123341_() + posInMultiblock.m_123343_()) % 2 == 1)) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, state.energyCap.get(ctx));
        }
        return LazyOptional.empty();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return LightningRodShapes.SHAPE_GETTER;
    }

    private static boolean isFence(Level level, BlockPos pos) {
        return Utils.isBlockAt(level, pos, (Block)IEBlocks.MetalDecoration.STEEL_FENCE.get());
    }

    public static class State
    implements IMultiblockState {
        private final MutableEnergyStorage energy;
        private final ImmutableList<CapabilityReference<IEnergyStorage>> energyOutputs;
        @Nullable
        private FenceNet fenceNet;
        private final StoredCapability<IEnergyStorage> energyCap;

        public State(IInitialMultiblockContext<State> capabilitySource) {
            this.energy = new MutableEnergyStorage((Integer)IEServerConfig.MACHINES.lightning_output.get());
            this.fenceNet = null;
            this.energyCap = new StoredCapability<MutableEnergyStorage>(this.energy);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.HORIZONTAL) {
                builder.add(capabilitySource.getCapabilityAt(ForgeCapabilities.ENERGY, face.offsetRelative(MASTER_OFFSET, 2), face.getOpposite()));
            }
            this.energyOutputs = builder.build();
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            EnergyHelper.serializeTo(this.energy, nbt);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            EnergyHelper.deserializeFrom(this.energy, nbt);
        }
    }

    private record FenceNet(int height, List<BlockPos> absoluteFencePositions) {
        public static final FenceNet INVALID = new FenceNet(0, List.of());

        public boolean isValid() {
            return !this.absoluteFencePositions.isEmpty();
        }

        public BlockPos getAbsoluteStrikePosition(IMultiblockLevel level) {
            int i = this.height + this.absoluteFencePositions.size();
            int masterY = level.getAbsoluteOrigin().m_123342_();
            if (ApiUtils.RANDOM.nextInt(4096 * level.getMaxBuildHeight()) < i * (masterY + i)) {
                return this.absoluteFencePositions.get(ApiUtils.RANDOM.nextInt(this.absoluteFencePositions.size()));
            }
            return null;
        }
    }
}

