/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.util;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public record MultiblockOrientation(Direction front, boolean mirrored) {
    public MultiblockOrientation {
        Preconditions.checkArgument((boolean)front.m_122434_().m_122479_());
    }

    public MultiblockOrientation(BlockState blockState, boolean mirrorable) {
        this((Direction)blockState.m_61143_((Property)IEProperties.FACING_HORIZONTAL), mirrorable && (Boolean)blockState.m_61143_((Property)IEProperties.MIRRORED) != false);
    }

    public BlockPos getAbsoluteOffset(BlockPos offsetInMB) {
        return TemplateMultiblock.getAbsoluteOffset(offsetInMB, this.mirrored, this.front);
    }

    public Vec3 getAbsoluteOffset(Vec3 relative) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(Direction.NORTH, this.front);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74377_(this.mirrored ? Mirror.FRONT_BACK : Mirror.NONE).m_74379_(Objects.requireNonNull(rot));
        return StructureTemplate.transformedVec3d((StructurePlaceSettings)settings, (Vec3)relative);
    }

    public BlockPos getPosInMB(BlockPos absoluteOffset) {
        Rotation rot = DirectionUtils.getRotationBetweenFacings(this.front, Direction.NORTH);
        if (rot == null) {
            return BlockPos.f_121853_;
        }
        BlockPos withoutRotation = TemplateMultiblock.getAbsoluteOffset(absoluteOffset, Mirror.NONE, rot);
        return TemplateMultiblock.getAbsoluteOffset(withoutRotation, this.mirrored ? Mirror.FRONT_BACK : Mirror.NONE, Rotation.NONE);
    }

    public VoxelShape transformRelativeShape(VoxelShape relative) {
        VoxelShape ret = Shapes.m_83040_();
        for (AABB aabb : relative.m_83299_()) {
            AABB newBox = CachedShapesWithTransform.withFacingAndMirror(aabb, this.front, this.mirrored);
            ret = Shapes.m_83148_((VoxelShape)ret, (VoxelShape)Shapes.m_83064_((AABB)newBox), (BooleanOp)BooleanOp.f_82695_);
        }
        return ret.m_83296_();
    }
}

