/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class ArcRecyclingChecker {
    private final Object2BooleanMap<Item> knownItemValidity = new Object2BooleanOpenHashMap();
    private static final Set<RecipeType<?>> RECYCLING_RECIPE_TYPES = new HashSet();
    private static final List<BiPredicate<RegistryAccess, ItemStack>> RECYCLING_ALLOWED_STACK_SENSITIVE = new ArrayList<BiPredicate<RegistryAccess, ItemStack>>();
    private static final List<BiPredicate<RegistryAccess, Item>> RECYCLING_ALLOWED = new ArrayList<BiPredicate<RegistryAccess, Item>>();
    private static final List<Function<RegistryAccess, Stream<Item>>> RECYCLING_ALLOWED_ENUMERATED = new ArrayList<Function<RegistryAccess, Stream<Item>>>();
    private static final List<BiPredicate<RegistryAccess, ItemStack>> INVALID_RECYCLING_OUTPUTS = new ArrayList<BiPredicate<RegistryAccess, ItemStack>>();

    public ArcRecyclingChecker(RegistryAccess tags) {
        RECYCLING_ALLOWED_ENUMERATED.stream().flatMap(f -> (Stream)f.apply(tags)).filter(item -> !item.m_204114_().m_203656_(IETags.recyclingBlacklist)).forEach(i -> this.knownItemValidity.put(i, true));
    }

    public boolean isAllowed(RegistryAccess tags, ItemStack stack) {
        if (stack.m_204117_(IETags.recyclingBlacklist)) {
            return false;
        }
        if (this.knownItemValidity.computeIfAbsent((Object)stack.m_41720_(), i -> RECYCLING_ALLOWED.stream().anyMatch(p -> p.test(tags, i)))) {
            return true;
        }
        for (BiPredicate<RegistryAccess, ItemStack> stackSensitive : RECYCLING_ALLOWED_STACK_SENSITIVE) {
            if (!stackSensitive.test(tags, stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowEnumeratedItemsForRecycling(Function<RegistryAccess, Stream<Item>> getAllowedItems) {
        RECYCLING_ALLOWED_ENUMERATED.add(getAllowedItems);
    }

    public static void allowEnumeratedItemsForRecycling(Supplier<Stream<? extends ItemLike>> getAllowedItems) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((RegistryAccess $) -> ((Stream)getAllowedItems.get()).map(ItemLike::m_5456_));
    }

    public static void allowPrefixedTagForRecycling(String prefix) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((RegistryAccess tags) -> tags.m_175515_(Registries.f_256913_).m_203612_().filter(e -> ((TagKey)e.getFirst()).f_203868_().m_135815_().startsWith(prefix)).map(Pair::getSecond).flatMap(HolderSet::m_203614_).map(Holder::m_203334_));
    }

    public static void allowItemTagForRecycling(TagKey<Item> tagKey) {
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling((RegistryAccess tags) -> TagUtils.elementStream(tags.m_175515_(Registries.f_256913_), tagKey));
    }

    public static void allowSimpleItemForRecycling(BiPredicate<RegistryAccess, Item> predicate) {
        RECYCLING_ALLOWED.add(predicate);
    }

    public static void allowSimpleItemForRecycling(Predicate<Item> predicate) {
        RECYCLING_ALLOWED.add(($, item) -> predicate.test((Item)item));
    }

    public static void allowRecipeTypeForRecycling(RecipeType<?> recipeType) {
        RECYCLING_RECIPE_TYPES.add(recipeType);
    }

    public static void allowItemForRecycling(BiPredicate<RegistryAccess, ItemStack> predicate) {
        RECYCLING_ALLOWED_STACK_SENSITIVE.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(BiPredicate<RegistryAccess, ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(predicate);
    }

    public static void makeItemInvalidRecyclingOutput(Predicate<ItemStack> predicate) {
        INVALID_RECYCLING_OUTPUTS.add(($, stack) -> predicate.test((ItemStack)stack));
    }

    public static Pair<Predicate<Recipe<?>>, ArcRecyclingChecker> assembleRecyclingFilter(RegistryAccess tags) {
        ArcRecyclingChecker checker = new ArcRecyclingChecker(tags);
        return Pair.of(iRecipe -> {
            if (!RECYCLING_RECIPE_TYPES.contains(iRecipe.m_6671_())) {
                return false;
            }
            return checker.isAllowed(tags, iRecipe.m_8043_(tags));
        }, (Object)checker);
    }

    public static boolean isValidRecyclingOutput(RegistryAccess tags, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (BiPredicate<RegistryAccess, ItemStack> predicate : INVALID_RECYCLING_OUTPUTS) {
            if (!predicate.test(tags, stack)) continue;
            return false;
        }
        return true;
    }
}

